<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class UserGroupController extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->model('admin/CommonModel');
        $this->load->model('admin/UserGroup/UserGroupModel');
        $this->load->library('form_validation');
    }

    //View User Group Data Table View
    public function index() {
        if ($this->session->userdata('user_Id') != '') {
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 2;
            $data['active_submenu'] = 1;

            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            //  $data['user_group_right'] = $this->UserGroupModel->user_right();


            $data['user_group'] = $this->UserGroupModel->get_user_group();

            $this->load->view('admin/UserGroup/UserGroupsList', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function CreateNew() {
        if ($this->session->userdata('user_Id') != '') {
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 2;
            $data['active_submenu'] = 1;
            $data['error'] = '';

            //Locals =========================================================================
            $data['user_group_id_val'] = 0;
            $data['user_group_name_val'] = '';
            $data['user_group_description_val'] = '';

            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            // $data['user_group_right'] = $this->UserGroupModel->user_right();
            $data['user_right_main_menu_name'] = $this->UserGroupModel->user_right_main_menu_name();
            //  $data['user_group'] = $this->UserGroupModel->get_user_group();
            $data['user_group_right'] = $this->UserGroupModel->load_user_right(-1);



            $this->load->view('admin/UserGroup/UserGroup', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function Load($group_id) {
        if ($this->session->userdata('user_Id') != '') {
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 2;
            $data['active_submenu'] = 1;
            $data['error'] = '';


            $group_data = $this->UserGroupModel->load_user_group($group_id);

            foreach ($group_data AS $row) {
                $data['user_group_id_val'] = $row['user_group_Id'];
                $data['user_group_name_val'] = trim($row['user_group_name']);
                $data['user_group_description_val'] = trim($row['description']);
            }

            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            // $data['user_group_right'] = $this->UserGroupModel->user_right();
            $data['user_right_main_menu_name'] = $this->UserGroupModel->user_right_main_menu_name();

            $data['user_group_right'] = $this->UserGroupModel->load_user_right($group_id);



            $this->load->view('admin/UserGroup/UserGroup', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    //Save User Group data function
    public function SaveUserGroup() {
        if ($this->session->userdata('user_Id') != '') {
            $user_Id = $this->session->userdata('user_Id');
            $data['active_menu'] = 2;
            $data['active_submenu'] = 1;
            $data['error'] = '';

            $data['user_right'] = $this->CommonModel->logged_user_right($user_Id);
            $data['profile'] = $this->CommonModel->profile($user_Id);
            $usergroupId = $this->input->post('user_group_Id');
            $data['user_right_main_menu_name'] = $this->UserGroupModel->user_right_main_menu_name();
            $data['user_group_right'] = $this->UserGroupModel->load_user_right($usergroupId);


            //Locals =========================================================================
            $data['user_group_name_val'] = trim($this->input->post('UserGroupName'));
            $data['user_group_description_val'] = trim($this->input->post('UserGroupDescription'));
            $data['user_group_id_val'] = trim($this->input->post('user_group_Id'));


            //validations =========================================================================
            if (strlen(trim($this->input->post('UserGroupName'))) == 0) {
                $data['error'] = "Unable to find Group Name";
                $this->load->view('admin/UserGroup/UserGroup', $data);
                return;
            }

            If (self::usergroup_exists(trim($this->input->post('UserGroupName')), $usergroupId)) {
                $data['error'] = "Group Name Already Added.";
                $this->load->view('admin/UserGroup/UserGroup', $data);
                return;
            }

            if (strlen(trim($this->input->post('UserGroupDescription'))) == 0) {
                $data['error'] = "Unable to find Group Description";
                $this->load->view('admin/UserGroup/UserGroup', $data);
                return;
            }

            $unit_id = $this->input->post('UserRightName');
            if (count($unit_id) == 0) {
                $data['error'] = "Unable to find any right. Please select atleast one(1) right.";
                $this->load->view('admin/UserGroup/UserGroup', $data);
                return;
            }

            $dataSave = array(
                'user_group_name' => $this->input->post('UserGroupName'),
                'description' => $this->input->post('UserGroupDescription'),
                'create_user_Id' => $user_Id,
                'create_datetime' => date('Y-m-d H:i:s')
            );

            if ($usergroupId > 0) {
                $this->UserGroupModel->updateUserGroup($dataSave, $usergroupId);
                $query = ("Delete from tbl_user_group_rights where user_group_Id = " . $usergroupId);
                $this->db->query($query);
            } else {
                $usergroupId = $this->UserGroupModel->saveUserGroup($dataSave);
                $this->createLog('User Group', $this->loginId, 'Update', $usergroupId);
            }

            $records = array();
            for ($i = 0; $i < count($unit_id); $i++) {
                $records[] = array('user_group_Id' => $usergroupId, 'create_user_Id' => $user_Id, 'user_right_id' => $unit_id[$i]);
            }

            
            if ($usergroupId > 0) {
                $this->createLog('User Group', $this->loginId, 'Update', $usergroupId);
            } else {
                $this->createLog('User Group', $this->loginId, 'Insert', $usergroupId);
            }

           
            foreach ($records as $key => $value) {
                $query = "insert into tbl_user_group_rights (user_group_Id, user_right_id,create_user_Id) values ('" . $value['user_group_Id'] . "','" . $value['user_right_id'] . "','" . $value['create_user_Id'] . "')";
                $this->db->query($query);
            }


            

            $data['user_group'] = $this->UserGroupModel->get_user_group();
            $this->load->view('admin/UserGroup/UserGroupsList', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    //validate duplicate user group
    public function check_user_group() {
        if (array_key_exists('UserGroupName', $_POST)) {
            if ($this->usergroup_exists($this->input->post('UserGroupName')) == TRUE) {
                echo json_encode(FALSE);
            } else {
                echo json_encode(TRUE);
            }
        }
    }

    //validate duplicate user group
    private function usergroup_exists($UserGroupName, $usergroupId) {
        $this->db->where('user_group_name', $UserGroupName);
        $this->db->where_not_in('user_group_Id', $usergroupId);
        $query = $this->db->get('tbl_user_groups');
        if ($query->num_rows() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

//load user right
    public function load_user_right() {
        $user_group_Id = $_REQUEST['_user_group_Id'];
        $data = $this->UserGroupModel->load_user_right($user_group_Id);
        echo json_encode($data);
    }

    public function test() {
       
        $data = $this->UserGroupModel->get_user_group();
      
        echo json_encode(  $data->result_array());
    }

    public function load_user_group() {
        $user_group_Id = $_REQUEST['_user_group_Id'];
        $data = $this->UserGroupModel->load_user_group($user_group_Id);
        echo json_encode($data);
    }

    //Load User Gorup Id
    public function load_user_right_id() {
        $user_group_Id = $_REQUEST['_user_group_Id'];
        $data = $this->UserGroupModel->load_user_right_id($user_group_Id);
        echo json_encode($data);
    }

}
