<?php
defined('BASEPATH') OR exit('No direct script access allowed');


use Dompdf\Dompdf;
use Dompdf\Options;

class PdfGenerator
{
    public function generate($html, $filename = 'document.pdf')
    {
        // Configure Dompdf according to your needs
        $options = new Options();
        $options->set('isRemoteEnabled', true); // Enable loading of remote files (e.g., images)
        
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'landscape');
        $dompdf->render();
        $dompdf->stream($filename, array("Attachment" => false)); // Set Attachment to true for download
    }
}
