<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class DashboardModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Get patient count and last patient id
    public function patient_count_and_last_patient_id()
    {
        return $this->db->select('COUNT(`patient_id`) AS `totla_patients`, MAX(`patient_id`) AS `last_patient_id`')
            ->from('tbl_patients')
            ->where('deleted', 0)
            ->order_by('patient_id', 'DESC')
            ->limit(1)
            ->get()
            ->row();
    }

    // Get employee wise counts
    public function get_employee_counts()
    {
        return $this->db
            ->select('
        COUNT(CASE WHEN tbl_designations.designation = "Doctor" THEN `user_id` END) AS total_doctors,
        COUNT(CASE WHEN tbl_designations.designation = "Nurse" THEN `user_id` END) AS total_nurses,
    ')
            ->from('tbl_users')
            ->join('tbl_designations', 'tbl_users.designation_id = tbl_designations.designation_id')
            ->where('deleted', 0)
            ->group_by('tbl_designations.designation_id')
            ->get()
            ->row();
    }

    // Get available SMS count
    public function get_available_sms_count()
    {
        return 0;
    }

    // Get available appoinment count for today
    public function get_available_appoinments_for_today()
    {
        return $this->db->select('COUNT(`app_patient_id`) AS `avialable_confirmed_appoinment`')
            ->from('tbl_appointment_patient_info')
            ->join('tbl_appointment', 'tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id')
            ->where('tbl_appointment_patient_info.deleted', 0)
            ->where("tbl_appointment.appointment_date = CURDATE()")
            ->get()
            ->row();
    }

    /*
     **************************
     * Get data for chart
     * 
     */

    // Get appoinments for current year monthly wise
    public function get_this_year_appoinments()
    {

        // return $this->db
        //     ->select('
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 1 THEN tbl_appointment.appointment_date END) AS january,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 2 THEN tbl_appointment.appointment_date END) AS february,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 3 THEN tbl_appointment.appointment_date END) AS march,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 4 THEN tbl_appointment.appointment_date END) AS april,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 5 THEN tbl_appointment.appointment_date END) AS may,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 6 THEN tbl_appointment.appointment_date END) AS june,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 7 THEN tbl_appointment.appointment_date END) AS july,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 8 THEN tbl_appointment.appointment_date END) AS august,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 9 THEN tbl_appointment.appointment_date END) AS september,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 10 THEN tbl_appointment.appointment_date END) AS october,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 11 THEN tbl_appointment.appointment_date END) AS november,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 12 THEN tbl_appointment.appointment_date END) AS december
        // ')
        //     ->from('tbl_appointment_patient_info')
        //     ->join('tbl_appointment', 'tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id')
        //     ->where('tbl_appointment_patient_info.deleted', 0)
        //     ->where("YEAR(tbl_appointment.appointment_date) = YEAR(CURDATE())")
        //     ->group_by('YEAR(tbl_appointment.appointment_date), MONTH(tbl_appointment.appointment_date)')
        //     ->get()
        //     ->row();
        return $this->db
            ->select('
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 1 THEN 1 ELSE 0 END) AS january,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 2 THEN 1 ELSE 0 END) AS february,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 3 THEN 1 ELSE 0 END) AS march,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 4 THEN 1 ELSE 0 END) AS april,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 5 THEN 1 ELSE 0 END) AS may,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 6 THEN 1 ELSE 0 END) AS june,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 7 THEN 1 ELSE 0 END) AS july,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 8 THEN 1 ELSE 0 END) AS august,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 9 THEN 1 ELSE 0 END) AS september,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 10 THEN 1 ELSE 0 END) AS october,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 11 THEN 1 ELSE 0 END) AS november,
                    SUM(CASE WHEN MONTH(tbl_appointment.appointment_date) = 12 THEN 1 ELSE 0 END) AS december
                ')
            ->from('tbl_appointment_patient_info')
            ->join('tbl_appointment', 'tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id')
            ->where('tbl_appointment_patient_info.deleted', 0)
            ->where("YEAR(tbl_appointment.appointment_date) = YEAR(CURDATE())")
            ->group_by('YEAR(tbl_appointment.appointment_date)')
            ->get()
            ->row();
    }

    public function get_this_year_treatments()
    {

        // return $this->db
        //     ->select('
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 1 THEN tbl_appointment.appointment_date END) AS january,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 2 THEN tbl_appointment.appointment_date END) AS february,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 3 THEN tbl_appointment.appointment_date END) AS march,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 4 THEN tbl_appointment.appointment_date END) AS april,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 5 THEN tbl_appointment.appointment_date END) AS may,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 6 THEN tbl_appointment.appointment_date END) AS june,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 7 THEN tbl_appointment.appointment_date END) AS july,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 8 THEN tbl_appointment.appointment_date END) AS august,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 9 THEN tbl_appointment.appointment_date END) AS september,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 10 THEN tbl_appointment.appointment_date END) AS october,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 11 THEN tbl_appointment.appointment_date END) AS november,
        //     COUNT(CASE WHEN MONTH(tbl_appointment.appointment_date) = 12 THEN tbl_appointment.appointment_date END) AS december
        // ')
        //     ->from('tbl_appointment_patient_info')
        //     ->join('tbl_appointment', 'tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id')
        //     ->where('tbl_appointment_patient_info.deleted', 0)
        //     ->where("YEAR(tbl_appointment.appointment_date) = YEAR(CURDATE())")
        //     ->where('tbl_appointment.app_treat_id IS NOT NULL')
        //     ->group_by('YEAR(tbl_appointment.appointment_date), MONTH(tbl_appointment.appointment_date)')
        //     ->get()
        //     ->row();
        return $this->db
            ->select('
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 1) AS january,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 2) AS february,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 3) AS march,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 4) AS april,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 5) AS may,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 6) AS june,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 7) AS july,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 8) AS august,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 9) AS september,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 10) AS october,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 11) AS november,
                        SUM(MONTH(tbl_treatment_payment.treat_date) = 12) AS december
                    ')
            ->from('tbl_treatment_payment')
            ->where('tbl_treatment_payment.deleted', 0)
            ->where("YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())")
            ->get()
            ->row();
    }

    /**
     * *************************
     * Get data for appoinment section
     * 
     */

    public function get_appoinment_counts($type = null)
    {
        switch ($type) {
            case 'today':
                $filter = 'tbl_appointment.appointment_date = CURDATE()';
                break;
            case 'month':
                $filter = 'MONTH(tbl_appointment.appointment_date) = MONTH(CURDATE())';
                break;
            case 'year':
                $filter = 'YEAR(tbl_appointment.appointment_date) = YEAR(CURDATE())';
                break;
            default:
                $filter = 'tbl_appointment.appointment_date = CURDATE()';
                break;
        }

        return $this->db->select('COUNT(`app_patient_id`) AS `avialable_confirmed_appoinment`')
            ->from('tbl_appointment_patient_info')
            ->join('tbl_appointment', 'tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id')
            ->where('tbl_appointment_patient_info.deleted', 0)
            ->where($filter)
            ->get()
            ->row();
    }

    public function get_sales_counts($type = null)
    {
        
        $select = '(
            SUM(tbl_treatment_payment.total)
    		- SUM(tbl_treatment_payment.discount)
            - IFNULL(SUM(discount_summary.discount), 0)
    		- IFNULL(SUM(discount_summary.c_discount), 0)
    		- IFNULL(SUM(discount_summary.com_discount), 0)
    		- IFNULL(SUM(discount_summary.poi_discount), 0)
    		- IFNULL(SUM(discount_summary.cou_discount), 0)
        ) AS total, CONCAT(tbl_treatment_payment.treat_date, " ", tbl_treatment_payment.treat_time) AS pay_date';

        switch ($type) {
            case 'today':
                $filter = 'tbl_treatment_payment.treat_date = CURDATE()';
                $group = 'tbl_treatment_payment.treatement_payment_id';
                break;
            case 'month':
                $filter = 'MONTH(tbl_treatment_payment.treat_date) = MONTH(CURDATE()) AND YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())';
                $group = 'DATE(tbl_treatment_payment.treat_date)';
                break;
            case 'year':
                $filter = 'YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())';
                $group = 'MONTH(tbl_treatment_payment.treat_date)';
                break;
            case 'week':
                $filter = 'WEEK(tbl_treatment_payment.treat_date, 1) = WEEK(CURDATE(), 1) AND YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())';
                $group = 'WEEK(tbl_treatment_payment.treat_date)';
                break;
            case 'last_month':
                $filter = 'YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE()) AND MONTH(tbl_treatment_payment.treat_date) = MONTH(CURDATE() - INTERVAL 1 MONTH)';
                $group = 'tbl_treatment_payment.treatement_payment_id';
                break;
            default:
        }

        $this->db->select($select);
        $this->db->from('tbl_treatment_payment');
        $this->db->join(
            '(SELECT treatment_payment_id, 
                     SUM(discount) AS discount, 
                     SUM(category_discount) AS c_discount,
                     SUM(company_discount) AS com_discount,
                     SUM(points_discount) AS poi_discount,
                     SUM(coupon_discount) AS cou_discount,
                     SUM(cash) AS total_cash 
              FROM tbl_patient_payment 
              GROUP BY treatment_payment_id) AS discount_summary',
            'discount_summary.treatment_payment_id = tbl_treatment_payment.treatement_payment_id',
            'left'
        );
        
        $this->db->where($filter);
        if ($group != '') {
            $this->db->group_by($group);
        }

        $this->db->order_by('tbl_treatment_payment.treat_time', 'ASC');
        $this->db->order_by('tbl_treatment_payment.treat_date', 'ASC');

        // Get the result
        $result = $this->db->get();

        // Check if there is a result
        if ($result->num_rows() > 0) {
            return $result->result_array();
        } else {
            return null; // or handle the case when there is no result
        }
    }

    public function get_balance_counts($type)
    {
       
    $select = '(
            SUM(tbl_treatment_payment.total)
    		- SUM(tbl_treatment_payment.discount)
            - IFNULL(SUM(discount_summary.discount), 0)
    		- IFNULL(SUM(discount_summary.c_discount), 0)
    		- IFNULL(SUM(discount_summary.com_discount), 0)
    		- IFNULL(SUM(discount_summary.poi_discount), 0)
    		- IFNULL(SUM(discount_summary.cou_discount), 0)
        	- IFNULL(SUM(discount_summary.total_cash), 0)
        ) AS total, CONCAT(tbl_treatment_payment.treat_date, " ", tbl_treatment_payment.treat_time) AS pay_date';

        switch ($type) {
            case 'today':
                $filter = 'tbl_treatment_payment.treat_date = CURDATE()';
                $group = 'tbl_treatment_payment.treat_date';
                break;
            case 'month':
                $filter = 'MONTH(tbl_treatment_payment.treat_date) = MONTH(CURDATE()) AND YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())';
                $group = 'MONTH(tbl_treatment_payment.treat_date)';
                break;
            case 'year':
                $filter = 'YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())';
                $group = 'YEAR(tbl_treatment_payment.treat_date)';
                break;
            case 'week':
                $filter = 'WEEK(tbl_treatment_payment.treat_date) = WEEK(CURDATE()) AND YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())';
                $group = 'WEEK(tbl_treatment_payment.treat_date)';
                break;
            case 'last_month':
                $filter = 'YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE()) AND MONTH(tbl_treatment_payment.treat_date) = MONTH(CURDATE() - INTERVAL 1 MONTH)';
                $group = 'DATE(tbl_treatment_payment.treat_date)';
                break;
            default:
        }
        $this->db->select($select);
        $this->db->from('tbl_treatment_payment');
        $this->db->join(
            '(SELECT treatment_payment_id, 
                     SUM(discount) AS discount, 
                     SUM(category_discount) AS c_discount,
                     SUM(company_discount) AS com_discount,
                     SUM(points_discount) AS poi_discount,
                     SUM(coupon_discount) AS cou_discount,
                     SUM(cash) AS total_cash 
              FROM tbl_patient_payment 
              GROUP BY treatment_payment_id) AS discount_summary',
            'discount_summary.treatment_payment_id = tbl_treatment_payment.treatement_payment_id',
            'left'
        );
        // $this->db->where('tbl_treatment_payment.is_insurance', 0);
        $this->db->where($filter);
        if ($group != '') {
            $this->db->group_by($group);
        }

        $this->db->order_by('tbl_treatment_payment.treat_time', 'ASC');
        $this->db->order_by('tbl_treatment_payment.treat_date', 'ASC');

        // Get the result
        $result = $this->db->get();


        // Check if there is a result
        if ($result->num_rows() > 0) {
            return $result->result_array();
        } else {
            return null; // or handle the case when there is no result
        }
    }

    public function get_top_treatments($period)
    {

        // Determine the WHERE condition based on the period
        if ($period == '1') {
    $this->db->where('DATE(tbl_treatment_payment.treat_date) = CURDATE()');
} elseif ($period == '2') {
    $this->db->where('YEARWEEK(tbl_treatment_payment.treat_date, 1) = YEARWEEK(CURDATE(), 1)');
} elseif ($period == '3') {
    $this->db->where('YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())')
             ->where('MONTH(tbl_treatment_payment.treat_date) = MONTH(CURDATE())');
} elseif ($period == '4') {
    $this->db->where('YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())');
}
        // Build the rest of the query
        $this->db->select('treatment_name, COUNT(*) as count');
        $this->db->from('tbl_episode_payment');
        $this->db->join('tbl_insurance_prices', 'tbl_insurance_prices.id = tbl_episode_payment.procedure_id', 'left');
        $this->db->join('tbl_treatment_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id', 'left');
        $this->db->group_by('procedure_id');
        $this->db->order_by('count', 'DESC');
        $this->db->limit(5);
        $query = $this->db->get();

        return $query->result();
    }

    public function get_top_patients($period)
    {
        // Apply the date filter based on the period
        if ($period == '1') {
    $this->db->where('DATE(tbl_treatment_payment.treat_date) = CURDATE()');
} elseif ($period == '2') {
    $this->db->where('YEARWEEK(tbl_treatment_payment.treat_date, 1) = YEARWEEK(CURDATE(), 1)');
} elseif ($period == '3') {
    $this->db->where('YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())')
             ->where('MONTH(tbl_treatment_payment.treat_date) = MONTH(CURDATE())');
} elseif ($period == '4') {
    $this->db->where('YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())');
}

        // Build the query with a JOIN instead of a subquery
        $this->db->select('tbl_patients.patient_name, COUNT(tbl_treatment_payment.patient_id) as count');
        $this->db->from('tbl_patients');
        $this->db->join('tbl_treatment_payment', 'tbl_treatment_payment.patient_id = tbl_patients.patient_id', 'left');
        $this->db->group_by('tbl_patients.patient_id');
        $this->db->order_by('count', 'DESC');
        $this->db->limit(5);

        $query = $this->db->get();

        return $query->result();


    }

    public function get_top_doctors($period)
    {
        if ($period == '1') {
    $this->db->where('DATE(tbl_treatment_payment.treat_date) = CURDATE()');
} elseif ($period == '2') {
    $this->db->where('YEARWEEK(tbl_treatment_payment.treat_date, 1) = YEARWEEK(CURDATE(), 1)');
} elseif ($period == '3') {
    $this->db->where('YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())')
             ->where('MONTH(tbl_treatment_payment.treat_date) = MONTH(CURDATE())');
} elseif ($period == '4') {
    $this->db->where('YEAR(tbl_treatment_payment.treat_date) = YEAR(CURDATE())');
}
        
        $this->db->select('tbl_users.full_name, 
        SUM(tbl_treatment_payment.total)
    		- SUM(tbl_treatment_payment.discount) 
    		- IFNULL(SUM(discount_summary.discount), 0)
    		- IFNULL(SUM(discount_summary.c_discount), 0)
    		- IFNULL(SUM(discount_summary.com_discount), 0)
    		- IFNULL(SUM(discount_summary.poi_discount), 0)
    		- IFNULL(SUM(discount_summary.cou_discount), 0)
    		as total_amount');
        $this->db->from('tbl_users');
        $this->db->join('tbl_treatment_payment', 'tbl_treatment_payment.user_id = tbl_users.user_Id', 'left');
        $this->db->join(
            '(SELECT treatment_payment_id, 
                     SUM(discount) AS discount, 
                     SUM(category_discount) AS c_discount,
                     SUM(company_discount) AS com_discount,
                     SUM(points_discount) AS poi_discount,
                     SUM(coupon_discount) AS cou_discount,
                     SUM(cash) AS total_cash 
              FROM tbl_patient_payment 
              GROUP BY treatment_payment_id) AS discount_summary',
            'discount_summary.treatment_payment_id = tbl_treatment_payment.treatement_payment_id',
            'left'
        );
        $this->db->where('tbl_users.designation_id', '1');
        $this->db->group_by('tbl_users.user_Id');
        $this->db->order_by('total_amount', 'DESC');

        $this->db->limit(5);
        $query = $this->db->get();

        return $query->result();
    }




    /**
     * *************************
     * Get data for insurance price list
     * 
     */

    public function getInsuranceTypes()
    {
        return $this->db->select('*')
            ->from('tbl_insurance_types')
            ->get()
            ->result();
    }

    public function getCompanies()
    {
        return $this->db->select('*')
            ->from('tbl_companies')
            ->get()
            ->result();
    }

    public function getInsurancePriceList($search, $insurance = null, $length, $start)
    {
        $this->db->select('tbl_insurance_prices.*, tbl_insurance_types.insurance_name');
        $this->db->from('tbl_insurance_prices');
        $this->db->join('tbl_insurance_types', 'tbl_insurance_prices.insurance_type_id = tbl_insurance_types.insurance_type_id', 'left');

        $this->db->limit($length, $start);

        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('treatment_id', $search);
            $this->db->or_like('treatment_name', $search);
            $this->db->or_like('lqdc_gross', $search);
            $this->db->group_end();
        }

        if ((int)$insurance) {
            $this->db->where('tbl_insurance_prices.insurance_type_id', $insurance);
        }

        return $this->db->get()->result();
    }

    public function get_total_records($search, $insurance = null)
    {
        $this->db->select('tbl_insurance_prices.*, tbl_insurance_types.insurance_name');
        $this->db->from('tbl_insurance_prices');
        $this->db->join('tbl_insurance_types', 'tbl_insurance_prices.insurance_type_id = tbl_insurance_types.insurance_type_id', 'left');

        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('treatment_id', $search);
            $this->db->or_like('treatment_name', $search);
            $this->db->or_like('lqdc_gross', $search);
            $this->db->group_end();
        }

        if ((int)$insurance) {
            $this->db->where('tbl_insurance_prices.insurance_type_id', $insurance);
        }

        return $this->db->count_all_results();
    }

    public function receptionistReceived($date_type)
    {
        $payment_types = $this->db->select('*')->from('tbl_payment_types')->where('tbl_payment_types.type_id!=3')->get()->result();
        $query = "";

        $date_start = '';
        $date_end = '';
        if ($date_type == 'today') {
            $date_start = date('Y-m-d');
            $date_end = date('Y-m-d');
        } elseif ($date_type == 'week') {
            $date_start = date('Y-m-d', strtotime('last monday'));
            $date_end = date('Y-m-d', strtotime('next sunday'));
        } elseif ($date_type == 'month') {
            $date_start = date('Y-m-01');
            $date_end = date('Y-m-t');
        } elseif ($date_type == 'year') {
            $date_start = date('Y-01-01');
            $date_end = date('Y-12-31');
        }

        foreach ($payment_types as $key => $type) {
            $query .= "SUM(CASE WHEN tbl_payment_types.type_id = {$type->type_id} THEN tbl_patient_payment.cash ELSE 0 END) AS '{$type->type_name}', '{$type->colour}' AS '{$type->type_name}_colour'";

            if ($key < count($payment_types)) {
                $query .= ",";
            }
        }

        return $this->db->select($query)->from('tbl_patient_payment')
            ->join('tbl_payment_types', 'tbl_patient_payment.pay_type = tbl_payment_types.type_id')
            ->where('pay_date >=', $date_start)
            ->where('pay_date <=', $date_end)
            ->get()->row();
    }

    public function doctorIncome()
    {
        return $this->db->select('tbl_users.full_name, SUM(tbl_treatment_payment.total) AS total, SUM(tbl_treatment_payment.discount) AS discount')
            ->from('tbl_treatment_payment')
            ->join('tbl_employees', 'tbl_treatment_payment.user_id = tbl_employees.user_id')
            ->join('tbl_users', 'tbl_employees.user_id=tbl_users.user_Id')
            ->where_in('tbl_employees.doctor_type', [1, 3])
            ->group_by('tbl_treatment_payment.user_id')
            ->get()
            ->result();
    }
}
