<?php

class ParamModel extends CI_Model {


    function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

    public function save($data) {
        $this->db->insert('test_parameters', $data);
        return $this->db->insert_id();
    }
    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update('test_parameters', $data);
        return $this->db->affected_rows();
    }

    public function update_value($id,$data) {
        $this->db->where('id', $id);
        $this->db->update('parameters_values', $data);
        return $this->db->affected_rows();
    }

    public function save_values($data) {
        $this->db->insert('parameters_values', $data);
    }


    public function getParam($id) {
        $this->db->select('test_parameters.* ,lab_units.name AS unit_name'); // Select the necessary columns
        $this->db->from('test_parameters');

        $this->db->join('lab_units', 'lab_units.id = test_parameters.unit'); // Adjust join condition as needed
        $this->db->where('test_parameters.id', $id);
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row(); // Return single row result
        } else {
            return null; // or handle no result case as required
        }
    }
    public function getParamValues($id) {
        $this->db->select( 'parameters_values.*'); // Select the necessary columns
        $this->db->from('parameters_values');
        $this->db->where('parameters_values.param_id', $id);
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->result(); // Return single row result
        } else {
            return null; // or handle no result case as required
        }
    }
    

    public function deleteParameter($id) {
        $this->db->where('id', $id);
        $this->db->delete('test_parameters');
        $this->db->where('param_id', $id);
        $this->db->delete('parameters_values');
        return $this->db->affected_rows(); // Returns the number of affected rows
    }

}