<?php

class DermatologyModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }


    public function getTreatment($treatment_id)
    {
        return $this->db->select('*')->from('tbl_treatment_payment')
            ->where('treatement_payment_id', $treatment_id)
            ->get()
            ->row();
    }

    public function get_profile_main($id)
    {
        $this->db->select('tbl_patients.patient_id, tbl_patients.patient_name, tbl_patients.dob, tbl_patients.profile_img, tbl_treatment_log.treatment_date, tbl_treatment_log.doctor_id, tbl_users.full_name as employee_name, TIMESTAMPDIFF(YEAR,tbl_patients.dob,CURDATE()) AS age, tbl_patients.insurance_type as insurance_type_id, tbl_patients.sex, tbl_patients.qatar_id, tbl_insurance_types.insurance_name,tbl_patients.backup_id,tbl_treatment_log.due,tbl_patients.mobile, tbl_countries.country_name as name, tbl_patients.company_id, tbl_company.company_name, tbl_patients.qid_front_image');
        $this->db->from('tbl_patients');
        $this->db->join('tbl_patient_file', 'tbl_patients.patient_id = tbl_patient_file.patient_id', 'LEFT');
        $this->db->join('tbl_treatment_log', 'tbl_patient_file.file_id = tbl_treatment_log.file_id', 'LEFT');
        $this->db->join('tbl_users', 'tbl_treatment_log.doctor_id = tbl_users.user_Id', 'LEFT');
        $this->db->join('tbl_insurance_types', 'tbl_patients.insurance_type = tbl_insurance_types.insurance_type_id', 'LEFT');
        $this->db->join('tbl_countries', 'tbl_patients.nationality = tbl_countries.country_id', 'LEFT');
        $this->db->join('tbl_company', 'tbl_company.company_id = tbl_patients.company_id', 'LEFT');
        $this->db->where('tbl_patients.patient_id', $id);
        $this->db->order_by('log_id', 'DESC');
        $this->db->limit(1);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_pedia_list($table, $field, $pri_id)
    {
        $this->db->select('*');
        $this->db->from($table);
        $this->db->join('tbl_treatment_payment', "tbl_treatment_payment.treatement_payment_id = $table.treatment_payment_id", 'LEFT');
        $this->db->join('tbl_treatment_log', 'tbl_treatment_payment.log_id = tbl_treatment_log.log_id', 'LEFT');
        $this->db->join('tbl_users', 'tbl_treatment_log.doctor_id = tbl_users.user_Id', 'LEFT');
        $this->db->join('tbl_employees', 'tbl_employees.user_id = tbl_users.user_Id', 'LEFT');

        $this->db->where("$table.$field", $pri_id);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function employee_doctor()
    {
        $this->db->select('tbl_employees.user_id as doctor_id, tbl_employees.doctor_color as color_code, tbl_employees.doctor_type as professional_type, tbl_users.full_name as employee_name, tbl_employees.employee_id');
        $this->db->from('tbl_employees');
        $this->db->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_attachment($id, $cat, $pri_id)
    {
        $this->db->select('*');
        $this->db->from('tbl_patient_attachments');
        $this->db->where('patient_id', $id);
        $this->db->where('category', $cat);
        $this->db->where('treat_id', $pri_id);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function follow_up_derma($log_id)
    {
        $this->db->select('*');
        $this->db->from('tbl_treat_derma');
        $this->db->join('tbl_treatment_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_treat_derma.treatment_payment_id');
        $this->db->join('tbl_treatment_log', 'tbl_treatment_log.log_id = tbl_treatment_payment.log_id');
        $this->db->where('ref_no', $log_id);
        $this->db->order_by('derma_id', 'ASC');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_insurance_prices($insurance_id, $category_id)
    {
        return $this->db->select('*')
        ->from('tbl_insurance_prices')
        ->where("insurance_type_id={$insurance_id}")
        ->where("treatment_category={$category_id}")
        ->get()
        ->result();
    }

    public function getDiagnoses($searchTerm)
    {
        $this->db->select('*');
        $this->db->from('tbl_derma_diagnostise');
        $this->db->like('name', $searchTerm, 'after');
        $this->db->or_like('diagnostise_id', $searchTerm, 'after');

        $query = $this->db->get();
        return $query->result_array();
    }

    public function update_data($table, $field, $value, $data)
	{

		$query = $this->db->query("SELECT *FROM $table WHERE $field ='$value'");
			
			if($query->num_rows() >0)
			{
				$this->db->where($field, $value);
				$this->db->update($table, $data); 
				return TRUE;
			} else{
				return FALSE;
			}
	}

    public function delete_treatment_forall($table,$field,$id)
	{
		$this->db->where($field, $id);
		$this->db->delete($table);
		
		return TRUE;
	}

    public function add_data_d($table, $data)
	{
		$this->db->insert($table, $data);
		return TRUE;
	
	}

    public function get_id_insert($table, $data)
	{
        $this->db->insert($table, $data);
        return $this->db->insert_id();
	}
   
    public function numberofepisode($p_id, $ep_ty)
    {
        $this->db->select('*');
        $this->db->from('tbl_episode_payment');
        $this->db->join('tbl_treatment_payment', 'tbl_episode_payment.treatement_payment_id = tbl_treatment_payment.treatement_payment_id');
        $this->db->where('tbl_episode_payment.episode_type', $ep_ty);
        $this->db->where('tbl_treatment_payment.patient_id', $p_id);

        $query = $this->db->get();

        return $query->num_rows();
    }

    public function get_last_attachment($patient_id, $cat)
    {
        $this->db->select('*');
        $this->db->from('tbl_patient_attachments');
        $this->db->where("document LIKE '$patient_id-%'");
        $this->db->where('category', $cat);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }

    public function get_patient_id($log_id)
    {
        $this->db->select('*');
        $this->db->from('tbl_treatment_log');
        $this->db->join('tbl_treatment_payment', 'tbl_treatment_payment.log_id = tbl_treatment_log.log_id', 'left');
        $this->db->join('tbl_patient_file', 'tbl_treatment_log.file_id = tbl_patient_file.file_id', 'left');
        $this->db->where('tbl_treatment_log.log_id', $log_id);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row()->patient_id;
        } else {
            return FALSE;
        }
    }



}
