<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class PharmacyModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	
    public function items_expiry() {
        $query = "SELECT "
                . "`drug_id`, `drug_name`,`supplier_name`,`sh_bill`.`bill_id`, `expiry`,`expired`, `sh_receive_bill_items`.`batch`, `sh_receive_bill_items`.`cost`, `sh_receive_bill_items`.`x_date`, "
                . "(ifnull(sum(`sh_receive_bill_items`.`remaining`),0)) as qty "
                . "FROM `sh_drugs` "
                . "left join `sh_receive_bill_items` "
                . "on `sh_receive_bill_items`.`item_id`=`sh_drugs`.`drug_id` "
                . "left join `sh_bill` "
                . "on `sh_bill`.`bill_id`=`sh_receive_bill_items`.`bill_id` "
                . "left join `sh_supplier` "
                . "on `sh_supplier`.`supplier_id`=`sh_bill`.`supplier_id` "
                . "WHERE `sh_drugs`.`deleted`=0 "
                . "group by `drug_id`, `sh_receive_bill_items`.`batch`";
        $result = $this->db->query($query);
        return $result->result_array();
    }
	public function items_expiring() {
		$query = "SELECT "
        . "`drug_id`, `drug_name`, `supplier_name`, `sh_bill`.`bill_id`, `expiry`, `sh_receive_bill_items`.`batch`, `sh_receive_bill_items`.`x_date`, "
        . "(IFNULL(SUM(`sh_receive_bill_items`.`remaining`), 0)) AS qty "
        . "FROM `sh_drugs` "
        . "LEFT JOIN `sh_receive_bill_items` ON `sh_receive_bill_items`.`item_id` = `sh_drugs`.`drug_id` "
        . "LEFT JOIN `sh_bill` ON `sh_bill`.`bill_id` = `sh_receive_bill_items`.`bill_id` "
        . "LEFT JOIN `sh_supplier` ON `sh_supplier`.`supplier_id` = `sh_bill`.`supplier_id` "
        . "WHERE `sh_drugs`.`deleted` = 0 "
        . "AND `sh_drugs`.`expired` = 0 "
        . "GROUP BY `drug_id`, `sh_receive_bill_items`.`batch`";
			$result = $this->db->query($query);
        return $result->result_array();
    }
	public function countExpired() {
		$query = "SELECT COUNT(`drug_id`) AS total_drugs FROM `sh_drugs` WHERE `sh_drugs`.`expired` = 1";
		$result = $this->db->query($query);
		$row = $result->row_array();
		return $row['total_drugs'];
    }
	public function expiring() {
		$query = "SELECT "
        . "`drug_id`, `drug_name`, `supplier_name`, `sh_bill`.`bill_id`, `expiry`, `sh_receive_bill_items`.`batch`, `sh_receive_bill_items`.`x_date`, "
        . "(IFNULL(SUM(`sh_receive_bill_items`.`remaining`), 0)) AS qty "
        . "FROM `sh_drugs` "
        . "LEFT JOIN `sh_receive_bill_items` ON `sh_receive_bill_items`.`item_id` = `sh_drugs`.`drug_id` "
        . "LEFT JOIN `sh_bill` ON `sh_bill`.`bill_id` = `sh_receive_bill_items`.`bill_id` "
        . "LEFT JOIN `sh_supplier` ON `sh_supplier`.`supplier_id` = `sh_bill`.`supplier_id` "
        . "WHERE `sh_drugs`.`deleted` = 0 "
        . "AND `sh_drugs`.`expired` = 0 "
        . "GROUP BY `drug_id`, `sh_receive_bill_items`.`batch`";
			$result = $this->db->query($query);
        $data= $result->result_array();
		$today = new DateTime("now");
		$items= array();
		foreach ($data as $values) {
            $x_date = new DateTime($values['x_date']);
            $diff = $x_date->diff($today);
            $days = $diff->format('%a');
            if ($values['qty'] > 0 && $days < $values['expiry']) {
               
					array_push($items, $values);
                
            
                
            }
          
        }
		return count($items);
    }

	

    public function get_payment($id){
        $query = $this->db->query("SELECT * FROM sh_sell_bill_paid
			LEFT JOIN sh_sell_bill_payment ON sh_sell_bill_paid.payment_id = sh_sell_bill_payment.payment_id
			WHERE sh_sell_bill_paid.bill_id = '$id'");
		if($query->num_rows() > 0)
			{
				return $query->result_array();		
			} else {
				return FALSE;
			}
    }
 public function moveExpireItems($id){
	$this->db->set('expired', '1');
    $this->db->where('drug_id', $id);
    $query = $this->db->update('sh_drugs');
    
    // Directly return the result of the update operation
    return $query;
 }
    public function get_sell_bill_items($id)
	{
		$query = $this->db->query("SELECT * FROM sh_sell_bill
			JOIN sh_sell_bill_items ON sh_sell_bill_items.sell_bill_id = sh_sell_bill.sell_bill_id
			LEFT JOIN sh_drugs ON sh_drugs.drug_id = sh_sell_bill_items.item_id
			LEFT JOIN sh_receive_bill_items ON sh_sell_bill_items.r_bill = sh_receive_bill_items.bill_items_id
			WHERE sh_sell_bill.sell_bill_id = '$id'");
		if($query->num_rows() > 0)
			{
				return $query->result_array();		
			} else {
				return FALSE;
			}
	}

	public function get_item_return($item)
	{
		$query = $this->db->query("SELECT * FROM sh_receive_bill_items LEFT JOIN sh_drugs ON sh_drugs.drug_id = sh_receive_bill_items.item_id WHERE sh_drugs.drug_name LIKE '$item%' OR sh_drugs.drugs_code LIKE '$item%' ORDER BY drug_name ASC");
		if($query->num_rows() > 0)
		{
			return $query->result_array();
		} else {
			return FALSE;
		}
	}

	public function purchase_return_list()
	{
		$query = $this->db->query("SELECT * FROM sh_return_stock
			LEFT JOIN sh_supplier ON sh_return_stock.supplier_id = sh_supplier.supplier_id
			LEFT JOIN tbl_users ON sh_return_stock.user_id = tbl_users.user_Id");
		if($query->num_rows() > 0)
			{
				return $query->result_array();		
			} else {
				return FALSE;
			}
	}

	public function receive_bill_add($bill_id,$item_id)
	{
		$query = $this->db->query("SELECT * FROM sh_receive_bill_items WHERE bill_id = '$bill_id' AND item_id = '$item_id'");
		if($query->num_rows() > 0)
			{
				return $query->row();		
			} else {
				return FALSE;
			}
	}

	public function get_active_template()
    {
        return $this->db->select('*')
        ->from('tbl_invoice_templates')
        ->where('invoice_type', 2)
        ->where('is_default', 1)
        ->where('is_active', 1)
        ->get()
        ->row()->template;
    }

}
