<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Financial extends CI_Model {

    var $table = 'sh_bill';
    var $column_order = array('sh_bill.bill_id','invoice_no','sh_bill.bill_id','amount','paid_amount','balance',null); //set column field database for datatable orderable
    var $column_search = array('sh_bill.bill_id','invoice_no','sh_bill.bill_id','amount','paid_amount'); //set column field database for datatable searchable just firstname , lastname , address are searchable
    var $order = array('sh_bill.bill_id' => 'desc'); // default order 

    // public function get_all() {
    //     $result = $this->db->get('sh_supplier');
    //     return $result->result();
    // }
    
    public function get_bill($bill) {
        $query="SELECT `sh_bill`.`bill_id` as bill, `receive_date`, `supplier_name`, `amount`, `discount`, sum(`paid_amount`)as payment  "
                . "FROM `sh_bill` "
                . "left join `sh_bill_paid` on (`sh_bill`.`bill_id`=`sh_bill_paid`.`bill_id`) "
                . "left join `sh_receive_bill` on (`sh_bill`.`bill_id`=`sh_receive_bill`.`bill_id`) "
                . "left join `sh_supplier` on (`sh_bill`.`supplier_id`=`sh_supplier`.`supplier_id`) "
                . "WHERE `sh_bill`.`bill_id`=$bill";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function add_payment($data) {
        $this->db->insert('sh_bill_payment', $data);
        return $this->db->insert_id();
    }

    // public function search($param) {
    //     $this->db->like('supplier_name', $param);
    //     $this->db->or_like('email', $param);
    //     $this->db->or_like('mobile', $param);
    //     $this->db->or_like('phone', $param);
    //     $this->db->or_like('fax', $param);
    //     $result = $this->db->get('sh_supplier');
    //     return $result->result();
    // }

    // public function search_json($param) {
    //     $query = "SELECT `supplier_id`, `supplier_name` "
    //             . "FROM `sh_supplier` "
    //             . "where `supplier_name` like '%$param%' and `deleted`=0 "
    //             . "group by `supplier_id`";
    //     $result = $this->db->query($query);
    //     return $result->result_array();
    // }

    // public function count_active() {
    //     $this->db->where('deleted', 0);
    //     $this->db->from('sh_supplier');
    //     return $this->db->count_all_results();
    // }

    // public function delete($id, $where) {
    //     $value=($where==0)?1:0;
    //     $data=array('deleted'=>$value);
    //     $this->db->where('supplier_id', $id);
    //     $this->db->update('sh_supplier', $data);
    //     return $this->db->affected_rows();
    // }

    // public function update($id, $data) {
    //     $this->db->where('supplier_id', $id);
    //     $this->db->update('sh_supplier', $data);
    //     return $this->db->affected_rows();
    // }

    public function add_bill_payment($data) {
        $this->db->insert('sh_bill_paid', $data);
        return $this->db->affected_rows();
    }

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    private function _get_datatables_query()
    {
        $this->db->select('sh_bill.bill_id, sh_bill.invoice_no, sh_bill.amount, IFNULL(sum(paid_amount),0) as paid_amount,sh_bill.amount-IFNULL(sum(paid_amount),0) as balance', false);
        $this->db->from($this->table);
        // $this->db->join('sh_supplier', 'sh_bill.supplier_id = sh_supplier.supplier_id', 'left');
        $this->db->join('sh_bill_paid', 'sh_bill_paid.bill_id = sh_bill.bill_id', 'left');
        // $this->db->join('sh_receive_bill_items', 'sh_receive_bill_items.bill_id = sh_bill.bill_id', 'left');
        $this->db->group_by('sh_bill_paid.bill_id'); 
        $i = 0;
    
        foreach ($this->column_search as $item) // loop column 
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {               
                $this->db->or_like($item, $_POST['search']['value']);
            }
            $i++;
        }
        
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }

    public function get_by_id($id)
    {
        $this->db->from($this->table);
        $this->db->where('sh_bill.bill_id',$id);
        $this->db->join('sh_supplier', 'sh_bill.supplier_id = sh_supplier.supplier_id', 'left');
        $query = $this->db->get();

        return $query->row();
    }

    public function get_by_id_view($id)
    {
        $this->db->select("sh_receive_bill_items.item_id,sh_receive_bill_items.quantity,sh_drugs.drug_name,batch,x_date,bonus,cost,unit_type");
        $this->db->from("sh_receive_bill_items");
        $this->db->where('bill_id',$id);
        $this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_receive_bill_items.item_id', 'left');
        $query = $this->db->get();

        return $query->result_array();
    }

    public function save($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    public function update($where, $data)
    {
        $this->db->update($this->table, $data, $where);
        return $this->db->affected_rows();
    }

    public function delete_by_id($id)
    {
        $this->db->where('sh_bill.bill_id', $id);
        $this->db->delete($this->table);
    }



}
