<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Items extends CI_Model {

    public function get_all() {
        $query = 'SELECT `drug_id`, `drug_name`, `drugs_code`, `sh_drugs`.`deleted` as deleted, on_hand, expiry, drugs_category, category_name '
                . 'FROM `sh_drugs` '
                . 'left join `sh_category` as m '
                . 'on `drugs_category`=`category_id`'
                . 'group by `drug_id` ';
        $result = $this->db->query($query);
        return $result->result();
    }

    public function add($data) {
        $this->db->insert('sh_drugs', $data);
        return $this->db->affected_rows();
    }

    public function add_inquiry($data) {
        $this->db->insert('sh_inquiry', $data);
        return $this->db->insert_id();
    }

    public function add_inquiry_items($data) {
        $this->db->insert('sh_inquiry_items', $data);
        return $this->db->affected_rows();
    }

    public function add_bill_items($data) {
        $this->db->insert('sh_receive_bill_items', $data);
        return $this->db->affected_rows();
    }

    public function add_receive_bill($data) {
        $this->db->insert('sh_receive_bill', $data);
        return $this->db->affected_rows();
    }

    public function search($param) {
        $query = "SELECT `drug_id`, `drug_name`, `drugs_code`, `sh_drugs`.`deleted` as deleted, on_hand, expiry, drugs_category, category_name "
                . "FROM `sh_drugs` "
                . "left join `sh_category` as m "
                . "on `category_id`=`drugs_category`"
                . "where `drug_name` like '%$param%' "
                . "or `drugs_code` like '%$param%' "
                . "group by `drug_id`";
        $result = $this->db->query($query);
        return $result->result();
    }

    public function search_json($param) {
        $query = "SELECT `drug_id`, `drug_name`, `drugs_code` "
                . "FROM `sh_drugs` "
                . "where `drug_name` like '%$param%' "
                . "or `drugs_code` like '%$param%' and `deleted`=0 "
                . "group by `drug_id`";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function search_stock_items($param) {
        $date = date('Y-m-d');
        $query = "SELECT `bill_items_id`, `drug_id`, `drug_name`, `drugs_code`, `batch`, `x_date`, `price`, `loose`, `sh_receive_bill_items`.`remaining`, `sh_drugs`.`loose_active`, `sh_drugs`.`quantity` "
                . "FROM `sh_drugs` "
                . "left join `sh_receive_bill_items` "
                . "on (`drug_id`=`item_id`) "
                . "where (`drug_name` like '%$param%' or `drugs_code` like '%$param%' "
                . "or `batch` like '%$param%' and `deleted`=0) "
                . "and ((sh_receive_bill_items.x_date > '$date' or sh_receive_bill_items.x_date = '0000-00-00') and sh_receive_bill_items.remaining > 0) "
                . "group by `batch`";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function search_sale_items($item) {
       
        $query = $this->db->query("SELECT * FROM sh_sell_bill_items LEFT JOIN sh_drugs ON sh_drugs.drug_id = sh_sell_bill_items.item_id WHERE sh_drugs.drug_name LIKE '%$item%' OR sh_drugs.drugs_code LIKE '$item%' ORDER BY drug_name ASC");
        if($query->num_rows() > 0)
		{
			return $query->result_array();
		} else {
			return FALSE;
		}
    }
    public function get_item_return_sale($item)
	{
		$query = $this->db->query("SELECT * FROM sh_sell_bill_items LEFT JOIN sh_drugs ON sh_drugs.drug_id = sh_sell_bill_items.item_id WHERE sh_drugs.drug_name LIKE '$item%' OR sh_drugs.drugs_code LIKE '$item%' ORDER BY drug_name ASC");
		if($query->num_rows() > 0)
		{
			return $query->result_array();
		} else {
			return FALSE;
		}
	}


   
    public function search_pharmacy_bill($param) {
        $date = date('Y-m-d');
        
                $query="SELECT "
                . "`sell_bill_id` as bill_id, `sell_date` as bill_date, `amount` as bill_amount,`type`, `paid_amount` as payment, `tbl_tbl_patients`.`patient_id` as patient_id, `patient_name` as patient "
                . "FROM `sh_sell_bill` "
                . "left join `sh_sell_bill_credit` "
                . "on `sh_sell_bill_credit`.`bill_id`=`sell_bill_id` "
                . "left join `sh_sell_bill_paid` "
                . "on `sh_sell_bill_paid`.`bill_id`=`sell_bill_id` "
                . "left join `tbl_tbl_patients` "
                . "on `tbl_tbl_patients`.`patient_id`=`sh_sell_bill_credit`.`patient_id` "
                . "WHERE `sell_bill_id`=$param " 
                . "group by `sell_bill_id`";



        $result = $this->db->query($query);
        return $result->result_array();
    }


    public function get_patient_prescription($param) {
        $query = "SELECT "
                . "`tbl_prescription_main`.`patient_id`, `patient_name`, `prescription_main_id`"
                . "FROM `tbl_prescription_main` "
                . "left join `tbl_patients` "
                . "on `tbl_patients`.`patient_id`= `tbl_prescription_main`.`patient_id` "
                . "WHERE `prescription_main_id`=$param";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function search_prescription_items($param) {
        // $query = "SELECT "
        //         . "`sh_drugs`.`drug_id` as drug, `drug_name`, `drugs_code`,  `batch`, `x_date`, `drug_qty`, `sell_price` "
        //         . "FROM `sh_drugs` "
        //         . "left join `sh_receive_bill_items` "
        //         . "on (`drug_id`=`item_id`) "
        //         . "left join `prescription` "
        //         . "on (`prescription`.`drug_id`=`sh_drugs`.`drugs_code` and `prescription`.`prescription_id` = $param) "
        //         . "where `sh_drugs`.`deleted`=0 "
        //         . "group by `drugs_code` "
        //         . "having `drug_qty` is not null "
        //         . "order by `drugs_code`";
        $query = "SELECT * FROM tbl_prescription 
                  
                    LEFT JOIN sh_drugs ON sh_drugs.drug_id = tbl_prescription.drug_id
                    WHERE prescription= '$param'";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function get_prescription($param) {
        $query = "SELECT `drug_id`, `drug_qty` "
                . "FROM `prescription` "
                . "where `prescription_id`=$param";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function search_prescription($param) {
        $query = "SELECT `tbl_prescription_main`.`prescription_main_id` as prescription, `tbl_patients`.`patient_id` as patient_id, `patient_name` as patient, `tbl_prescription_main`.`enter_date` as 'date', `full_name` as doctor "
                . "FROM `tbl_patients` "
                . "left join `tbl_prescription_main` "
                . "on `tbl_prescription_main`.`patient_id`=`tbl_patients`.`patient_id` "
                . "left join `tbl_users` "
                . "on `tbl_users`.`user_Id`=`tbl_prescription_main`.`doctor_id` "
                . "left join `tbl_employees` "
                . "on `tbl_employees`.`user_id`=`tbl_users`.`user_Id` "
                . "WHERE `tbl_patients`.`patient_id` "
                . "or `tbl_patients`.`patient_name` LIKE '%$param%' "
                . "group by `tbl_prescription_main`.`prescription_main_id`";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function count_active() {
        $this->db->where('deleted', 0);
        $this->db->from('sh_drugs');
        return $this->db->count_all_results();
    }

    public function delete($id, $where) {
        $value = ($where == 0) ? 1 : 0;
        $data = array('deleted' => $value);
        $this->db->where('drug_id', $id);
        $this->db->update('sh_drugs', $data);
        return $this->db->affected_rows();
    }

    public function update($id, $data) {
        $this->db->where('drug_id', $id);
        $this->db->update('sh_drugs', $data);
        return $this->db->affected_rows();
    }

    public function get_receive_bill_items($bill) {
        $this->db->select('*, drug_name');
        $this->db->from('sh_receive_bill_items');
        $this->db->join('sh_drugs', 'item_id=drug_id');
        $this->db->where('bill_id', $bill);
        $result = $this->db->get();
        return $result->result();
    }

    public function search_receive_bill_items($bill) {
        $this->db->select('*, drug_name');
        $this->db->from('sh_receive_bill_items');
        $this->db->join('sh_drugs', 'item_id=drug_id');
        $this->db->where('bill_id', $bill);
        $this->db->or_where('batch', $bill);
        $result = $this->db->get();
        return $result->result();
    }

    public function item_availability($param) {
        $query = "SELECT "
                . "(sum(ifnull(`sh_receive_bill_items`.`quantity`,0)))+"
                . "(sum(ifnull(`sh_receive_bill_items`.`bonus`,0)))+"
                . "(sum(ifnull(`sh_return_sale_items`.`qty`,0)))-"
                . "(sum(ifnull(`sh_sell_bill_items`.`qty`,0)))-"
                . "(sum(ifnull(`sh_return_stock_items`.`quantity`,0))) as availability "
                . "FROM `sh_receive_bill_items` "
                . "left join `sh_return_sale_items` "
                . "on `sh_return_sale_items`.`item_id`=`sh_receive_bill_items`.`item_id` "
                . "left join `sh_sell_bill_items` "
                . "on `sh_sell_bill_items`.`item_id`= `sh_receive_bill_items`.`bill_items_id` "
                . "left join `sh_return_stock_items` "
                . "on `sh_return_stock_items`.`item_id`=`sh_receive_bill_items`.`item_id` and `sh_return_stock_items`.`batch`=`sh_receive_bill_items`.`batch` "
                . "WHERE `sh_receive_bill_items`.`item_id`=$param";
        $result = $this->db->query($query);
        $temp = $result->result();
        foreach ($temp as $value) {
            $get = $value->availability;
        }
        return $get;
    }

    public function items_availability() {
        // $query = "SELECT "
        //         . "`sh_drugs`.`drug_id`, "
        //         . "(ifnull(sum(`sh_receive_bill_items`.`quantity`),0) + "
        //         . "ifnull(sum(`sh_receive_bill_items`.`bonus`),0) + "
        //         . "ifnull(sum(`sh_return_sale_items`.`qty`),0) - "
        //         . "ifnull(sum(`sh_sell_bill_items`.`qty`),0) - "
        //         . "ifnull(sum(`sh_return_stock_items`.`quantity`),0)) as qty, "
        //         . "`on_hand` "
        //         . "FROM `sh_drugs` "
        //         . "left join `sh_receive_bill_items` "
        //         . "on `sh_receive_bill_items`.`item_id`=`sh_drugs`.`drug_id` "
        //         . "left join `sh_return_sale_items` "
        //         . "on `sh_return_sale_items`.`item_id`=`sh_receive_bill_items`.`item_id` "
        //         . "left join `sh_sell_bill_items` "
        //         . "on `sh_receive_bill_items`.`bill_items_id`=`sh_sell_bill_items`.`item_id` "
        //         . "left join `sh_return_stock_items` "
        //         . "on `sh_return_stock_items`.`item_id`=`sh_receive_bill_items`.`item_id` and `sh_return_stock_items`.`batch`=`sh_receive_bill_items`.`batch`  "
        //         . "WHERE `sh_drugs`.`deleted`=0 "
        //         . "group by `sh_drugs`.`drug_id`";
        $query = "SELECT * from sh_drugs";
        $result = $this->db->query($query);
        return $result->result();
    }

    public function items_expiry() {
        $query = "SELECT "
                . "`drug_id`, `drug_name`,`supplier_name`,`sh_bill`.`bill_id`, `expiry`, `sh_receive_bill_items`.`batch`, `sh_receive_bill_items`.`x_date`, "
                . "(ifnull(sum(`sh_receive_bill_items`.`remaining`),0)) as qty "
                . "FROM `sh_drugs` "
                . "left join `sh_receive_bill_items` "
                . "on `sh_receive_bill_items`.`item_id`=`sh_drugs`.`drug_id` "
                . "left join `sh_bill` "
                . "on `sh_bill`.`bill_id`=`sh_receive_bill_items`.`bill_id` "
                . "left join `sh_supplier` "
                . "on `sh_supplier`.`supplier_id`=`sh_bill`.`supplier_id` "
                . "WHERE `sh_drugs`.`deleted`=0 "
                . "group by `drug_id`, `sh_receive_bill_items`.`batch`";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function search_bill($param) {
        $query = "SELECT "
                . "`drug_id`, `drug_name`,`supplier_name`,`sh_bill`.`bill_id`, `expiry`, `sh_receive_bill_items`.`batch`, `sh_receive_bill_items`.`x_date`, "
                . "(ifnull(sum(`sh_receive_bill_items`.`quantity`),0)+ "
                . "ifnull(sum(`sh_receive_bill_items`.`bonus`),0)+ "
                . "ifnull(sum(`sh_return_sale_items`.`qty`),0)- "
                . "ifnull(sum(`sh_sell_bill_items`.`qty`),0)- "
                . "ifnull(sum(`sh_return_stock_items`.`quantity`),0)) as qty "
                . "FROM `sh_drugs` "
                . "left join `sh_receive_bill_items` "
                . "on `sh_receive_bill_items`.`item_id`=`sh_drugs`.`drug_id` "
                . "left join `sh_bill` "
                . "on `sh_bill`.`bill_id`=`sh_receive_bill_items`.`bill_id` "
                . "left join `sh_supplier` "
                . "on `sh_supplier`.`supplier_id`=`sh_bill`.`supplier_id` "
                . "left join `sh_return_sale_items` "
                . "on (`sh_return_sale_items`.`item_id`=`sh_receive_bill_items`.`item_id` and `sh_return_sale_items`.`batch`=`sh_receive_bill_items`.`batch`) "
                . "left join `sh_sell_bill_items` "
                . "on (`sh_receive_bill_items`.`bill_items_id`=`sh_sell_bill_items`.`item_id` and `sh_receive_bill_items`.`batch`=`sh_sell_bill_items`.`batch`) "
                . "left join `sh_return_stock_items` "
                . "on (`sh_return_stock_items`.`item_id`=`sh_receive_bill_items`.`item_id` and `sh_return_stock_items`.`batch`=`sh_receive_bill_items`.`batch` ) "
                . "WHERE (`sh_drugs`.`drugs_code` like '$param%' or `supplier_name` like '$param%') and `sh_drugs`.`deleted`=0  "
                . "group by `drug_id`, `sh_receive_bill_items`.`batch`";
        $result = $this->db->query($query);
        return $result->result_array();
    }
    
    public function get_bill_items($param) {
        $query="SELECT "
                . "`drug_name`, `sh_receive_bill_items`.`item_id`, `sh_receive_bill_items`.`batch`, `x_date`, "
                . "ifnull(`sh_receive_bill_items`.`remaining`,0) as qty, `sh_receive_bill_items`.`bill_items_id`, `discount_cost` "
                . "FROM `sh_receive_bill_items` "
                . "left join `sh_drugs` "
                . "on `sh_drugs`.`drug_id`=`sh_receive_bill_items`.`item_id` "
                . "left join `sh_return_sale_items` "
                . "on (`sh_return_sale_items`.`item_id`=`sh_receive_bill_items`.`item_id` and `sh_return_sale_items`.`batch`=`sh_receive_bill_items`.`batch`) "
                . "left join `sh_sell_bill_items` "
                . "on (`sh_receive_bill_items`.`bill_items_id`=`sh_sell_bill_items`.`item_id` and `sh_receive_bill_items`.`batch`=`sh_sell_bill_items`.`batch`) "
                . "left join `sh_return_stock_items` "
                . "on (`sh_return_stock_items`.`item_id`=`sh_receive_bill_items`.`item_id` and `sh_return_stock_items`.`batch`=`sh_receive_bill_items`.`batch` )  "
                . "WHERE `bill_id`=$param";
        $result = $this->db->query($query);
        return $result->result_array();
    }
    public function get_return_bill_items($param) {
        $query="SELECT "
                . "`drug_name`, `sh_receive_bill_items`.`item_id`, `sh_receive_bill_items`.`batch`, `x_date`, "
                . "ifnull(`sh_receive_bill_items`.`remaining`,0) as qty, `sh_receive_bill_items`.`bill_items_id`, `discount_cost` "
                . "FROM `sh_receive_bill_items` "
                . "left join `sh_drugs` "
                .  "on `sh_drugs`.`drug_id`=`sh_receive_bill_items`.`item_id` "
                . "WHERE `bill_id`=$param";
        $result = $this->db->query($query);
        return $result->result_array();
    }


}
