<?php


class PrescriptionModel extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function search_drugs($name_startsWith)
    {
        $name_startsWith = strtoupper($name_startsWith);

        $this->db->select('*');
        $this->db->from('sh_drugs');
        $this->db->like('drug_name', $name_startsWith);
        $this->db->or_like('drug_id', $name_startsWith);
        $this->db->order_by('drug_id', 'ASC');
        $query = $this->db->get();

        $data = array();
        foreach ($query->result_array() as $row) {
            $data[] = $row['drug_id'] . ' - ' . $row['drug_name'];
        }

        return $data;
    }

    public function getAutoComplete($name_startsWith, $category_id)
    {
        $this->db->select('content');
        $this->db->from('tbl_auto_complete');
        $this->db->like('content', $name_startsWith);
        $this->db->where('category', $category_id);
        $this->db->order_by('rating', 'DESC');
        $this->db->order_by('auto_complete_id', 'ASC');
        $this->db->limit(100);
        $query = $this->db->get();

        $data = array();
        foreach ($query->result_array() as $row) {
            $data[] = $row['content'];
        }

        return $data;
    }

    public function getDiagnosisMulti($term)
    {
        $term = strtoupper($term);

        $this->db->select('diagnostise_id, name');
        $this->db->from('tbl_diagnostise');
        $this->db->group_start();
        $this->db->like('name', $term);
        $this->db->or_like('diagnostise_id', $term);
        $this->db->group_end();
        $this->db->order_by('rating', 'DESC');
        $this->db->order_by('diagnostise_id', 'ASC');
        $this->db->limit(100);
        $query = $this->db->get();

        $data = array();
        foreach ($query->result_array() as $row) {
            $data[] = $row['diagnostise_id'] . ' - ' . $row['name'];
        }

        return $data;
    }

    public function single_prescription_list($id)
    {
        $this->db->select('tbl_prescription.drug_id, tbl_prescription.drug_name, tbl_prescription.prescription, tbl_prescription.drug_qty, tbl_prescription.drug_note, tbl_prescription.after_before, tbl_prescription_main.patient_id, tbl_employees.doctor_stamp as stamp, tbl_prescription_main.enter_date, tbl_prescription_main.diagnostise_id, tbl_users.full_name as employee_name');
        $this->db->from('tbl_prescription');
        $this->db->join('tbl_prescription_main', 'tbl_prescription.prescription_id = tbl_prescription_main.prescription_main_id', 'left');
        $this->db->join('tbl_users', 'tbl_prescription_main.doctor_id = tbl_users.user_id', 'left');
        $this->db->join('tbl_employees', 'tbl_employees.employee_id = tbl_users.user_id', 'left');
        $this->db->where('tbl_prescription.prescription_id', $id);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_patientdata($id)
    {
        $this->db->select("CONCAT(zone, ', ', street, ', ', building) AS address, tbl_patients.patient_name, tbl_prescription_main.enter_date, tbl_patients.dob, tbl_patients.sex, mobile");
        $this->db->from('tbl_patients');
        $this->db->join('tbl_prescription_main', 'tbl_patients.patient_id = tbl_prescription_main.patient_id', 'left');
        $this->db->where('tbl_patients.patient_id', $id);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_patient_prescription($id) {
        return $this->db
        ->select('tbl_prescription.drug_name, tbl_prescription.prescription, tbl_prescription.drug_qty, tbl_prescription.drug_note, tbl_prescription.after_before, tbl_prescription_main.created_at')
        ->from('tbl_prescription')
        ->join('tbl_prescription_main', 'tbl_prescription.prescription_main_id = tbl_prescription_main.prescription_main_id', 'left')
        ->join('tbl_drugs_list', 'tbl_prescription.drug_id = tbl_drugs_list.drug_id', 'left')
        //->where('tbl_prescription.prescription_main_id', $id)
        ->where('tbl_prescription_main.patient_id', $id)
        ->get()->result();

    }

    public function delete_prescription($prescription_id, $patient_id, $user_id) {
        $data = [
            'deleted_at' => date('Y-m-d H:i:s'),
            'deleted_by' => $user_id
        ];
    
        $this->db->where('prescription_main_id', $prescription_id);
        $this->db->where('patient_id', $patient_id);
        $this->db->update('tbl_prescription_main', $data);
    
        return $this->db->affected_rows() > 0;
    }
    
}
