<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class ConfigurationsModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function get_list()
    {
        $query = $this->db->select('*')
            ->from('tbl_company')
            ->get();
        return $query;
    }

    public function save($data, $is_new_image)
    {
        $this->db->insert('tbl_company', $data);
        $company_id = $this->db->insert_id();

        return $company_id;
    }

    public function update($company_id, $data, $is_new_image)
    {

        $image_path = $data["logo"];

        /*Image update*/
        if ($is_new_image == 'true') {

            $falder_path = "Images/companylogo";
            $std_image_url = $falder_path . '.png';

            if (file_exists($std_image_url)) {
                unlink(trim($std_image_url));
            }

            $std_image = $image_path;

            $image_parts = explode(";base64,", $std_image);
            $image_type_aux = explode("image/", $image_parts[0]);
            $image_type = $image_type_aux[1];
            $image_base64 = base64_decode($image_parts[1]);
            $file = $std_image_url;

            file_put_contents($file, $image_base64);
            $image_path = $std_image_url;
        }


        $this->db->set('company_name', $data["company_name"]);
        $this->db->set('description', $data["description"]);
        $this->db->set('address', $data["address"]);
        $this->db->set('phone_no', $data["phone_no"]);
        $this->db->set('mobile_no', $data["mobile_no"]);
        $this->db->set('fax', $data["fax"]);
        $this->db->set('email', $data["email"]);
        $this->db->set('web', $data["web"]);
        $this->db->set('logo', $image_path);

        $this->db->set('create_user_Id', $data["create_user_Id"]);
        $this->db->set('create_datetime', $data["create_datetime"]);

        $this->db->where('company_id', $company_id);
        $this->db->update('tbl_company');
    }

    public function get_by_id()
    {
        $query = $this->db->select('*')
            ->from('tbl_company')
            ->get();
        return $query->result_array();
    }

    /**
     * INVOICE CONFIGURATIONS
     */

    // Load invoice types
    public function getInvoiceTypes()
    {
        return $this->db->select('*')
            ->from('tbl_invoice_types')
            ->get()
            ->result();
    }

    // Load invoice templates
    public function getInvoiceTemplates()
    {
        return $this->db->select('tbl_invoice_templates.*, tbl_invoice_types.type as template_type')
            ->from('tbl_invoice_templates')
            ->join('tbl_invoice_types', 'tbl_invoice_types.id = tbl_invoice_templates.invoice_type')
            ->get()
            ->result();
    }

    // Create invoice template
    public function createInvoiceTemplate($data)
    {
        return $this->db->insert('tbl_invoice_templates', $data);
    }

    // Update invoice template
    public function updateInvoiceTemplate($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('tbl_invoice_templates', $data);
    }

    // Load specific invoice template
    public function getInvoiceTemplate($id)
    {
        return $this->db->select('*')
            ->from('tbl_invoice_templates')
            ->where('id', $id)
            ->get()
            ->row();
    }

    // Delete invoice template
    public function deleteInvoiceTemplate($id)
    {
        return $this->db->where('id', $id)
            ->delete('tbl_invoice_templates');
    }

    // Get notification templates
    public function LoadNotiicationTemplates($notification_type)
    {
        return $this->db
            ->select('tbl_notification_templates.*, tbl_event_names.event_name, tbl_event_names.event')
            ->from('tbl_notification_templates')
            ->join('tbl_event_names', 'tbl_notification_templates.event_type = tbl_event_names.event')
            ->where('type', $notification_type)
            ->get()
            ->result();
    }
    public function LoadNotificationReminders($notification_type)
    {
        return $this->db
            ->select('*')
            ->from('notification_reminders')
            ->where('reminder_type',1)
            ->get()
            ->result();
    }

    // Get event type
    public function GetPlaceholders($event)
    {
        return $this->db->select('placeholders')->from('tbl_event_names')->where('event', $event)->get()->row();
    }

    public function saveMessagePackage($data){

      

         $this->db->insert('user_message_details', $data);
        $this->db->where('id', $data['package_id']); // Assuming there's only one row to update
        return $this->db->update('message_packages', ['status'=>'2']);
      

    }
    public function saveGeneralDiscount($data){

      

        $this->db->where('type', 'appointment'); // Assuming there's only one row to update
        return $this->db->update('discount_general', $data);

    }
    public function saveGeneral($data){

      

        $this->db->where('type', 'appointment'); // Assuming there's only one row to update
        return $this->db->update('general_settings', $data);

    }
    public function saveGeneral_($data){

      

      
        $this->db->where('type', $data['type']); 
        $this->db->where('name', 'is_enable'); 
        $query = $this->db->get('general_settings');

    if ($query->num_rows() > 0) {
        // If the record exists, update it
        $this->db->where('type', $data['type']); 
        $this->db->where('name', 'is_enable');
        return $this->db->update('general_settings', $data);
    } else {
        // If the record does not exist, insert a new one
        return $this->db->insert('general_settings', $data);
    }

    }

    public function SaveDiscountCategories($data){

        return $this->db->insert('discount_category', $data);

    }
    public function SaveDiscountRange($data){

        return $this->db->insert('discount_range', $data);

    }

    public function getUsersByType($type) {
        $this->db->where('user_group_Id', $type);
        $query = $this->db->get('tbl_users');
        return $query->result_array();
    }


    public function getDiscountRangeWithUsers() {
        $this->db->select('discount_range.*, tbl_users.full_name');
        $this->db->from('discount_range');
        $this->db->join('tbl_users', 'discount_range.user_id = tbl_users.user_Id', 'left');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function updateDiscountRange($id, $employee_type,$user_id, $max_value) {
        $data = [
         
            'user_id' => $user_id,
            'employee_type' => $employee_type,
            'max_value' => $max_value
        ];
        $this->db->where('id', $id);
        $this->db->update('discount_range', $data);
    }

    public function updateDiscountCategory($id, $name, $discount) {
        $data = [
         
            
            'category' => $name,
            'discount' => $discount
        ];
        $this->db->where('id', $id);
        $this->db->update('discount_category', $data);
    }

    public function deleteDiscountRange($id) {
        $this->db->where('id', $id);
        $this->db->delete('discount_range');
    }

    public function deleteDiscountCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('discount_category');
    }
  
  
    public function savePackage($data){

      

      // Assuming there's only one row to update
      $this->db->insert('packages', $data);
     return $this->db->insert_id(); // Get the last inserted ID

    }

    public function savePackageDetails($data){

      

        // Assuming there's only one row to update
        $this->db->insert('package_details', $data);
       return $this->db->insert_id(); // Get the last inserted ID
  
      }

      public function getPackages(){
        $this->db->select('
        p.id, 
        p.name as package_name, 
        p.price, 
        GROUP_CONCAT(DISTINCT m.module_name ORDER BY m.module_name ASC SEPARATOR ", ") as department_names, 
        GROUP_CONCAT(DISTINCT pd.sessions ORDER BY pd.sessions ASC SEPARATOR ", ") as sessions
    ');
    $this->db->from('packages p');
    $this->db->join('package_details pd', 'pd.package_id = p.id', 'left');
    $this->db->join('tbl_modules m', 'm.module_id = pd.department_id', 'left'); // Join with departments table
    $this->db->group_by('p.id'); // Group by package id
    $query = $this->db->get();

    return $query->result_array();
      }

      public function deletePackage($id){
        $this->db->where('id', $id);
        $this->db->delete('packages');

        $this->db->where('package_id', $id);
        $this->db->delete('package_details');

      }

}
