<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class UserGroupModel extends CI_Model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    //insert user group
    public function saveUserGroup($data) {
        $this->db->insert('tbl_user_groups', $data);
        $usergroupId = $this->db->insert_id();

        return $usergroupId;
    }

    //save user group right
    public function saveUserGroupRight($data1) {
        $this->db->insert('tbl_user_group_rights', $data1);
    }

    public function saveUserRight($data1) {
        $this->db->insert('tbl_user_rights', $data1);
    }


    //update user group
    public function updateUserGroup($data, $UserGroupId) {
        $query = $this->db->where('user_group_Id', $UserGroupId)
                ->update('tbl_user_groups', $data);
        return $query;
    }

    //update user group right
    public function updateUserGroupRight($data1, $UserGroupId) {
        $query = $this->db->where('user_group_Id', $UserGroupId)
                ->update('tbl_user_group_rights', $data1);
        return $query;
    }

    //get user group
    public function get_user_group() {
        $query = $this->db->select('*')
                ->from('tbl_user_groups')
                ->where('user_group_Id!=','81')
                ->get();
        return $query;
    }

    //load user group
    public function load_user_group($user_group_Id) {
        $query = $this->db->select('*')
                ->from('tbl_user_groups')
                ->where('tbl_user_groups.user_group_Id', $user_group_Id)
                ->get();
        return $query->result_array();
    }

    //load user right id
    public function load_user_right_id($user_group_Id) {
        $query = $this->db->select('*')
                ->from('tbl_user_group_rights')
                ->where('tbl_user_group_rights.user_group_Id', $user_group_Id)
                ->get();
        return $query->result_array();
    }
    

    //get user right
    public function user_right() {
        $query = $this->db->select('*')
                ->from('tbl_user_rights')
                ->get();
        return $query;
    }

    public function user_right_main_menu_name() {
        $query = $this->db->distinct()->select('main_menu_name,main_menu_code')
                ->from('tbl_user_rights')
                ->get();
        return $query;
    }

    public function load_user_right($user_group_Id) {
        $query = $this->db->query("call get_usergroup_rights(" . $user_group_Id . ")");


        $query->next_result();
        return $query;
    }

}
