<div class="modal fade" id="block_poppup_edit" tabindex="-1" role="dialog" aria-labelledby="block_poppup_edit_label" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="block_poppup_edit_label">Edit Blocked Schedule</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="post" id="update_block_appointment">
                    <input type="hidden" name="block_id" id="block_id">
                    <div class="container">
                        <div class="form-group">
                            <label for="block_note">Note</label>
                            <textarea class="form-control" rows="3" name="block_note" id="block_note"></textarea>
                        </div>
 
                        <div class="form-group end-date">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="block_date_from">Block Date From</label>
                                    <input type="text" class="form-control select_date" name="block_date_from" id="block_date_from">

                                </div>
                                <div class="col-md-6">
                                    <label for="block_date_to">Block Date To</label>
                                    <input type="text" class="form-control select_date" name="block_date_to" id="block_date_to">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="app_time" id="app_time">Blocked Time</label>
                            <div class="row">
                                <div class="col-md-6 col-6">
                                    <label for="block_time_from"><small>Start</small></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control timepicker_app" name="block_time_from" id="block_time_from" required>
                                        <span class="input-group-addon">
                                            <span class="glyphicon glyphicon-time"></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-6 col-6">
                                    <label for="block_time_to"><small>End</small></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control timepicker_app" name="block_time_to" id="block_time_to" required>
                                        <span class="input-group-addon">
                                            <span class="glyphicon glyphicon-time"></span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="blocked_doctor_id">Select Doctor</label>
                            <select class="form-control" name="blocked_doctor_id" id="blocked_doctor_id">
                                <?php if ($doctors != FALSE) : ?>
                                    <?php foreach ($doctors as $value) : ?>
                                        <option value="<?= $value->user_id; ?>"><?= $value->user_name . ' ( ' . $value->doctor_type . ' )'; ?></option>
                                    <?php endforeach; ?>
                                <?php else : ?>
                                    <option>Records Not Found</option>
                                <?php endif; ?>
                            </select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-light" id="update_blocked_appointment">
                            <i class="fa fa-check-circle" aria-hidden="true"></i>
                            Save changes
                        </button>
                        <button type="reset" class="btn btn-sm btn-light">
                            <i class="fa fa-refresh" aria-hidden="true"></i>
                            Reset
                        </button>
                        <button type="reset" class="btn btn-sm btn-light" id="delete_blocked_appointment">
                            <i class="fa fa-trash" aria-hidden="true"></i>
                            Delete
                        </button>
                        <button type="button" class="btn btn-sm btn-light" data-dismiss="modal">
                            <i class="fa fa-times-circle" aria-hidden="true"></i>
                            Close
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>