<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title> Category</title>
<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

<!--image crop-->
<link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>
<?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>
<body class="<?php echo $this->config->item('theme'); ?> fixed">
<!-- Site wrapper --> 

<!-- Header Navbar: style can be found in header.less -->
<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

<!-- =============================================== --> 

<!-- Left side column. contains the sidebar -->
<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

<!-- =============================================== --> 

<!-- Right side column. Contains the navbar and content of the page -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1> Category <small><?php echo $_id > 0 ? 'Update' : 'New' ?></small> </h1>
    <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
  </section>
  
  <!-- Main content -->
  <form id="submitForm" name ="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Category/CategoryController/save') ?>" method="post" >
    <section class="content"> 
      
      <!--buttons-->
      <div class="row">
        <div class="col-xs-12">
          <div class="box box-solid">
            <div class="box-body">
              <div class="row"> <!-- Form Buttons   -->
                
                <div class="col-md-1"> <a href="<?php echo base_url('index.php/admin/Category/CategoryController') ?>" class="btn btn-info"><i class="fa fa-angle-left"></i> Go back </a> </div>
                <div class="col-md-9">
                  <?php if (validation_errors()) { ?>
                  <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                    <div>
                      <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                    </div>
                  </div>
                  <?php } ?>
                </div>
                <div class="col-md-2 text-right"> <a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class=" btn btn-success "> <?php echo $_id > 0 ? 'Update Category' : 'Save Category' ?></a> </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--//buttons--> 
      
      <!--form-->
      <div class="row">
        <div class="col-xs-12">
          <div class="box box-info" style="margin-bottom: 5px;">
            <div class="box-header with-border">
              <h2 class="box-title">Category Details</h2>
              <div class="pull-right box-tools">
                <div class="btn-group">
                  <button class="btn btn-info btn-sm" data-widget="collapse"><i class="fa fa-minus"></i></button>
                </div>
              </div>
            </div>
            <div class="box-body">
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group <?php echo form_error("category_code") ? "has-error" : "" ?>">
                    <label>Category Code</label>
                    <input id="category_code" name="category_code" value="<?php echo $category_code ?>" type="text" class="form-control" placeholder=""/>
                    <label><small><?php echo form_error("category_code"); ?></small></label>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group <?php echo form_error("category_name") ? "has-error" : "" ?>">
                    <label>Category Name</label>
                    <input id="category_name" name="category_name" value="<?php echo $category_name ?>" type="text" class="form-control" placeholder=""/>
                    <label><small><?php echo form_error("category_name"); ?></small></label>
                  </div>
                </div>
                <div class="col-md-4">
					
				  <div class="form-group" style="width: 250px;">
							<label class="file-control">
								<input type="file" data-control="image_uploader" size="60" >
								<div class="dv-logo">
									<div class="center" style="position: absolute;top: 0;left: 0;height: 100%;width: 100%;">
										<div class="dv-hover center" style="margin: 0px;">
											<i class="fa fa-image"></i>
										</div>
									</div>

									<div class="dv-result-logo" style="width: 250px;">

										<img class="result-logo" id="result" name="result" src="<?php echo $is_new_image == 'true' ? $item_image : base_url($item_image) ?>">
									</div>
								</div>
							</label> 
				  </div>
					
                  <div class="form-group" style="min-height: 0px;padding-left: 10px;margin-top: 30px;">
                    <input type="checkbox" id="status" name="status" value="active" <?php echo $status == 'active' ? 'checked' : '' ?> >
                    <label style="margin-left: 5px;"> Active </label>
                    <label><small><?php echo form_error("status"); ?></small></label>
                  </div>
                </div>
              </div>
				
			  <div class="row">
				  <div class="col-md-7"></div>
				  <div class="col-md-4">
						 <div class="form-group" style="width: 250px;">
							<div id="crop-image" class="box-body"></div>
							<input hidden="hidden" type="text" runat="server"  id="image_path" name="image_path" value=" " class="txtBx" style="margin-top:10px; ">
						</div> 
				  </div>
				  <div class="col-md-1"></div>
		      </div>		
            </div>
          </div>
        </div>
      </div>
    </section>
    <input type="hidden" id="_id" name="_id" value="<?php echo $_id ?>">
	<input type="hidden" id="item_image" name="item_image" value="<?php echo $item_image ?>">
	<input type="hidden" id="is_new_image" name="is_new_image" value="<?php echo $is_new_image ?>">
  </form>
</div>

<!-- ./wrapper -->

<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
</html>

<script>
	$("[data-control=image_uploader]").change(function () {
			readURL(this);
		});

	function readURL(input) {
		if (input.files && input.files[0]) {
			var reader = new FileReader();
			reader.onload = function (e) {

			$('#croppie_modal').on('shown.bs.modal', function() {

				document.getElementById('croppie_image').innerHTML = "<div class='form-group center'><img id='upload_image' src='#' /></div>";

				document.getElementById('croppie_footer').innerHTML = "<div class='form-group' style='min-height:0px;'><a id='use' class='image-select btn-primary'><i class='fa fa-crop' style='margin-right: 8px;'></i> CROP</a></div>";


				$('#upload_image').attr('src', e.target.result);
				var resize = new Croppie($('#upload_image')[0], {
					viewport: {width: 350, height: 450},
					boundary: {width: 400, height: 515},
					showZoomer: false,
					enableResize: false,
					enableOrientation: true
				});



				$('#use').fadeIn();


				$('#use').on('click', function () {
					resize.result('base64').then(function (dataImg) {
						var data = [{image: dataImg}, {name: 'myimgage.jpg'}];

						$('#result').attr('src', dataImg);

						$('#item_image').val(dataImg);
						$('#is_new_image').val('true');


						$("#croppie_modal").modal("hide");

					});
				});


				});

				$("#croppie_modal").modal("show");

			}
			reader.readAsDataURL(input.files[0]);
		}
	}

</script>


