<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title> Documents</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

        <!--image crop-->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
        <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Documents
                    <small><?php echo $_id > 0 ? 'Update' : 'New' ?></small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

            <!-- Main content -->
             <form id="submitForm" name ="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Documents/DocumentsController/save') ?>" method="post" >
    <section class="content"> 
      
      <!--buttons-->
      <div class="row">
        <div class="col-12">
          <div class="box box-solid">
            <div class="box-body">
              <div class="row"> <!-- Form Buttons   -->
                
                <div class="col-md-1"> <a href="<?php echo base_url('index.php/admin/Documents/DocumentsController') ?>" class="btn btn-info"><i class="fa fa-angle-left"></i> Go back </a> </div>
                <div class="col-md-9">
                  <?php if (validation_errors()) { ?>
                  <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                    <div>
                      <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                    </div>
                  </div>
                  <?php } ?>
                </div>
                <div class="col-md-2 text-right"> <a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class=" btn btn-success "> <?php echo $_id > 0 ? 'Update Category' : 'Save Category' ?></a> </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--//buttons--> 
      
      <!--form-->
      <div class="row">
        <div class="col-12">
          <div class="box box-info" style="margin-bottom: 5px;">
            <div class="box-header with-border">
              <h2 class="box-title">Category Details</h2>
              <div class="pull-right box-tools">
                <div class="btn-group">
                  <button class="btn btn-info btn-sm" data-widget="collapse"><i class="fa fa-minus"></i></button>
                </div>
              </div>
            </div>
            <div class="box-body">
              <div class="row">
                    <div class="col-md-4">
                      <div class="form-group <?php echo form_error("_id") ? "has-error" : "" ?>">
                        <label>Document ID</label>
                        <input id="_id" readonly name="_id" value="<?php echo $_id ?>" type="text" class="form-control" placeholder=""/>
                        <label><small><?php echo form_error("_id"); ?></small></label>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group <?php echo form_error("document_type_id") ? "has-error" : "" ?>">
                              <label>Document Type</label>
                              <select id="document_type_id" name="document_type_id" class="form-control selectpicker"  placeholder="Enter ..." data-live-search="true"/>

                                <option  value="0" <?php echo $document_type_id == 0 ? 'selected' : '' ?>  >Select</option>
                            
                                <?php foreach ($document_typs->result() as $value) { ?>

                                    <option  value="<?php echo $value->document_type_id ?>" <?php echo $value->document_type_id == $document_type_id ? 'selected' : '' ?>  ><?php echo $value->document_type ?></option>

                                <?php } ?>
                            
                              </select>
                              <label><small><?php echo form_error("document_type_id"); ?></small></label>
                          </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group" style="min-height: 0px;padding-left: 10px;margin-top: 30px;">
                            <input type="checkbox" id="is_active" name="is_active" value="active" <?php echo $is_active == 'active' ? 'checked' : '' ?> >
                            <label style="margin-left: 5px;"> Is Active </label>
                            <label><small><?php echo form_error("is_active"); ?></small></label>
                      </div>
                    </div>
              </div>
                    <div class="tab-content" style="margin-top: 20px;">
                        <div id="details_en" class="tab-pane fade in active">
                            <div class=" dv_tabContent">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>Document Content</label>
                                            <textarea id="document_content" name="document_content" class="form-control" style="height: 500px">
                                              <?php echo $document_content ?>
                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <input type="hidden" id="_id" name="_id" value="<?php echo $_id ?>">
  </form>
            
        </div>

        <!-- ./wrapper -->


        <?php require_once(APPPATH . "views/admin/footer.php"); ?>


    </body>
</html>

<script>
      $(function () {
        //Add text editor
        $("#document_content").wysihtml5();
       
      });
    </script>








