<?php if ($result != FALSE) { ?>
    <div id='report-content-balance'>

        <h4 class="visible-print-block col-md-12 text-center"><u>Inventory : Item Balance Report</u></h4>
        <table class="table">
            <thead>
                <tr>
                    <td width="100%" class="text-center"><span class="visible-print-block col-md-6 ">Item : <b><?php echo $item_info ? $item_info->item_id . ' - ' . $item_info->item_name : 'All' ?></b></span></td>
                </tr>
            </thead>
        </table>
        <div class="table-responsive">

            <table class="table table-bordered table-hover" id="tbl-balance">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Item - (Invoice Id)</th>
                        <th>Unit Type</th>
                        <th>Unit Cost</th>
                        <th>Quantity</th>
                        <th>Bonus</th>
                        <th>Total Received</th>
                        <th>Total Transferred</th>
                        <th>Balance Quantity</th>
                        <th>Cost of Total</th>
                        <th>Cost of Balance</th>
                    </tr>
                </thead>
                <tbody>

                    <?php $balance_total = 0;
                    $balance_total_qty = 0;
                    $net_total = 0;
                    $net_qty = 0;
                    $tran_total = 0;
                    $tran_qty = 0;
                    foreach ($result as $row) {
                        $total_qty = $row['stock_qty'] + $row['bonus'];
                        $balance_qty = $total_qty - $row['sent_qty'];
                        $total_cost = $row['stock_qty'] * $row['price'];
                        $balance_cost =  $row['out_price'] * $balance_qty;
                        $balance_total += $balance_cost;

                        echo '<tr>
                    <td width="10%">' . $row['date'] . '</td>
                    <td width="30%"><b>' . $row['item_code'] . ' - ' . $row['item_barcode'] . ' - ' . $row['item_name'] . ' - (' . $row['inventory_invoice_id'] . ')</b></td>
                    <td>' . $row['unit_name'] . '</td>
                    <td>' . $row['out_price'] . '</td>
                    <td>' . $row['stock_qty'] . '</td>
                    <td>' . $row['bonus'] . '</td>
                    <td>' . $total_qty . '</td>
                    <td>' . $row['sent_qty'] . '</td>
                    <td>' . $balance_qty . '</td>
                    <td>' . number_format($total_cost, 2) . '</td>
                    <td>' . number_format($balance_cost, 2) . '</td>
                  </tr>';
                    }
                    echo '
            <tr>
                <td colspan="10" class="text-right"><b>TOTAL BALANCE COST :</b></td>
                <td class="col-md-1"><b>' . number_format($balance_total, 2) . '</b></td>
            </tr>
            ';
                    ?>
                </tbody>
            </table>
        </div>
    <?php } else { ?>
        <div class="col-md-12 text-center">Not found any records</div>
    <?php } ?>
    </div>