<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                &nbsp;Edit Dietitian Treatment
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">

            <div class="row mb-2">
                <div class="col-md-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">
                            <div class="d-flex justify-content-start">
                                <a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode($patient_id, $this) ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back</a>
                            </div>
                        </div>
                    </div>
                </div><!-- /.box-body -->
            </div>

            <?php print_header($this); ?>
            <form role="form" action="<?php echo site_url('admin/Modules/Dietitian/DietitianController/save'); ?>" method="post" enctype="multipart/form-data">
                <?php date_default_timezone_set('Asia/Kuwait');
                $date_string = '%Y-%m-%d';
                $curr_date = mdate($date_string);
                ?>
                <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
                <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
                <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">
                <input type="hidden" class="form-control" name="treatment_payment_id" id="treatment_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">



                <div class="box  box-info">
                    <div class="form-group p-3">
                        <div class="box-body">

                            <div class="row">
                                <div class="col-3">
                                    <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                                        <label for="app_date">Treatment Date</label>
                                        <input type="text" class="form-control select_date" name="treatment_date_general" id="treatment_date_general" value="<?php echo $curr_date; ?>">
                                        <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                                        <label for="app_date">Treatment Time</label>
                                        <input type="time" class="form-control" name="treatment_time" id="treatment_time" value="<?php echo date("H:i"); ?>">
                                        <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-12">
                                            <label for="cheif_compalin">Chief Complaint<span class="text-red" aria-hidden="true">*</span></label>
                                            <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                            <textarea required class="form-control" name="cheif_compalin" id="cheif_compalin" rows="3"><?php echo $treat_data->chief_complain ?></textarea>
                                        </div>
                                        <div class="form-group mt-2 col-12">
                                            <label for="clinical_finding">Subjective<span class="text-red" aria-hidden="true"></span></label>
                                            <textarea class="form-control" name="subjective" id="subjective" rows="3"><?php echo $treat_data->subjective ?></textarea></textarea>
                                        </div>
                                        <div class="form-group mt-2 col-6">
                                            <label for="clinical_finding">objective<span class="text-red" aria-hidden="true"></span></label>
                                            <textarea class="form-control" name="objective" id="objective" rows="3"><?php echo $treat_data->objective ?></textarea></textarea>
                                        </div>
                                        <div class="form-group mt-2 col-6">
                                            <label for="clinical_finding">Assessment&Plans<span class="text-red" aria-hidden="true"></span></label>
                                            <textarea class="form-control" name="assessment" id="assessment" rows="3"><?php echo $treat_data->assesment ?></textarea></textarea>
                                        </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="drugs">Select Diagnosis</label>
                                        <input type="text" class="multi_diagnosis" name="diagnosis_general" id="diagnosis_general">
                                    </div>
                                </div>


                                

                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="procedure">Select Procedure</label>
                                        <select class="procedure" data-department="1" name="procedure_general" id="procedure_general">
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <button type="button" class="btn btn-sm btn-dark" id="addRow_general">
                                        <i class="fa fa-plus-circle"></i> Add
                                    </button>
                                </div>

                                <br>
                                <div class="col-12">
                                    <div class="panel panel-primary">
                                        <div class="panel-heading">
                                            <h5>Procedure List</h5>
                                        </div>
                                        <table class="table table-hover display table-striped w-100" id="treatemnts_ent">
                                            <thead>
                                                <tr>
                                                    <th>No</th>
                                                    <th>Primary Diagnosis</th>
                                                   
                                                    <th>Procedure</th>
                                                    <th>Discount(QR)</th>
                                                    <th>Discount(%)</th>
                                                    <th>Fees</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <?php
                                            foreach ($episodes as $index => $value1) {

                                                echo "<tr>
                                        <td>" . (++$index) . "</td>
                                        <td>" . $value1['aditional_diagnostise_name'] . "<input type='hidden' name='general_diagnosis_name[]' value='" . $value1['aditional_diagnostise_name'] . "'><input type='hidden' name='general_diagnosis_id[]' value='" . $value1['diagnostise_id'] . "'></td>

                                      

                                        <td>" . $value1['treatment_name'] . "<input type='hidden' name='general_treatment_name[]' value='" . $value1['treatment_name'] . "'><input type='hidden' name='general_treatment_id[]' value='" . $value1['treatment_id'] . "'></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='hidden' size='7' name='orig_price[]' value='" . $value1['fees'] . "'><input type='text' size='7' name='discount[]' value='" . $value1['discount_qr'] . "' class='discount_general form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='discount_per[]' value='" . $value1['discount_per'] . "' class='discount_per_general form-control'></span></td>

                                        <td class='hidden-print text-center'><span class='hide-input'><input type='text' size='7' name='fees_general[]' value='" . ($value1['fees'] - $value1['discount_qr']) . "' class='fees_general form-control'></span></td>
                                        <td class='hidden-print text-center'><button type='button' class='btn btn-light deleteRow_general'><i class='fa fa-trash' aria-hidden='true'></i></button></td>
                                        </tr>";
                                                $ctr++;
                                            }
                                            ?>
                                        </table>
                                    </div>
                                </div>


                            </div>
                            <!-- <div class="row">
            <div class="col-12">
              <div class="panel panel-success">
                <div class="panel-heading">Prescription</div><br>
                <div class="row">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Select Drugs</label>
                      <input type="text" class="form-control drugs" name="drugs_ent" id="drugs_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Doses</label>
                      <input type="text" class="form-control ent_doses_auto" name="drug_qty_ent" id="drug_qty_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="meal">Frequency</label><br>
                      <input type="text" class="form-control ent_frequency_auto" name="drug_meal_ent" id="drug_meal_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Duration(Days)</label>
                      <div class="input-group">
                        <input type="text" class="form-control ent_duration_auto" name="drug_note_ent" id="drug_note_ent">
                        <span class="input-group-addon">
                          <button type="button" class="btn btn-light btn-xs add_field_button_ent" id="add_drug_ent">+</button>
                          <button type="button" class="btn btn-danger btn-xs clear_field_ent" id="clear_field_ent">x</button>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="input_fields_wrap_ent"></div>
              </div>
            </div>
          </div> -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="drugs">Note</label>
                                        <textarea type="text" class="form-control note" name="note" id="note"><?php echo $invoice->notes; ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <span id="attach" class="hide-text hidden-print">
                                        <?php if ($attachment != FALSE) : ?>
                                            <h4>Attachments</h4>
                                            <table class="table table-bordered">
                                                <thead>
                                                    <th>#</th>
                                                    <th>Attachment</th>
                                                    <th class="text-center">Actions</th>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <?php foreach ($attachment as $index => $val_attach) : ?>
                                                            <td><?= ++$index; ?></td>
                                                            <td><?= $val_attach['document']; ?></td>
                                                            <td>
                                                                <div class="d-flex flex-row justify-content-center">
                                                                    <a class="btn btn-sm btn-light mr-1" href="<?= base_url('' . UPLOAD_PATH . 'physiotherapy/' . $val_attach['document']); ?>" id="single_1" title="View">
                                                                        <i class="fa fa-eye" aria-hidden="true"></i>

                                                                    </a>
                                                                    <a class="btn btn-sm btn-light mr-1" href="<?= base_url('' . UPLOAD_PATH . 'physiotherapy/' . $val_attach['document']); ?>" download title="Download">
                                                                        <i class="fa fa-cloud-download" aria-hidden="true"></i>
                                                                    </a>
                                                                    <a class="btn btn-sm btn-light" href="javascript:void(0);" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Modules/Physiotherapy/PhysiotherapyController/delete_physiotherapy_attachment/' . encrypt_and_url_encode($val_attach['id'], $this)) ?>');" title="Delete">
                                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        <?php endforeach; ?>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>

            </form>
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle"></i> Save</button>
                        <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                    </div>
                </div>
            </div>
    </div>
    </div>


    </div>
    </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

<script>
    var counter = <?= count($episodes) + 1; ?>;

    $(document).ready(function() {
        var procedureElements = document.querySelectorAll('.procedure');

        var procedureCount = procedureElements.length;

        for (var i = 0; i < procedureCount; i++) {
            var currentElement = procedureElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectProcedres(currentElement, departmentId);
        }

        var diagnosisElements = document.querySelectorAll('.multi_diagnosis');
        var diagnosisCount = diagnosisElements.length;

        for (var i = 0; i < diagnosisCount; i++) {
            var currentElement = diagnosisElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectDiagnosis(currentElement, departmentId);
        }



        

    });

   

    $('.drugs').on("focus", function() {
        $(this).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_drugs'); ?>",
                    dataType: "json",
                    data: {
                        name_startsWith: request.term,
                        type: 'drug'
                    },
                    success: function(data) {
                        response($.map(data, function(item) {
                            return {
                                label: item,
                                value: item
                            }
                        }));
                    }
                });
            },
            autoFocus: false,
            minLength: 2
        });
    });



    var initTomSelecs = undefined;

    function initTomSelectProcedres(selector, departmentId) {
        initTomSelecs = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                                echo $patient_id . '&' ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        initTomSelecs.settings.minLength = 2;
    }
    var multiDiagnosisSelect = undefined;

    function initTomSelectDiagnosis(selector, departmentId) {
        multiDiagnosisSelect = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        multiDiagnosisSelect.settings.minLength = 2;
    }
    var treatemnts_ent = $("#treatemnts_ent").DataTable({
        bFilter: false,
        paging: false,
        info: false,
    });

    $("#addRow_general").on("click", function() {
        // if($("#diagnosis_general").val() === "") {
        //      alert('Diagnosis is required.');
        //       return false;

        //   }

        if ($("#procedure_general").val() == "-1") {
            alert("Procedure is required.");
            return false;
        }

        var split_diagnosis = $("input[name=diagnosis_general]").val().split(",");
        var primary_diagnosis = $("input[name=diagnosis_general]").val().split(" - ");

        var diag_name = "";
        $.each(split_diagnosis, function(index, value) {
            if (value) {
                
                var temp = value.split(" - ");
                diag_name += temp[1] + ",";
            }
        });

        var split_treatment = $("select[name=procedure_general]").val().split(" | ");
        

        if ($("input[name=diagnosis_general]").val().indexOf("-") == -1) {
            var diagnosis =
                $("input[name=diagnosis_general]").val() +
                '<input type="hidden" name="general_diagnosis_name[]" value="' +
                $("input[name=diagnosis_general]").val() +
                '"><input type="hidden" name="general_diagnosis_id[]" value="">';
        } else {
            var diagnosis =
                diag_name +
                '<input type="hidden" name="general_diagnosis_name[]" value="' +
                diag_name +
                '"><input type="hidden" name="general_diagnosis_id[]" value="' +
                primary_diagnosis[0] +
                '">';
        }



   

       


        var treat_general =
            split_treatment[1] +
            '<input type="hidden" name="general_treatment_name[]" value="' +
            split_treatment[1] +
            '"><input type="hidden" name="general_treatment_id[]" value="' +
            split_treatment[0] +
            '">';

        treatemnts_ent.row
            .add([
                counter,
                diagnosis,
              
                treat_general,
                '<input type="hidden" name="orig_price_general[]" value="' +
                split_treatment[3] +
                '"><input type="text" size="7" name="discountl[]" value="0" class="discount_general form-control">',
                '<input type="text" size="7" name="discount_per[]" value="0" class="discount_per_general form-control">',
                '<input type="text" name="fees_general[]" size="7" value="' +
                split_treatment[3] +
                '" class="fees_general form-control">',
                '<div class="text-center"><button type="button" class="btn btn-light deleteRow_general"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
            ])
            .draw();

        counter++;
        initTomSelecs.clear();
        multiDiagnosisSelect.clear();
      
    });

    $("body").on("click", ".deleteRow_general", function(e) {
        treatemnts_ent.row($(this).parents("tr")).remove().draw();
        return false;
    });

    //ent prescription
    var max_fields = 10; //maximum input boxes allowed
    var wrapper_ent = $(".input_fields_wrap_ent"); //Fields wrapper
    var add_button_ent = $(".add_field_button_ent"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button_ent).on("click", function(e) {
        //on add input button click
        var drug = $("input[name=drugs_ent]").val().split(" - ");
        var drug_qty = $("input[name=drug_qty_ent]").val();
        var meal = $("input[name=drug_meal_ent]").val();
        var drug_note = $("input[name=drug_note_ent]").val();

        if ($('input[name=drugs_ent]').val().length === 0) {
            alert("Please select drugs");
            return false;
        }

        if ($("input[name=drugs_ent]").val().indexOf("-") == -1) {
            var diagnosis =
                '<input type="text" class="form-control drugs" name="drug[]" value="' +
                drug[0] +
                '" id="drugs" disabled>' +
                '<input type="hidden" class="form-control drugs" name="drug_name_ent[]" value="' +
                drug[0] +
                '"><input type="hidden" class="form-control drugs" name="drug_id_ent[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="" id="drugs">';
        } else {
            var diagnosis =
                '<input type="text" class="form-control drugs" name="drug[]" value="' +
                drug[1] +
                '" id="drugs" disabled>' +
                '<input type="hidden" name="drug_name_ent[]" value="' +
                drug[1] +
                '"><input type="hidden" name="drug_id_ent[]" value="' +
                drug[0] +
                '"><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="' +
                drug[2] +
                '" id="drugs">';
        }

        var treat =
            '<div class="row drug_details">\
          <div class="col-md-3">\
            <div class="form-group">' +
            diagnosis +
            '</div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
               <input type="text" class="form-control" name="drugs_qty_ent[]" value="' +
            drug_qty +
            '" id="drug_qty_ent" disabled>\
               <input type="hidden" class="form-control" name="drugs_qty_ent[]" value="' +
            drug_qty +
            '" id="drug_qty_ent" >\
            </div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
              <input type="text" class="form-control" name="meals_ent[]" value="' +
            meal +
            '" id="meal_ent" disabled>\
              <input type="hidden" class="form-control" name="meals_ent[]" value="' +
            meal +
            '" id="meal_ent">\
            </div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
              <div class="input-group">\
                <input type="text" class="form-control" name="drug_notes_ent[]" value="' +
            drug_note +
            '" id="drug_note_ent" disabled>\
                <input type="hidden" class="form-control" name="drug_notes_ent[]" value="' +
            drug_note +
            '" id="drug_note_ent">\
                <span class="input-group-addon">\
                <button type="button" class="btn btn-danger btn-xs remove_field_ent" id="remove_drug_ent">-</button>\
                </span>\
              </div>\
            </div>\
        </div>\
      </div>';

        $(wrapper_ent).append(treat);

        var drug = $("input[name=drugs_ent]").val("");
        var drug_qty = $("input[name=drug_qty_ent]").val("");
        var drug_note = $("input[name=drug_note_ent]").val("");
        var drug_meal = $("input[name=drug_meal_ent]").val("");
        // var drug_meal = $('input[name=meal_ent]').prop('checked', false);

        return false;
    });

    $(wrapper_ent).on("click", ".remove_field_ent", function(e) {
        //user click on remove text
        $(this).closest(".drug_details").remove();
        return false;
    });

    $(".clear_field_ent").on("click", function(e) {
        var drug = $("input[name=drugs_ent]").val("");
        var drug_qty = $("input[name=drug_qty_ent]").val("");
        var drug_note = $("input[name=drug_note_ent]").val("");
        var drug_meal = $("input[name=meal_ent]").prop("checked", false);
        return false;
    });
    var limit_discount= Number("<?php echo get_discount_limt($this) ?>");


    $('body').on('keyup', '.discount_general', function() {
        this_td = $(this).closest('td'),
            orig_price = $(this).prev('input').val(),
            dis_per_td = this_td.next('td');
        discount_per = $(dis_per_td).find('input').val(),
            fees_td = dis_per_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount = Number($(this).val()).toFixed(2);

            var dis_per =Number((discount * 100 / orig_price).toFixed(2));
                if(limit_discount !=''){
                if(dis_per > limit_discount){
                    
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
                    dis_per = limit_discount
                    discount =((dis_per * orig_price) / 100).toFixed(2);

                    $(this).val(discount);
                }
            }


    dis_per_td.find('input').val(dis_per); //discount_per //discount_per
        fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
    });

    $('body').on('keyup', '.discount_per_general', function() {
        this_td = $(this).closest('td'),
            dis_td = this_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees_td = this_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount_per = Number($(this).val()).toFixed(2);

            if(limit_discount !=''){
                if (discount_per > limit_discount) {
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
            $(this).val(limit_discount); // Optionally, reset the value to the limit
            discount_per = limit_discount; // Update discount_per to the limit value
            }
        }

        dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
        fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
    });

    $('body').on('keyup', '.fees_general', function() {
        this_td = $(this).closest('td'),
            dis_per_td = this_td.prev('td');
        discount_per = $(dis_per_td).find('input').val(),
            dis_td = dis_per_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees = Number($(this).val()).toFixed(2);

        dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
        dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
    });
</script>

</html>