<style>
    .uploadIcon {
        font-size: 5em !important;
        color: aquamarine;
    }

    @keyframes blink {
        0% {
            opacity: 0.5;
        }

        50% {
            opacity: 1;
        }

        100% {
            opacity: 0.5;
        }
    }

    .uploadLable {
        cursor: pointer;
        padding: 10px;
        cursor: pointer;
        animation: blink 1s infinite;
    }
</style>

<!-- Patient document upload modal -->
<div class="modal fade" id="uploadPatientDocumentModal" tabindex="-1" role="dialog" aria-labelledby="uploadPatientDocumentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="uploadPatientDocumentModalLabel">Upload New Document</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="fileUploadForm" class="text-center" enctype="multipart/form-data" action="<?php echo base_url('index.php/admin/Patients/PatientsController/uploadPatientDocs') ?>" method="POST">
                    <input type="hidden" name="patientId" value="<?= encrypt_and_url_encode($patient_id, $this) ?>">
                    <input type="hidden" name="redirect_to" value="<?= 'admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this) ?>">
                    <i class="fa fa-cloud-upload uploadIcon" aria-hidden="true"></i>
                    <div class="form-group">
                        <label for="patientDocument" class="uploadLable">Choose a file</label><br>
                        <p class="text-danger" style="font-size:17px">Support only .pdf.jpg.xls.jpeg.png.docx files.</p>
                        <?php if (form_error("patientDocument")) : ?>
                            <br><label><small class="text-danger"><?= form_error("patientDocument"); ?></small></label>
                            <script>
                                $(document).ready(function() {
                                    $("#uploadPatientDocumentModal").modal("show");
                                });
                            </script>
                        <?php endif; ?>
                        <input type="file" class="form-control" name="patientDocument" id="patientDocument" accept=".pdf, .doc, .docx"  onchange="handleFileSelect()">
                        <div class="form-group <?php echo form_error("documentName") ? "has-error" : "" ?>">
                            <label for="document_name">Document Name</label>
                            <input type="text" class="form-control" name="documentName" id="document_name" <?= $document_name; ?>>
                            <label><small class="text-danger"><?= form_error("documentName"); ?></small></label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="$('#fileUploadForm').submit()">Save changes</button>
            </div>
        </div>
    </div>
</div>
<hr>

<div class="row ">
    <div class="col-12">
        <div class="d-flex justify-content-between">
            <!-- <h4>File & Documents</h4> -->
            <button class="btn btn-dark" id="uploadDocumentBtn" data-toggle="modal" data-target="#uploadPatientDocumentModal">
                <i class="fa fa-cloud-upload" aria-hidden="true"></i>
                <span>Upload New Documents</span>
            </button>
        </div>
        <hr>
        <div class="">
          <ul class="nav nav-tabs bg-light tab_list1" role="tablist">
            <li role="presentation" class="nav-item active">
              <a href="#documents-tab" aria-controls="home" role="tab" class="nav-link font-weight-bold" data-toggle="tab">Documents</a>
            </li>
            <li role="presentation" class="nav-item">
              <a href="#consents-tab" aria-controls="messages" role="tab" class="nav-link font-weight-bold" data-toggle="tab">Consent Forms</a>
            </li>
          </ul>
        </div>
        <div class="row mt-1" id="documents-tab">
            <div class="col-md-12">
            <h6 class="card-title">All Documents</h6>
            </div>
            
            <?php foreach ($documents as $document) : ?>
                <?php
                $uploadPath = './'.UPLOAD_PATH.'patients/' . md5($document->patient_id);
                $filePath = $uploadPath . '/' . $document->document;
                $fileExtension = (pathinfo($filePath, PATHINFO_EXTENSION));
                $preview = null;
                // print_r($fileExtension);
                switch (strtolower($fileExtension)) {
                    case 'pdf':
                        $preview = '<i class="fa fa-file-pdf-o text-danger mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;

                    case 'docx':
                    case 'doc':
                        $preview = '<i class="fa fa-file-word-o text-primary mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;

                    case 'txt':
                        $preview = '<i class="fa fa-file-text mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;

                    case 'xlsx':
                    case 'csv':
                        $preview = '<i class="fa fa-file-excel-o text-success mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;

                    case 'jpg':
                        $preview = '<i class="fa fa-file-image-o mr-2 text-warning" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;
                    case 'jpeg':
                        $preview = '<i class="fa fa-file-image-o mr-2 text-warning" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;$preview = '<i class="fa fa-file-image-o mr-2 text-warning" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;
                    case 'png':
                        $preview = '<i class="fa fa-file-image-o mr-2 text-warning" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;
                    case 'gif':
                        $preview = '<i class="fa fa-file-image-o mr-2 text-warning" style="font-size:1.5em;" aria-hidden="true"></i>';
                        break;

                    default:
                        $preview = "File type not supported.";
                        break;
                }

                ?>
                <div class="col-sm-3 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title"><?= $preview; ?><?= $document->name; ?></h6>
                            <a href="<?= base_url('index.php/admin/Patients/PatientsController/downloadFile/' . $document->patient_id . '/' . $document->document) ?>" class="btn btn-light btn-sm" target="_blank ">
                            <i class="fa fa-cloud-download" aria-hidden="true"></i> Download
                        </a>
                        <a data-file="<?= base_url('index.php/admin/Patients/PatientsController/viewFile/' . $document->patient_id . '/' . $document->document) ?>" class="btn btn-light btn-sm view_file">
                            <i class="fa fa-search" aria-hidden="true"></i> View
                        </a>
                        <a onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Patients/PatientsController/deleteFile/' . $document->id) ?>')" class="btn btn-light btn-sm delete_file">
                            <i class="fa fa-trash" aria-hidden="true"></i> Delete
                        </a>
                       
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <!-- //conent forms -->
        <div class="row mt-1" id="consents-tab">
            <div class="col-md-12">
            <h6 class="card-title">Consent Forms</h6>
            </div>
            
            <?php foreach ($consentForms as $consent) : ?>
                <?php
                ?>
                <div class="col-sm-3 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title"><?= $consent->consent_name; ?></h6>
                        
                            <a href="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/view/?lang=' . $consent->consent_lang . '&type=' . $consent->consent_type . '&id=' . $consent->consent_data_id) ?>" class="btn btn-light btn-sm" target="_blank">
                            View Consent
                        </a>
                       
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<script>
    $('.view_file').click(function(e) {
    var file = $(this).attr('data-file');
    $('.floating-window-file').css({
        'display': 'block'
    });
    $.ajax({
        type: 'GET',
        url: file,
        success: function(data) {
            // window.open(data, '_blank')
            $('#file-content').html('<iframe src="' + data + '" style="width: 100%!important; height: 100%;" frameborder="0"></iframe>');

        }
    });
})
$(document).ready(function() {
  // Handle the click event for the English tab
  $('a[href="#consents-tab"]').on('click', function(e) {
    e.preventDefault(); // Prevent default behavior
    // Remove the 'active' class from all tabs
    $('.nav-item a').removeClass('active');
    // Add 'active' class to the clicked tab
    $(this).addClass('active');
    // Hide all tab panes
    $('#documents-tab').hide();
    // Show the English tab pane
    $('#consents-tab').show();
  });

  // Handle the click event for the Arabic tab
  $('a[href="#documents-tab"]').on('click', function(e) {
    e.preventDefault(); // Prevent default behavior
    // Remove the 'active' class from all tabs
    $('.nav-item a').removeClass('active');
    // Add 'active' class to the clicked tab
    $(this).addClass('active');
    // Hide all tab panes
    $('#consents-tab').hide();
    // Show the Arabic tab pane
    $('#documents-tab').show();
  });

  // Initialize: Set English tab as visible and active on page load
  $('#documents-tab').show();
  $('#consents-tab').hide();
  $('a[href="#documents-tab"]').addClass('active');
});

</script>