<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


	<?php require_once(APPPATH . "views/admin/header.php"); ?>
    <style>
        .discussion{
            max-height: 40vh;
            min-height: 40vh;
            overflow-y: scroll;
        }
        .media-custom{
            display: flex;
            align-items: center;
           
        }
        .media-body-custom{
            display: flex;
           
            flex-direction: column;
        }
        .bg-d-light{
            background-color: #e9f8ff;
        }
        .bg-d-dark{
            background-color: #fff8f8;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->

	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Progress <?php echo $_id > 0 ? 'Update' : '' ?></strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<section class="content">

			<!--buttons-->

			<div class="row">
				<div class="col-12">
					<div class="box box-solid">
						<div class="box-body">
						<div class="card mb-3">
                <div class="card-header">
                    <strong>Session #<?= htmlspecialchars($session['session_number']); ?></strong>
                </div>
                <div class="card-body">
                    <p>Date: <?= htmlspecialchars($session['session_date']); ?></p>
                    <p>Coordinator: <?= htmlspecialchars($session['coordinator_name']); ?></p>
                    <p>Status: <?= htmlspecialchars($session['status']); ?></p>
                </div>
            </div>

            <h5>Progress Notes</h5>
            <div id="progressNotes">
                <?php if (count($progress_updates) > 0): ?>
                    <?php foreach ($progress_updates as $update): ?>
                        <div class="progress-note">
                            <p><strong><?= htmlspecialchars($update['progress_date']); ?></strong></p>
                            <p><?= nl2br(htmlspecialchars($update['progress_detail'])); ?></p>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p>No progress notes available.</p>
                <?php endif; ?>
            </div>

            <h5 class="mt-4">Add Progress Note</h5>
            <form id="addProgressForm">
                <div class="form-group">
                    <label for="progressDetail">Progress Detail</label>
                    <textarea class="form-control" id="progressDetail" rows="4" required></textarea>
                </div>
                <button type="submit" class="btn btn-dark">Add Progress</button>
            </form>
                      
                        </div>
                    </div>
                </div>
            </div>
		</section>
	
		</form>
	
	</div>

	<!-- ./wrapper -->


	<?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>


