
    <h5 class="text-left font-weight-bold mb-1">Plans Overview</h5>

    <div class="row">
        <?php foreach ($plans as $key=>$plan): ?>
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="d-inline-block">
                        <h5 class="text-uppercase"><?php echo $plan->plan_name; ?></h5>
                        <p>Doctor: <?php echo $plan->doctor_name; ?> | Patient ID: <?php echo $plan->patient_id; ?></p>

                       
                        </div>
                        <div>
                        <button class="btn btn-light btn-sm mt-2 makeTreatmentButton" 
                                    type="button" 
                                    data-plan-id="<?php echo $plan->plan_id; ?>">
                                <i class="fa fa-save"></i> Make Treatment
                            </button>
                    </div>
                           
                        
                    </div>
                    <div class="card-body">
                        <p><strong>Created At:</strong> <?php echo $plan->created_at; ?></p>
                      
                        <p><strong>Department ID:</strong> <?php echo $plan->department_id; ?></p>
                        <p><strong>Total:</strong> <?php echo json_decode($plan->payment_data)->total; ?> QAR</p>
                        <p><strong>Total Discount:</strong> <?php echo json_decode($plan->payment_data)->discount; ?> QAR</p>
                        
                        <div class="episode-payment">
                            <h6>Treatments Details:</h6>
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Select</th>
                                        <th>Original Price</th>
                                        <th>Discount</th>
                                        <th>Fees</th>
                                        <th>Treat Type</th>
                                        <th>Teeth Number</th>
                                        <th>Procedure</th>
                                        <th>Additional Diagnosis</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php 
                                            $episodePayment = json_decode($plan->episode_payment)->treatment; // Decode once
                                        ?>
                                        <?php foreach($episodePayment as $episodePayment){ ?>
                                        <tr>
                                        
                                        <td>
                                            <input type="checkbox" name="episode_select[]" value="<?php echo $episodePayment->key_id; ?>" data-plan="<?php echo $plan->plan_id; ?>">
                                        </td>
                                        <td><?php echo $episodePayment->orig_price; ?></td>
                                        <td><?php echo $episodePayment->discount_qr; ?></td>
                                        <td><?php echo $episodePayment->fees; ?></td>
                                        <td><?php echo $episodePayment->treat_type; ?></td>
                                        <td><?php echo $episodePayment->teeth_number; ?></td>
                                        <td><?php echo get_procedure_name($episodePayment->procedure_id,$this) ?></td>
                                        <td><?php echo $episodePayment->diagnostise_id . ' - ' . $episodePayment->aditional_diagnostise_name; ?></td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

<script>
    $(document).on('click', '.makeTreatmentButton', function() {
        var base_url= "<?php echo base_url(); ?>";
    const planId = $(this).data('plan-id'); // Get the plan ID from the button
    const selectedValues = [];

    // Get all checkboxes for the current plan
    const checkboxes = $('input[name="episode_select[]"][data-plan="' + planId + '"]');

    // Check if at least one checkbox is checked
    checkboxes.each(function() {
        if ($(this).is(':checked')) {
            selectedValues.push($(this).val()); // Add selected checkbox value to array
        }
    });
    console.log(selectedValues);
    if (selectedValues.length === 0) {
        errorNotification('Please select at least one from this plan.');
    } else {
        // If at least one checkbox is selected, send AJAX request
        $.ajax({
            url: base_url+'admin/Modules/Dental/DentalController/make_treatment_plan', // Replace with your actual controller method
            method: 'POST',
            data: {
                selected: selectedValues,
                plan_id: planId // Send the associated plan ID
            },
            success: function(response) {
                // Handle success response
                successNotification(response);
                // Optionally refresh or update your UI
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.error(xhr.responseText);
            }
        });
    }
});
</script>