<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <!--image crop-->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>Pay <?php echo $_id > 0 ? 'Update' : 'New' ?></strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">

            <div class="row">
                <div class="col-12">
                    <div class="box box-info">
                        <div class="box-body">

                            <h4 class="page-header ui-page-header"><strong>Billing</strong></h4>
                            
                            <form id="myForm" action="<?= base_url('admin/Payments/PaymentsController/insertPayment'); ?>" method="post" autocomplete="off">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="panel panel-default">
                                            <div class="panel-body">
                                                <label for="">Select Patient</label>
                                                <input type="hidden" name="" id="pid" value="<?php echo $patient_id; ?>">
                                                <input type="text" name="patient_id" id="patient_id" value="" class="">
                                                <div class="input_fields_wrap_procedure">
                                                    <div class="row">
                                                        <div class="col-12 col-md-3">

                                                            <div class="form-group">
                                                                <label for="doctor_id">Select Department</label>
                                                                <select class="form-control" name="dept_id" id="dept_id">
                                                                    <?php foreach ($modules as $value) :  ?>
                                                                        <?php if ($value['department_id'] > 0) : ?>
                                                                            <option <?= ($module == $value['department_id']) ? 'selected' : '' ?> value="<?= $value['department_id'] ?>">
                                                                                <?= $value['module_name'] ?>
                                                                            </option>
                                                                        <?php endif; ?>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>

                                                        </div>

 <div class="col-12 col-md-3">
                                                            <div class="form-group">
                                                                <label for="doctor_id">Select Doctor</label>
                                                                <select class="form-control" name="doctor_id" id="doctor_id">
                                                                    <?php
                                                                    foreach ($doctors as $value) {
                                                                        $select = $value->user_id == $doctor_id ? "selected" : "";
                                                                        echo "<option value='" . $value->user_id . "' $select>" . $value->full_name . "</option>";
                                                                    }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="col-12 col-md-6">

                                                            <div class="form-group w-100 col-md-12">
                                                                <label for="lab_test">Price list</label>
                                                                <div class="input-group  w-100 col-md-12">
                                                                    <select type="text" class="procedure w-50" name="billing_list" id="billing_list"></select>
                                                                    <input type="hidden" class="form-control ss" name="check" value="0">
                                                                    <span class="input-group-addon ml-1">
                                                                        <button type="button" class="btn btn-dark btn-sm add_field_button_billing" id="add_drug">
                                                                        <i class="fa fa-plus-circle" aria-hidden="true"></i>
                                                                        </button>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-xs-12 col-12">
                                                    <hr>
                                                    <div class="panel panel-primary">
                                                        <div class="panel-heading"><strong>Treatment List</strong></div>
                                                        <table class="table table-hover display table-striped orig" id="treatments_billing_list" width="100%">
                                                            <thead>
                                                                <tr>
                                                                    <td></td>
                                                                    <td>Procedure</td>
                                                                    <td>Quantity</td>
                                                                    <td width="10%">Discount(QR)</td>
                                                                    <td width="10%">Discount(%)</td>
                                                                    <td width="10%">Fees</td>
                                                                </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-11 " style="text-align: right">
                                                    <label>GROSS AMOUNT : </label>
                                                </div>
                                                <div class="col-1">
                                                    <strong id="gross_amount">0.00</strong>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-11" style="text-align: right">
                                                    <label>DISCOUNT : </label>
                                                </div>
                                                <div class="col-1">
                                                    <strong id="discount_amount">0.00</strong>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-11" style="text-align: right">
                                                    <label>NET AMOUNT : </label>
                                                </div>
                                                <div class="col-1">
                                                    <strong id="net_amount">0.00</strong>
                                                </div>
                                            </div>


                                            <button type="submit" class="btn btn-light btn-sm" id="invoice"><i class="fa fa-check-circle" aria-hidden="true"></i> Make Invoice</button>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
    </div>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>

    <script type="text/javascript">
        $(document).ready(function() {
            var procedureElements = document.querySelectorAll('.procedure');

            var procedureCount = procedureElements.length;

            for (var i = 0; i < procedureCount; i++) {
                var currentElement = procedureElements[i];
                var departmentId = $('#dept_id').val();
                initTomSelectProcedres(currentElement, departmentId);
            }

        });

        $('#dept_id').on("change", function() {
            var procedureElements = document.querySelectorAll('.procedure');

            var procedureCount = procedureElements.length;

            for (var i = 0; i < procedureCount; i++) {
                var currentElement = procedureElements[i];
                if (currentElement.tomselect) {
            currentElement.tomselect.destroy();
        }
                var departmentId = $('#dept_id').val();
                initTomSelectProcedres(currentElement, departmentId);
            }
            initTomSelectProcedres(currentElement, departmentId);
            HTMLFormControlsCollection.log(departmentId);
        });
        var initTomSelecs;
        function initTomSelectProcedres(selector, departmentId) {
            var patient_id= $('#patient_id').val();
         
            initTomSelecs = new TomSelect(selector, {
                valueField: 'id',
                labelField: 'name',
                searchField: 'name',
                // Set the "load" property to define the function to fetch data dynamically
                load: function(query, callback) {
                    
                    var apiUrl = "<?= base_url('admin/CommenController/get_procedures?p='); ?>"+patient_id +"&t=" + departmentId + "&q=" + encodeURIComponent(query);

                    fetch(apiUrl)
                        .then(response => response.json())
                        .then(data => {
                            callback(data);
                        })
                        .catch(() => {
                            callback();
                        });
                },
                render: {
                    option: function(item, escape) {
                        return '<div>' +
                            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                            '</div>';
                    },
                    item: function(item, escape) {
                        return '<div>' +
                            '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                            '</div>';
                    }
                },
            });

            // Optional: You can also set a minimum number of characters before triggering the API call
            initTomSelecs.settings.minLength = 2;
        }

       
        $('#myForm').submit(function() {
            if ($('#treatments_billing_list tr').parent().siblings(":first").text() == "No data available in table") {
                alert("Add treatment details");
                return false;
            } else {
                $(this).submit();
            }
        });

        var counter = 1;
        var a = $('#treatments_billing_list').DataTable({
            "bFilter": false,
            "paging": false,
            "info": false
        });
        var add_button_billing = $(".add_field_button_billing");

        $(add_button_billing).on('click', function(e) {

            var procedureValue = $('.procedure').val();

                // Check if a value exists before splitting
                if (!procedureValue) {
                    errorNotification('Please Select Procedure')
                    return; // Exit if no procedure is selected
                }
            var split_treatment = $('.procedure').val().split(' | ');
           

       
            var treat_billing = split_treatment[1] + '<input type="hidden" name="billing_treatment_name[]" value="' + split_treatment[1] + '"><input type="hidden" name="billing_treatment_id[]" value="' + split_treatment[0] + '">';

            a.row.add([
          '<button type="button" class="btn btn-light btn-xs deleteRow_tre_billing"><i class="fa fa-trash"></i></button>',
          // diagnosis,
          treat_billing,
         
          '<input type="hidden" name="" value="' + split_treatment[3] + '" class="orig_price_cost"><input type="text" size="7" name="quantity_billing[]" value="1" class="quantity_billing">',
          '<input type="hidden" name="orig_price_billing[]" value="' + split_treatment[3] + '" class="orig_price_lab"><input type="text" size="7" name="discount_billing[]" value="0" class="discount_billing discount_lab">',
          '<input type="text" size="7" name="discount_per_billing[]" value="0" class="discount_per_billing discount_per_lab">',
          '<input type="text" name="fees_billing[]" size="7" value="' + split_treatment[3] + '" class="fees_billing fees_lab">'
        ])

        .draw();

            counter++;
            $('#billing_list').val("");
           initTomSelecs.clear();
            calcu_fee();
        });

        $('body').on("click", ".deleteRow_tre_billing", function(e) {
            a.row($(this).parents('tr')).remove().draw();
            calcu_fee();
            return false;
        });

        $('#bl_button').click(function() {
            if ($('#billing_list').val() != "") {
                alert("Please click the + button to save billing");
                return false;
            }
            if ($("input[name='billing_treatment_id[]']").length === 0) {
                alert("Please Add Billing");
                return false;
            }
            $('#billing_form').submit();
        });

        function calcu_fee() {
            var total_gross = 0;
            var total_discount = 0;
            var total_fees = 0;
            $('.orig_price_lab').each(function() {
                total_gross += parseFloat($(this).val());
            });
            $('.discount_lab').each(function() {
                total_discount += parseFloat($(this).val());
            });
            $('.fees_lab').each(function() {
                total_fees += parseFloat($(this).val());
            });
            $('#gross_amount').html(total_gross.toFixed(2));
            $('#discount_amount').html(total_discount.toFixed(2));
            $('#net_amount').html(total_fees.toFixed(2));
        }

        $('body').on('keyup', '.discount_billing', function() {
            this_td = $(this).closest('td'),
                orig_price = $(this).prev('input').val(),
                dis_per_td = this_td.next('td');
            discount_per = $(dis_per_td).find('input').val(),
                fees_td = dis_per_td.next('td');
            fees = $(fees_td).find('input').val(),
                discount = Number($(this).val()).toFixed(2);

            dis_per_td.find('input').val(Number((discount * 100 / orig_price)).toFixed(2)); //discount_per
            fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
            calcu_fee();
        });

        $('body').on('keyup', '.discount_per_billing', function() {
            this_td = $(this).closest('td'),
                dis_td = this_td.prev('td'),
                orig_price = $(dis_td).find('input').val(),
                discount = $(dis_td).find('input').next().val(),
                fees_td = this_td.next('td');
            fees = $(fees_td).find('input').val(),
                discount_per = Number($(this).val()).toFixed(2);

            dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
            fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
            calcu_fee();
        });

        $('body').on('keyup', '.fees_billing', function() {
            this_td = $(this).closest('td'),
                dis_per_td = this_td.prev('td');
            discount_per = $(dis_per_td).find('input').val(),
                dis_td = dis_per_td.prev('td'),
                orig_price = $(dis_td).find('input').val(),
                discount = $(dis_td).find('input').next().val(),
                fees = Number($(this).val()).toFixed(2);

            dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
            dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
            calcu_fee();
        });
          $('body').on('keyup', '.quantity_billing', function() {
      qty = $(this).val(),
        this_td = $(this).closest('td'),
        orig_price_cost = $(this_td).find('input').prev().val(),
        dis_per_td = this_td.next('td');
      $(dis_per_td).find('input').prev().val(orig_price_cost * qty);
      orig_price = $(dis_per_td).find('input').prev().val(),
        discount = $(dis_per_td).find('input').next().val(),
        fees_td = dis_per_td.next('td').next('td');

      //dis_per_td.find('input').val(Number((discount * 100 / orig_price))); //discount_per
      fees_td.find('input').val(Number((orig_price) - discount).toFixed(2)); //fees
      calcu_fee();
    });



      
     
        var patientId= $('#pid').val();
      
          const  initTomSelecsPatient = new TomSelect('#patient_id', {
                valueField: 'patient_id',
                maxItems:1,
                closeAfterSelect:true,
                preload:true,
              
                plugins: ['change_listener'],
                labelField: 'patient_name',
                searchField: ['patient_name','patient_id','qatar_id'],
                // Set the "load" property to define the function to fetch data dynamically
                load: function(query, callback) {
                     var pid= $('#pid').val();
                     if(pid !=''){
                         query=pid
                     }
                    var apiUrl = "<?= base_url('admin/CommenController/get_patients?p=');?>" + encodeURIComponent(query);
                    $("#global-loader").show(); 
                    fetch(apiUrl)
                        .then(response => response.json())
                        .then(data => {
                            $("#global-loader").hide(); 
                            callback(data);
                        })
                        .catch(() => {
                            $("#global-loader").hide(); 
                            callback();
                        });
                },
                onLoad:function(options,callback){
                   var pid= $('#pid').val();
                   if(pid !=''){
                       query=pid
                   }
                    initTomSelecsPatient.setValue([pid]);
                },
                
                render: {
                    option: function(item, escape) {
                        return '<div>' +
                            '<span class="btn btn-sm">' +  escape(item.patient_id) +'-'+ escape(item.patient_name) + '</span>' +
                            '</div>';
                    },
                    item: function(item, escape) {
                        return '<div>' +
                            '<span class="btn  btn-sm">' + escape(item.patient_id) +'-'+ escape(item.patient_name)  + '</span>' +
                            '</div>';
                    }
                },
            });

            // Optional: You can also set a minimum number of characters before triggering the API call
            initTomSelecsPatient.settings.minLength = 2;
            initTomSelecsPatient.on('change',function(){
                console.log('change');
            if (initTomSelecs) {
                initTomSelecs.destroy();
                 }
                var departmentId = $('#dept_id').val();
                initTomSelectProcedres('#billing_list', departmentId);
        })
        
    </script>
</body>

</html>