<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Loyalty Points Transactions </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>

  <?php 

  require_once(APPPATH . "views/admin/header-simple.php");

  ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php 
  
   require_once(APPPATH . "views/admin/top_bar.php"); 
  
   ?> 

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper transition-fade" id="" class="">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <strong>Loyalty Points</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->

      <section class="content">

        <!--table-->
        <div class="row">
          <div class="col-12">
            <div class="box box-solid" style="margin-bottom: 5px;">
              <div class="box-body">
                <div class="row">
                  <div class="col-md-4">
                  <h5 class="card-title"><strong>Patient Name :</strong> <a href="<?php echo base_url('/admin/Patients/PatientsController/medical_book/'.encrypt_and_url_encode($patient_id,$this)) ?>"><?= $patient->patient_name; ?> </a> </h5>
                  <h5 class="card-title"><strong>File No :</strong> <?= $patient_id ?></h5>
                </div>
                  <div class="col-md-4 text-right">
                  
                  </div>
                  <div class="col-md-4 text-right">
                   
                    <div class="float-right">
                      <a class="btn btn-dark btn-sm" href="<?php echo base_url('index.php/admin/Payments/PaymentsController/createBill') ?>">
                        <i class="fa fa-plus-circle" aria-hidden="true"></i>
                        Add Points
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
            
        <div class="box box-info">

          <div class="box-body">
            


           
            <div class="col-md-12 justify-content-center  align-items-center module_loader" style="display: none;" >
											<div class="spinner spinner-border spinner-border-sm text-primary mx-auto" ></div>
											</div>
              <div class="row" id="home">

                <div class="col-md-4 mt-3">
                <div class="form-group">
                  <label for="">Type</label>
                  <select name="status_filter" class="form-control" id="status_filter">
                    <option value="">All</option>
                    <option value="redeem">Redeem</option>
                    <option value="earn">Earned</option>
                  </select>
                </div>
                </div>
               
                <div class="box-body table-responsive">
                  <table id="invoices_list" class="table table-bordered table-striped">
                  </table>
                </div>
              </div>
             
            </div>
          
          <!-- /.box-body -->
        </div>
       

        <!--//table-->
        <input type="hidden" id="selected_id" name="selected_id">
        <input type="hidden" id="formSubmit" name="formSubmit" value="submitForm">
        <input type="hidden" id="form" name="form" value="Payments">


      </section>


  

  </div>

  <!-- ./wrapper -->


  <?php 

  require_once(APPPATH . "views/admin/footer-simple.php");

  ?>

  <script>

$(document).ready(function () {
  var is_whatsapp= "<?php echo is_whatsapp($this) ?? 0; ?>";

  invoice_list(is_whatsapp);
});

function invoice_list(is_whatsapp){

  var status= $("#status_filter").val();
 
  var dataTableInvoice = $('#invoices_list').DataTable({
    'ajax': {
      'url': '<?= site_url('admin/Payments/PaymentsController/get_loyalty_transactions'); ?>',
      'type': 'GET',
      'data': function(d) {
        d.patient_id = "<?php echo $patient_id; ?>",
        d.status=$("#status_filter").val()
      }
    },

    'columns': [
      {
        'data': 'treatment_payment_id',
        'title': 'Inv. No',
      },
      {
        'data': 'transaction_type',
        'title': 'Type'
      },
      {
        'data': 'user_id',
        'title': 'Patient Name'
      },
      {
        'data': 'points',
        'title': 'Points'
      },
      {
        'data': 'transaction_date',
        'title': 'Transaction Date'
      },
      
    ],
    'order': [
      [1, 'desc']
    ],
    'serverSide': true,
    "stateSave": true,
    // 'pageLength': 10,
    'lengthMenu': [10, 25, 50, 100, -1],
    'pagingType': 'full_numbers',
    'autoWidth': false,
    'columnDefs': [{
      'targets': -1, // Target the last column (Actions column)
      'className': 'dt-center'
    }],
    stateSaveCallback: function(settings, data) {
      localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
    },
    stateLoadCallback: function(settings) {
      return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
    },
  });
  $("#status_filter").change(function(){
    dataTableInvoice.ajax.reload();
  })
}




// $(document).on('click','.send_whatsapp', function() {
   
//     var id = $(this).data('patient-id'); // assuming a data attribute holds the patient ID
  
//     Swal.fire({
//         title: 'Sending...',
//         text: 'Please wait while we send your message.',
//         allowOutsideClick: false,
//         didOpen: () => {
//             Swal.showLoading();  // Start the loading animation
//         }
//     });
//     $.ajax({
//         url: '<?php echo base_url('admin/Payments/PaymentsController/send_whatsapp') ?>',  // Replace with your server-side URL
//         type: 'POST',
//         data: { 
//             id: treatmentId,
          
//         },
//         success: function(response) {
//           Swal.close();

//       // Show success alert
//       Swal.fire({
//           icon: 'success',
//           title: 'Message Sent!',
//           text: 'The WhatsApp message was sent successfully.'
//       });
            
//         },
//         error: function(xhr, status, error) {
//             // Hide loader popup in case of error
//             Swal.close();

//           // Show error alert
//           Swal.fire({
//               icon: 'error',
//               title: 'Error!',
//               text: 'Failed to send WhatsApp message. Please try again later.'
//           });
//         }
//     });
// });
</script>
</body>


</html>