<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Payments List </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>

  <?php 

  require_once(APPPATH . "views/admin/header-simple.php");

  ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php 
  
   require_once(APPPATH . "views/admin/top_bar.php"); 
  
   ?> 

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper transition-fade" id="" class="">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <strong>Payments List</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->
    <form id="submitForm" name="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Patients/PatientsController/search') ?>" method="post">

      <section class="content">

        <!--table-->
        <div class="row">
          <div class="col-12">
            <div class="box box-solid" style="margin-bottom: 5px;">
              <div class="box-body">
                <div class="row">
                  <div class="col-md-4"></div>
                  <div class="col-md-4 text-right"></div>
                  <div class="col-md-4 text-right">
                    <div class="float-right">
                      <a class="btn btn-dark btn-sm" href="<?php echo base_url('index.php/admin/Payments/PaymentsController/createBill') ?>">
                        <i class="fa fa-plus-circle" aria-hidden="true"></i>
                        Create Bill
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="box box-info">

          <div class="box-body">
            <ul class="nav nav-tabs" id="form_recipt" role="tablist">
              <li class="nav-item" id="non_insurance">
                <a class="nav-link font-weight-bold active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Invoices</a>
              </li>
              <li class="nav-item" id="insurance">
                <a class="nav-link font-weight-bold" id="receipt-tab" data-toggle="tab" href="#receipt-content" role="tab" aria-controls="receipt" aria-selected="false">Receipts</a>
              </li>
              <li class="nav-item" id="insurance-nav">
                <a class="nav-link font-weight-bold" id="insurance-tab" data-toggle="tab" href="#insurance-content" role="tab" aria-controls="insurance" aria-selected="false">Insurance</a>
              </li>
            </ul>


            <div class="tab-content" id="form_recipt_content">
            <div class="col-md-12 justify-content-center  align-items-center module_loader" style="display: none;" >
											<div class="spinner spinner-border spinner-border-sm text-primary mx-auto" ></div>
											</div>
              <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">

                <div class="col-md-12 mt-3">
                  <div class="row">

                    <div class="form-group col-md-3">
                    <label for="">Payment Status</label>
                    <select name="status_filter" class="form-control" id="status_filter">
                      <option value="">All</option>
                      <option value="1">Pending</option>
                      <option value="2">Completed</option>
                    </select>
                  </div>
                  <div class="form-group col-md-3">
                    <label for="">Patient Mobile</label>
                    <input type="number" class="form-control" name="patient_mobile" id="patient_mobile" placeholder="Search By Mobile">
                  </div>
                  <div class="form-group col-md-3">
                    <label for="">Patient File No</label>
                    <input type="number" class="form-control" name="patient_mobile" id="patient_file" placeholder="Search By Patient File">
                  </div>


                  </div>
                
                </div>
               
                <div class="box-body table-responsive">
                  <table id="invoices_list" class="table table-bordered table-striped">
                  </table>
                </div>
              </div>
              <div class="tab-pane fade" id="receipt-content" role="tabpanel" aria-labelledby="receipt-tab">
                <div class="box-body  table-responsive">
                  <table class="table table-hover display table-striped w-100" id="receipts_list">
                  </table>
                </div>
              </div>
              <div class="tab-pane fade" id="insurance-content" role="tabpanel" aria-labelledby="insurance-tab">
                <div class="box-body  table-responsive">
                  <table class="table table-hover display table-striped w-100" id="insurance_list">
                  </table>
                </div>
              </div>
            </div>
          </div>
          <!-- /.box-body -->
        </div>

        <!--//table-->
        <input type="hidden" id="selected_id" name="selected_id">
        <input type="hidden" id="formSubmit" name="formSubmit" value="submitForm">
        <input type="hidden" id="form" name="form" value="Payments">


      </section>


    </form>

  </div>

  <!-- ./wrapper -->


  <?php 

  require_once(APPPATH . "views/admin/footer-simple.php");

  ?>

  <script>

$(document).ready(function () {
  var currentUserId = "<?php echo $this->session->userdata('user_Id') ?>";
 
  var is_whatsapp= "<?php echo is_whatsapp($this) ?? 0; ?>";

  if (!$.fn.DataTable.isDataTable('#invoices_list')) {
   
              invoice_list(is_whatsapp);
          }
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
      var is_whatsapp= "<?php echo is_whatsapp($this) ?? 0; ?>";
  // activated tab
        var tab_id = $(e.target).attr('id');
        console.log(tab_id);
        if(tab_id == 'home-tab'){
          $('.module_loader').show();
          if (!$.fn.DataTable.isDataTable('#invoices_list')) {
           
              invoice_list(is_whatsapp);
          }
          $('.module_loader').hide();

        }else if(tab_id == 'receipt-tab'){
          $('.module_loader').show();
          if (!$.fn.DataTable.isDataTable('#receipts_list')) {
              receipts_list();
          }
          $('.module_loader').hide();
        }
        else if(tab_id == 'insurance-tab'){
          $('.module_loader').show();
          if (!$.fn.DataTable.isDataTable('#insurance_list')) {
              insurance_list();
          }
          $('.module_loader').hide();
        }
		 

    });
});
  $(document).on('click', '[data-control=medical_click]', function(e) {

    var selected_id = e.target.id;
    var form = $('#formSubmit').val();
    var url_ = $('#form').val();

    $('#selected_id').val(selected_id);

    var URL = url_ + 'Controller/medical_book/' + selected_id;

    window.location.href = URL;

  });

function invoice_list(is_whatsapp){
  var currentUserId = "<?php echo $this->session->userdata('user_Id') ?>";
  
  var status= $("#status_filter").val();
 
  var dataTableInvoice = $('#invoices_list').DataTable({
    'ajax': {
      'url': '<?= site_url('admin/Payments/PaymentsController/get_invoice_list'); ?>',
      'type': 'GET',
      'data': function(d) {
        d.is_insurance = 1,
        d.status=$("#status_filter").val()
         d.patient_mobile=$("#patient_mobile").val()
        d.patient_file=$("#patient_file").val()
      }
    },

    'columns': [{
        'data': null,
        'title': '#',
        'render': function(data, type, row) {
          var htmlCont = '';

          if (row.due_amount > "0.00") {
            htmlCont += `<img width="29px" alt="Not Completed" title="Not Completed" src="<?php echo base_url('Images/warning.png') ?>"/>`
          } else {
            htmlCont += `<img width="32px" alt="Completed" title="Completed" src="<?php echo base_url('Images/complete.png') ?>"/>`
          };
          return htmlCont;
        }
      },
      {
        'data': 'treatment_payment_id',
        'title': 'Inv. No',
      },
      {
        'data': 'file_no',
        'title': 'File No'
      },
      {
        'data': 'patient_name',
        'title': 'Patient Name'
      },
      {
        'data': 'mobile',
        'title': 'Patient Mobile'
      },
      {
        'data': 'module_name',
        'title': 'Department'
      },
      
      {
        'data': 'treat_date',
        'title': 'Treatment Date'
      },
      {
        'data': 'total',
        'title': 'Gross Amount'
      },
      {
        'data': 'all_discount',
        'title': 'Discount'
      },
     {
        'data': '',
        'title': 'Total Paid',
          'render':function(data, type,row){
              return row.total_paid_amount ?? 0.00
          }
      },
      
      {
        'data': 'due_amount',
        'title': 'Due Amount'
      },
      {
        'data': 'full_name',
        'title': 'Doctor'
      },
      {
        'data': '',
        'title': 'Created By',
        'render': function(data, type, row) {
          if(row.created_by > 0){
            return row.created_by_name
          }else{
            return row.full_name
          }
        }
      },
      {
        'data': null,
        'title': 'Actions',
        'render': function(data, type, row) {
          if (row.module_name == 'Labortary') {
            return `
          <div class="d-flex justify-content-center w-100">
        <a title="Print" target="_blank" href="<?= base_url('index.php/admin/Invoice/InvoiceController/labInvoice/') ?>${row.invoice_id}" class="btn btn-light btn-sm float-right mr-1" style="margin-right: 3px;"><i class="fa fa-print"></i></a>
        
        <a title="Delete Payment" href="#" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Payments/PaymentsController/deleteInvoice/'); ?>${row.invoice_id}')" class="btn btn-light btn-sm float-right mr-1" style="margin-right: 3px;"><i class="fa fa-trash"></i></a>

        <a title="Pay" href="<?= base_url('index.php/admin/Payments/PaymentsController/view/') ?>${row.invoice_id}" href="#" class=" btn btn-light btn-sm float-right" style="margin-right: 3px;"><i id="${row.invoice_id}" class="fa fa-money"></i></a></div>`;
          } else {

          
            var ht = `
          <div class="d-flex justify-content-center w-100">
        <a title="Print" target="_blank" href="<?= base_url('index.php/admin/Invoice/InvoiceController/index/') ?>${row.invoice_id}" class="btn btn-light btn-sm float-right mr-1" style="margin-right: 3px;"><i class="fa fa-print"></i></a>`
      <?php  if(!check_right('delete_invoice', $this)){ ?>
        if(row.created_by == currentUserId){
          
              ht += `  
        <a title="Delete Payment" href="#" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Payments/PaymentsController/deleteInvoice/'); ?>${row.invoice_id}')" class="btn btn-light btn-sm float-right mr-1" style="margin-right: 3px;"><i class="fa fa-trash"></i></a>`
            }
       <?php  } ?>
        <?php if (check_right('delete_invoice', $this)) { ?>
              
                ht += `  
        <a title="Delete Payment" href="#" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Payments/PaymentsController/deleteInvoice/'); ?>${row.invoice_id}')" class="btn btn-light btn-sm float-right mr-1" style="margin-right: 3px;"><i class="fa fa-trash"></i></a>`
              
            <?php }
            if (check_right('pay_invoice', $this)) { ?>
              ht += ` <a title="Pay" href="<?= base_url('index.php/admin/Payments/PaymentsController/view/') ?>${row.invoice_id}" href="#" class=" btn btn-light btn-sm float-right" style="margin-right: 3px;"><i id="${row.invoice_id}" class="fa fa-money"></i></a>`
        
        <?php } ?>

              if(is_whatsapp ==1){
                ht+=`<a class="btn btn-sm btn-light send_whatsapp" target="_blank" href="<?= base_url('index.php/admin/Invoice/InvoiceController/index/') ?>${row.invoice_id}"><i class='fa fa-whatsapp'></i></a>`
              }
              
        `</div>`;

              return ht

          }
        }
      }
    ],
    'order': [
      [1, 'desc']
    ],
    'serverSide': true,
    "stateSave": true,
    // 'pageLength': 10,
    'lengthMenu': [10, 25, 50, 100],
    'pagingType': 'full_numbers',
    'autoWidth': false,
    'columnDefs': [{
      'targets': -1, // Target the last column (Actions column)
      'className': 'dt-center'
    }],
    stateSaveCallback: function(settings, data) {
      localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
    },
    stateLoadCallback: function(settings) {
      return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
    },
  });
  $("#status_filter").change(function(){
    dataTableInvoice.ajax.reload();
  })
  $("#patient_mobile").keyup(function(){
    dataTableInvoice.ajax.reload();
  })
  $("#patient_file").keyup(function(){
    dataTableInvoice.ajax.reload();
  })
}
function receipts_list(){
  var dataTableTreatment = $('#receipts_list').DataTable({
    'ajax': {
      'url': '<?= site_url('admin/Payments/PaymentsController/get_recipts_list'); ?>',
      'type': 'GET',
      'data': function(d) {
        d.is_insurance = 0
      }
    },

    'columns': [{
        'data': 'recipt_no',
        'title': 'Recipt No',
      },
      {
        'data': 'treatment_payment_id',
        'title': 'Invoice No'
      },
      {
        'data': 'patient_id',
        'title': 'File No'
      },
      {
        'data': 'patient_name',
        'title': 'Patient Name'
      },
       {
        'data': 'mobile',
        'title': 'Patient Mobile'
      },
      {
        'data': 'type_name',
        'title': 'Payment Type'
      },
      {
        'data': 'pay_date',
        'title': 'Payment Date'
      },
      {
        'data': 'pay_time',
        'title': 'Payment Time'
      },
      {
        'data': 'discount',
        'title': 'Discount'
      },
      {
        'data': 'cash',
        'title': 'Cash'
      },
      {
        'data': 'card',
        'title': 'Card'
      },
      {
        'data': 'full_name',
        'title': 'Created By'
      },
      {
        'data': null,
        'title': 'Actions',
        'render': function(data, type, row) {
          return `<div class="d-flex justify-content-center w-100">
              <?php if (check_right('edit_recipt', $this)) { ?>
                <a href="<?= base_url('index.php/admin/Payments/PaymentsController/editRecipt') ?>/${row.patient_payment_id}" class="btn btn-light btn-sm mr-1" title="Edit"><i class="fa fa-edit"></i></a>
                <?php }
              if (check_right('delete_recipt', $this)) { ?>
                <a href="#" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Payments/PaymentsController/deleteRecipt') ?>/${row.patient_payment_id}')" class="btn btn-light btn-sm mr-1" title="Delete"><i class="fa fa-trash"></i></a>
                <?php } ?>
                <a href="<?= base_url('index.php/admin/Receipt/ReceiptController/index') ?>/${row.patient_payment_id}" target="_blank" class="btn btn-light btn-sm" title="Print"><i class="fa fa-print"></i></a>
                  <a href="<?= base_url('index.php/admin/Receipt/ReceiptController/print_voucher') ?>/${row.patient_payment_id}/${row.patient_id}" target="_blank" class="btn btn-light btn-sm" title="Print"><i class="fa fa-print mr-1"></i>Print Voucher</a>
                
                
                </div>`;
        }
      }
    ],
    'order': [
      [0, 'desc']
    ],
    'serverSide': true,
    'pageLength': 10,
    'lengthMenu': [10, 25, 50, 100],
    'pagingType': 'full_numbers',
    'autoWidth': false,
    'columnDefs': [{
      'targets': -1, // Target the last column (Actions column)
      'className': 'dt-center'
    }]
  });
}

function insurance_list(){

  var dataTableInsurance = $('#insurance_list').DataTable({
    'ajax': {
      'url': '<?= site_url('admin/Payments/PaymentsController/get_recipts_list'); ?>',
      'type': 'GET',
      'data': function(d) {
        d.is_insurance = 1
      }
    },

    'columns': [{
        'data': 'recipt_no',
        'title': 'Recipt No',
      },
      {
        'data': 'treatment_payment_id',
        'title': 'Invoice No'
      },
      {
        'data': 'patient_id',
        'title': 'File No'
      },
      {
        'data': 'patient_name',
        'title': 'Patient Name'
      },
      {
        'data': 'pay_date',
        'title': 'Payment Date'
      },
      {
        'data': 'pay_time',
        'title': 'Payment Time'
      },
      {
        'data': 'co_payment',
        'title': 'Co Payment'
      },
      {
        'data': 'discount',
        'title': 'Discount'
      },
      {
        'data': 'excess',
        'title': 'Exccess'
      },
      {
        'data': 'insurance_amount',
        'title': 'Net Claim'
      },
      {
        'data': 'full_name',
        'title': 'Created By'
      },
      {
        'data': null,
        'title': 'Actions',
        'render': function(data, type, row) {
          return `<div class="d-flex justify-content-center w-100">
                <a href="<?= base_url('index.php/admin/Payments/PaymentsController/editRecipt') ?>/${row.patient_payment_id}" class="btn btn-light btn-sm mr-1" title="Edit"><i class="fa fa-edit"></i></a>
                <a href="#" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Payments/PaymentsController/deleteRecipt') ?>/${row.patient_payment_id}')" class="btn btn-light btn-sm mr-1" title="Delete"><i class="fa fa-trash"></i></a>
                <a href="<?= base_url('index.php/admin/Receipt/ReceiptController/insurance_recipt') ?>/${row.patient_payment_id}/${row.treatment_no}" target="_blank" class="btn btn-light btn-sm" title="Print"><i class="fa fa-print"></i></a></div>`;
        }
      }
    ],
    'order': [
      [0, 'desc']
    ],
    'serverSide': true,
    'pageLength': 10,
    'lengthMenu': [10, 25, 50, 100],
    'pagingType': 'full_numbers',
    'autoWidth': false,
    'columnDefs': [{
      'targets': -1, // Target the last column (Actions column)
      'className': 'dt-center'
    }]
  });
}

// $(document).on('click','.send_whatsapp', function() {
   
//     var id = $(this).data('patient-id'); // assuming a data attribute holds the patient ID
  
//     Swal.fire({
//         title: 'Sending...',
//         text: 'Please wait while we send your message.',
//         allowOutsideClick: false,
//         didOpen: () => {
//             Swal.showLoading();  // Start the loading animation
//         }
//     });
//     $.ajax({
//         url: '<?php echo base_url('admin/Payments/PaymentsController/send_whatsapp') ?>',  // Replace with your server-side URL
//         type: 'POST',
//         data: { 
//             id: treatmentId,
          
//         },
//         success: function(response) {
//           Swal.close();

//       // Show success alert
//       Swal.fire({
//           icon: 'success',
//           title: 'Message Sent!',
//           text: 'The WhatsApp message was sent successfully.'
//       });
            
//         },
//         error: function(xhr, status, error) {
//             // Hide loader popup in case of error
//             Swal.close();

//           // Show error alert
//           Swal.fire({
//               icon: 'error',
//               title: 'Error!',
//               text: 'Failed to send WhatsApp message. Please try again later.'
//           });
//         }
//     });
// });
</script>
</body>


</html>