<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Drug Report</h4>
                </div>
                <form  id="expire_report" method="post">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Select Supplier</label>
                          <select class="form-control" id="suppliers" name="suppliers">
                            <option value="-1">All</option>
                            <?php if(isset($suppliers) AND $suppliers != NULL){ foreach($suppliers as $val){ ?>
                                <option value="<?php echo $val['supplier_id']; ?>"><?php echo $val['supplier_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
                            </div>
							<div class="col-md-4">
                        <div class="form-group">
                          <label>Select Drug</label>
                          <select class="form-control" id="drug">
                          <option value="-1">All</option>
                            <?php if(isset($drugs) AND $drugs != NULL){ foreach($drugs as $val){ ?>
                                <option value="<?php echo $val['drug_id']; ?>"><?php echo $val['drug_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
						</div>
                            <div class="col-md-4">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
                        
                        </div>
                        <div class="col-md-4">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
                            </div>
                      </div>
                    </div>
                   
                    <button type="reset" class="btn  btn-dark hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>

<script>

function displayContent() {
        var dateFrom = $('#from').val();
        var dateTo = $('#to').val();
        console.log(dateFrom);
        var suppliers = $('#suppliers').val();
        $.ajax({
            url: "<?php $this->load->helper('url'); echo site_url('/admin/Reports/ReportsController/get_p_expiring_report'); ?>",
            type: 'post',
            data: {from:dateFrom, to:dateTo, suppliers:suppliers},
            success: function (result) {
                 $('#content').html(result);
            },
        });
     }
     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Pharmacy Expire Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Pharmacy Expire Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/get_p_expiring_report'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.suppliers = $('#suppliers').val();
					d.drug = $('#drug').val();
					d.from = $('#from').val();
					d.to = $('#to').val();
				}
			},
			'columns': [{
					'data': 'bill_id',
					'title': 'Bill No.'
				},
				{
					'data': 'batch',
					'title': 'Batch NO'
				},
				{
					'data': 'supplier_name',
					'title': 'Supplier Name'
				},
				{
					'data': 'drug_name',
					'title': 'Drug Name.'
				},
				{
					'data': 'remaining',
					'title': 'Remaining.'
				},
				{
					'data': 'x_date',
					'title': 'Expiration Date'
				},
				{
					'data': 'unit_type',
					'title': 'Unit Type'
				},
				
			],
			'searching': true,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#suppliers, #from,#to,#drug ').on('change', function() {
			dataTable.ajax.reload();
		});
        $('#clear').on('click', function() {
            $('#expire_report').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>