<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title> Purchase Statments </title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <!--image crop-->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/jquery.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/buttons.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">

    <?php require_once(APPPATH . "views/admin/header.php"); ?>
    <style>
        .small-box {
            text-decoration: none;
            color: #444444;
            transition-timing-function: ease-in-out;
            cursor: pointer;
        }

        .small-box:hover {
            text-decoration: none;
            color: #084a6ad9;
        }

        .small-box {
            box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
        }

        .inner {
            height: 120px;
        }

        .dashboard_icon {
            color: #084a6a;
            font-size: 50px;
        }

        .DTED_Lightbox_Content {
            border: none !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Header {
            background-color: #084a6a !important;
            color: white;
            height: 58px !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Footer {
            background-color: none !important;
        }

        .ui-autocomplete {
            max-height: 100px;
            max-width: 315px;
            overflow-y: auto;
            /* prevent horizontal scrollbar */
            overflow-x: hidden;
            z-index: 5000;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <section class="content-header">
            <h1><a href="<?php echo base_url('index.php/admin/Pharmacy/PharmacyController') ?>" class="btn btn-sm btn-dark"><i class="fa fa-angle-left"></i> Back</a>
                &nbsp;<strong>Pharmacy</strong><small>- Purchase Statements</small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>

        </section>
        <section class="content">
            <!--buttons-->


            <!--//buttons-->
            <?php require_once(APPPATH . "views/admin/Pharmacy/Financial/popup_pay.php"); ?>
           

            <div class="box box-info">

                <div class="box-body">

                <?php
                        $total_returned = 0;
                        $total_paid = 0;
                        if(isset($returned_list) AND $returned_list!=NULL){    
                            foreach ($returned_list as $row) {
                                $total_returned += $row['amount'];
                            }
                        }
                        if(isset($paid_list) AND $paid_list!=NULL){    
                            foreach ($paid_list as $row) {
                                $total_paid += $row['paid_amount'];
                            }
                        }
                        ?>

                        <div class="row">
                        <div class="col-md-4">
                             <ul class="list-group">
									<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Supplier No:</strong> <span><?= $statement->supplier_id; ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Supplier Name:</strong> <span><?=  $statement->supplier_name; ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Mobile No:</strong> <span><?= $statement->mobile; ?></span><br>
										</li>
										
								</ul>
                               
                            </div>
                            <div class="col-md-4">
                            <ul class="list-group">
									<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Total Gross Amount:</strong> <span><?= number_format($total_gross->amount+$statement->discount,2); ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Paid Amount:</strong> <span><?=  number_format($total_paid,2); ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Returned Amount:</strong> <span><?=  number_format($total_returned,2);  ?></span><br>
										</li>
										
								</ul>
                            </div>
                            <div class="col-md-4">

                            <ul class="list-group">
									<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Current Balance:</strong> <span><?= number_format($total_gross->amount-$total_paid,2); ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Actual Balance:</strong> <span><?=  number_format($total_gross->amount-$total_paid-$total_returned,2); ?></span><br>
										</li>
										<li class="list-group-item custom-list"><strong>
											<i class="fa" aria-hidden="true"></i>Total Discount:</strong> <span><?=  number_format($statement->discount,2);  ?></span><br>
										</li>
										
								</ul>
                              
                            </div>
                        </div>

                    <div class="col-md-12">
                        <div class="" style="background-color:#fff;">
                            <div class="table-responsive"><br>
                            <h3><strong>Paid List</strong></h3>
                               <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                  <thead>
                                      <tr>
                                          <th>Paid No.</th>
                                          <th>Invoice No.</th>
                                          <th>Bill No.</th>
                                          <th>Paid Date</th>
                                          <th>Paid</th>
                                          <th>Payment Method</th>
                                      </tr>
                                  </thead>
                                  <tbody>
                                      <?php if(isset($paid_list) AND $paid_list!=NULL){ ?>    
                                      <?php foreach ($paid_list as $row) {?>
                                      <tr>
                                        <td><?php echo $row['bill_paid_id']; ?></td>
                                        <td><?php echo $row['invoice_no']; ?></td>
                                        <td><?php echo $row['bill_id']; ?></td>
                                        <td><?php echo $row['bill_date']; ?></td>
                                        <td><?php echo $row['paid_amount']; ?></td>
                                        <td><?php echo $row['type']; ?></td>
                                      </tr>
                                      <?php }} ?>
                                  </tbody>
                              </table>                          
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="" style="background-color:#fff;">
                            <div class="table-responsive"><br>
                            <h3><strong>Returned List</strong></h3>
                               <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                  <thead>
                                      <tr>
                                          <th>Returned No.</th>
                                          <th>Invoice No.</th>
                                          <th>Bill No.</th>
                                          <th>Paid Date</th>
                                          <th>Paid</th>
                                          <th>Payment Method</th>
                                      </tr>
                                  </thead>
                                  <tbody>
                                      <?php if(isset($returned_list) AND $returned_list!=NULL){ ?>    
                                      <?php foreach ($returned_list as $row) {?>
                                      <tr>
                                        <td><?php echo $row['return_stock_id']; ?></td>
                                        <td><?php echo $row['invoice_no']; ?></td>
                                        <td><?php echo $row['bill_id']; ?></td>
                                        <td><?php echo date("Y-m-d",strtotime($row['return_date'])); ?></td>
                                        <td><?php echo $row['amount']; ?></td>
                                        <td><?php echo $row['type']; ?></td>
                                      </tr>
                                      <?php }} ?>
                                  </tbody>
                              </table>                          
                            </div>
                        </div>
                    </div>


                </div>
                <!-- /.box-body -->
            </div>

        </section>


        </form>

    </div>

    <!-- ./wrapper -->


    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
    

    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/jquery.dataTables.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.buttons.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.select.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.editor.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/purchaseBill.js') ?>" type="text/javascript"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/buttons.flash.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/jszip.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/pdfmake.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/vfs_fonts.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/buttons.html5.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/buttons.print.min.js'); ?>"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/lib/js/dataTables.responsive.js'); ?>"></script>


</body>
<script type="text/javascript">

        var table;
        table = $('#dataTables_price').DataTable({ 

            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "order": [], //Initial no order.

            // Load data for the table's content from an Ajax source
            "ajax": {
                "url": "<?php echo base_url(); ?>admin/Pharmacy/PharmacyController/financial_list",
                "type": "POST"
            },

            //Set column definition initialisation properties.
            "columnDefs": [
            { 
                "targets": [ -1 ], //last column
                "orderable": false, //set not orderable
            },
            ],
        });

        function pay_bill(id)
            {
            $('#bill_id').val(id);
            $('#app_poppup').modal({
                keyboard: false
            })
        }

    </script>

</script>

</html>