<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title> Product </title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

        <!--image crop-->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
        <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>

		
		

        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Products
                    <small>
						<?php echo $_id > 0 ? 'Update' : 'New' ?>
					</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

            <!-- Main content -->
            <form id="submitForm" name ="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Products/ProductsController/save') ?>" method="post" >
    <section class="content"> 
      
      <!--buttons-->
      
      <div class="row">
        <div class="col-xs-12">
          <div class="box box-solid">
            <div class="box-body">
              <div class="row"> <!-- Form Buttons   -->
                
                <div class="col-md-1">
                  <a href="<?php echo base_url('index.php/admin/Products/ProductsController') ?>" class="btn btn-info"><i class="fa fa-angle-left"></i> Go back </a>
                </div>
                <div class="col-md-9">
                  <?php if (validation_errors()) { ?>
                  <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                    <div>
                      <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p></div>
                  </div>
                  <?php } ?>
                </div>
			    <div class="col-md-2 text-right">
                  
                  <a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class=" btn btn-success "> <?php echo $_id > 0 ? 'Update product' : 'Save product' ?></a> 
					
				</div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--//buttons--> 
      
      <!--form-->
      <div class="row">
        <div class="col-xs-12">
          <div class="box box-info" style="margin-bottom: 5px;">
            <div class="box-header with-border">
              	<h2 class="box-title">Product details</h2>
				<div class="pull-right box-tools">
					<div class="btn-group">
					  <button class="btn btn-info btn-sm" data-widget="collapse"><i class="fa fa-minus"></i></button>
					</div>
			  	</div>
            </div>
            <div class="box-body">
				<div class="row" style="margin-bottom: 20px;">
					
					<div class="col-md-2">
						
						<div class="form-group" style="min-height: 0px;padding-left: 10px;">
							<label><input type="checkbox" id="is_active" name="is_active" value="active" <?php echo $is_active == 'active' ? 'checked' : '' ?>> Is active</label>

						  <label><small><?php echo form_error("is_active"); ?></small></label>
						</div>
					</div>
					
					<div class="col-md-2">
						<div class="form-group" style="min-height: 0px;padding-left: 10px;">
							<label><input type="checkbox" id="is_new_arrival" name="is_new_arrival" value="new arrival" <?php echo $is_new_arrival == 'new arrival' ? 'checked' : '' ?>> Is New Arrival</label>

						  <label><small><?php echo form_error("is_new_arrival"); ?></small></label>
						</div>
					</div>
					
					<div class="col-md-2">
						<div class="form-group" style="min-height: 0px;padding-left: 10px;">
							<label><input type="checkbox" id="is_get_free" name="is_get_free" value="get free" <?php echo $is_get_free == 'get free' ? 'checked' : '' ?>> Is Buy 1 Get 1 Free</label>

						  <label><small><?php echo form_error("is_get_free"); ?></small></label>
						</div>
					</div>
					
					<div class="col-md-2">
						<div class="form-group" style="min-height: 0px;padding-left: 10px;">
							<label><input type="checkbox" id="is_best_seller" name="is_best_seller" value="best seller" <?php echo $is_best_seller == 'best seller' ? 'checked' : '' ?>> Is Best Seller</label>

						  <label><small><?php echo form_error("is_best_seller"); ?></small></label>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12">
						<div class="row">
							<div class="col-md-6">
								<div class="form-group <?php echo form_error("product_name") ? "has-error" : "" ?>">
								  <label>Product Name</label>
								  <input id="product_name" name="product_name" value="<?php echo $product_name ?>" type="text" class="form-control" placeholder=""/>
								  <label><small><?php echo form_error("product_name"); ?></small></label>
								</div>
							</div>
							<div class="col-md-3">
								
								<!--<div class="form-group <?php echo form_error("price") ? "has-error" : "" ?>">
								  <label>Price</label>
								  <input id="price" name="price" value="<?php //echo $price ?>" type="text" class="form-control input_numbers" placeholder=""/>
								  <label><small><?php //echo form_error("price"); ?></small></label>
								</div>-->
							    <div class="form-group <?php echo form_error("product_code") ? "has-error" : "" ?>">
								  <label>Product Code</label>
								  <input id="product_code" name="product_code" value="<?php echo $product_code ?>" type="text" class="form-control" placeholder=""/>
								  <label><small><?php echo form_error("product_code"); ?></small></label>
								</div>
								
							</div>
							<div class="col-md-3">
								<div class="form-group <?php echo form_error("is_active") ? "has-error" : "" ?>">
									<label>Status</label>
									<select class="form-control selectpicker" id="status" name="status" data-live-search="true">
										<option value="N/A" <?php echo $status == 'N/A' ? 'selected' : '' ?>>N/A</option>
										<option value="Available" <?php echo $status == 'Available' ? 'selected' : '' ?>>Available</option>
									</select>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="form-group <?php echo form_error("description") ? "has-error" : "" ?>">
								   <label>Description</label>
								   <textarea id="description" name="description" class="form-control" rows="3" placeholder="Enter ..."><?php echo $description ?></textarea>

								   <label><small><?php echo form_error("description"); ?></small></label>
							   </div>
							</div>
							<div class="col-md-6">
								<div class="form-group <?php echo form_error("additional_description") ? "has-error" : "" ?>">
								   <label>Additional Description</label>
								   <textarea id="additional_description" name="additional_description" class="form-control" rows="3" placeholder="Enter ..."><?php echo $additional_description ?></textarea>

								   <label><small><?php echo form_error("additional_description"); ?></small></label>
							    </div>
							</div>
						</div>
					</div>
				</div>	
				<div class="row">
					<div class="col-md-6">
						<div class="form-group ddl_tag_multiple <?php echo form_error("tag_ids") ? "has-error" : "" ?>">
						  <label>Tags</label>
						  <select class="form-control selectpicker" id="ddl_tag_multiple" name="ddl_tag_multiple[]" multiple="ddl_tag_multiple"  data-live-search="true"> 
							  <?php foreach ($tags->result() as $value) { ?>

									<option  value="<?php echo $value->tag_id ?>" 

									 <?php if($tag_ids != null && in_array($value->tag_id, $tag_ids)){ echo "selected"; } ?>

										><?php echo $value->tag ?></option>

								<?php } ?> 
							</select>
						  <label><small><?php echo form_error("tag_ids"); ?></small></label>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group ddl_categories_multiple <?php echo form_error("category_ids") ? "has-error" : "" ?>">
						  <label>Categories</label>
						  <select class="form-control txtBx_mdl" id="ddl_categories_multiple" name="ddl_categories_multiple[]" multiple="ddl_categories_multiple"  data-live-search="true">
							  
							   <?php foreach ($categories->result() as $value) { ?>

									<option  value="<?php echo $value->category_id ?>" 

									 <?php if($category_ids != null && in_array($value->category_id, $category_ids)){ echo "selected"; } ?>

										><?php echo $value->category ?></option>

								<?php } ?>
							  
							</select>
						  <label><small><?php echo form_error("category_ids"); ?></small></label>
						</div>
					</div>
				</div>
				<div class="row" style="margin-top: 20px;">
					<div class="col-xs-12" style="overflow: auto;" id="productImageHtml">
						<div class="form-group <?php echo form_error("product_images") ? "has-error" : "" ?>" style="width: 150px;float: left;">
							<?php echo form_error("product_images") ? '<label><small>'.form_error("product_images").'</small></label>' : "" ?>
							<label class="file-control">
								<input type="file" data-control="image_uploader" size="60" >
								<div class="dv-logo">
									<div class="center" style="position: absolute;top: 0;left: 0;height: 100%;width: 100%;">
										<div class="dv-hover center" style="margin: 0px;">
											<i class="fa fa-image"></i>
										</div>
									</div>

									<div class="dv-result-logo" style="width: 150px;">

										<img class="result-logo" id="result" name="result" src="<?php echo base_url('dist/img/empty.png') ?>">
										<input hidden="hidden" type="text" runat="server"  id="image_path" name="image_path" value=" <?php echo $item_image; ?> " class="txtBx">
									</div>
								</div>
							</label> 
						</div>
						<div style="float: left;width: 25px;height: 20px;"></div>
						
						
						
						
						<?php $imageCount = 0; foreach ($productImages as $key => $value) { $imageCount++;  ?>
						<div class="imageView" id="deleteImage_<?php echo $imageCount ?>">
							<div id="<?php echo $imageCount ?>" data-control="imageRemove" class="_deleteBtn center">
								<i id="<?php echo $imageCount ?>" class="fa fa-trash"></i>
							</div>
							<div class="_defaultImage center">
								<label><input data-control="DefaultImage" class="DefaultImage" value="1" <?php echo $value['is_default_image'] == 1 ? 'checked' : '' ?> type="radio" id="product_images_isDefaultImage_<?php echo $imageCount ?>" name="product_images_isDefaultImage_<?php echo $imageCount ?>" >Default image</label>
							</div>
							<img src="<?php echo $value['id'] == 0 ? $value['image_path'] : base_url($value['image_path']) ?>">
							<input type="hidden" id="product_images_imagePath_<?php echo $imageCount ?>" name="product_images_imagePath_<?php echo $imageCount ?>" value="<?php echo $value['image_path'] ?>">
							<input type="hidden" id="product_images_imageId_<?php echo $imageCount ?>" name="product_images_imageId_<?php echo $imageCount ?>" value="<?php echo $value['id'] ?>">
						</div>
						<?php } ?>
					</div>
				</div>
					
            </div>
          </div>
        </div>
      </div>
      
      <!--tables-->
      
      <div class="row">
        <div class="col-xs-12">
          <div class="box box-solid" style="margin-bottom: 5px;">
			  <div class="box-header with-border">
              <h2 class="box-title"> Colors and Sizes </h2>
            </div>
            <div class="box-body">
              <table id="flavour_grid" class="table table-bordered table-striped">
                <thead>
                  <tr class="<?php echo $this->config->item('grid_header'); ?>">
                    <th>Image</th>
                    <th>Color</th>
                    <th>Size</th>
                    <th>Price</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
					<?php $item_count = 0; foreach ($flavours as $key => $value) { $item_count++;  ?>
                  <tr id="flavourRow_<?php echo $item_count ?>">
                    <td >
						<label class="file-control">
							<input id="<?php echo $item_count ?>" type="file" data-control="grid_imageUploader" size="60" >
							<div class="dv-logo" style="padding:4px;">
								<div class="center" style="position: absolute;top: 0;left: 0;height: 100%;width: 100%;">
									<div class="dv-hover center" style="margin: 0px;">
										<i class="fa fa-image"></i>
									</div>
								</div>

								<div class="dv-result-logo" style="width: 150px;">

									<img class="result-logo" id="grid_flavour_result_<?php echo $item_count ?>" name="grid_flavour_result_<?php echo $item_count ?>" src="<?php echo $value['is_new_image'] == 'true' ? $value['image_path'] : base_url($value['image_path']) ?>">
									<input type="hidden" id="grid_flavour_isNewImage_<?php echo $item_count ?>" name="grid_flavour_isNewImage_<?php echo $item_count ?>" value="<?php echo $value['is_new_image'] ?>">
									
									<input type="hidden" id="grid_flavour_image_<?php echo $item_count ?>" name="grid_flavour_image_<?php echo $item_count ?>" value="<?php echo $value['image_path'] ?>">
									
								</div>
							</div>

						<div class="form-group" style="width: 250px;">
							<div id="crop-image_gird_<?php echo $item_count ?>" class="box-body"></div>
                            <input hidden="hidden" type="text" runat="server"  id="image_path_gird_<?php echo $item_count ?>" name="image_path_grid_<?php echo $item_count ?>" value="<?php echo $value['image_path'] ?>" class="txtBx">
						</div>

						</label> 
					</td>
                    <td class="<?php echo form_error("grid_flavour_code_".$item_count) ? "has-error" : "" ?>">
						
						<select class="form-control selectpicker" id="grid_flavour_code_<?php echo $item_count ?>" name="grid_flavour_code_<?php echo $item_count ?>" data-live-search="true">
							<option value="0">N/A</option>
							<?php foreach ($colors->result() as $_value) { ?>
							<option value="<?php echo $_value->id ?>" <?php echo $_value->id == $value['flavour_code'] ? 'selected' : '' ?>><?php echo $_value->color ?></option>
							<?php } ?>
						</select>
						
						<label><small><?php echo form_error("grid_flavour_code_".$item_count) ? form_error("grid_flavour_code_".$item_count) : "" ?></small></label>
						
				  	</td>
                    <td class="<?php echo form_error("grid_flavour_name_".$item_count) ? "has-error" : "" ?>">
						
						<select class="form-control selectpicker" id="grid_flavour_name_<?php echo $item_count ?>" name="grid_flavour_name_<?php echo $item_count ?>" data-live-search="true">
							<option value="0">N/A</option>
							<?php foreach ($sizes->result() as $_value) { ?>
							<option value="<?php echo $_value->id ?>" <?php echo $_value->id == $value['flavour_name'] ? 'selected' : '' ?>><?php echo $_value->size ?></option>
							<?php } ?>
						</select>
						
						<label><small><?php echo form_error("grid_flavour_name_".$item_count) ? form_error("grid_flavour_name_".$item_count) : "" ?></small></label>
						
					</td>
                    <td>
						<div class="<?php echo form_error("grid_flavour_price_".$item_count) ? "has-error" : "" ?>">
							<input type="text" class="form-control text-right input_numbers" id="grid_flavour_price_<?php echo $item_count ?>" name="grid_flavour_price_<?php echo $item_count ?>" value="<?php echo $value['flavour_price'] ?>">
							<label><small><?php echo form_error("grid_flavour_price_".$item_count) ? form_error("grid_flavour_price_".$item_count) : "" ?></small></label>
						</div>
						
						<div class="<?php echo form_error("grid_gbp_price_".$item_count) ? "has-error" : "" ?>">
							<input type="text" class="form-control text-right input_numbers" id="grid_gbp_price_<?php echo $item_count ?>" name="grid_gbp_price_<?php echo $item_count ?>" value="<?php echo $value['gbp_price'] ?>">
							<label><small><?php echo form_error("grid_gbp_price_".$item_count) ? form_error("grid_gbp_price_".$item_count) : "" ?></small></label>
						</div>	
						
						<div class="<?php echo form_error("grid_eur_price_".$item_count) ? "has-error" : "" ?>">
							<input type="text" class="form-control text-right input_numbers" id="grid_eur_price_<?php echo $item_count ?>" name="grid_eur_price_<?php echo $item_count ?>" value="<?php echo $value['eur_price'] ?>">
							<label><small><?php echo form_error("grid_eur_price_".$item_count) ? form_error("grid_eur_price_".$item_count) : "" ?></small></label>
						</div>	
					</td>
                    <td class="col_5">
						<a id="<?php echo $item_count ?>" class="ibtnDel btn btn-md btn-danger float-right"><i id="<?php echo $item_count ?>" class="fa fa-trash"</a> 
						<input type="hidden" class="form-control" id="grid_flavour_id_<?php echo $item_count ?>" name="grid_flavour_id_<?php echo $item_count ?>" value="<?php echo $value['flavour_id'] ?>">
					</td>
                    
                  </tr>
					<?php } ?>
                </tbody>
				<tfoot>
					<tr>
						<td class="col_5" colspan="11" class="text-left">
							<a id="add_item" class="btn btn-info"><i class="fa fa-plus" style="margin-right: 8px;"></i>Add new</a> 
						</td>
					</tr>
				</tfoot>
              </table>
            </div>
          </div>
        </div>
      </div>
    </section>
	<input type="hidden" id="_id" name="_id" value="<?php echo $_id ?>">
	<input type="hidden" id="item_image" name="item_image" value="<?php echo $item_image ?>">
	<input type="hidden" id="is_new_image" name="is_new_image" value="<?php echo $is_new_image ?>">
	<input type="hidden" id="updated_datetime" name="updated_datetime" value="<?php echo $updated_datetime ?>">
  </form>
</div>

        <?php require_once(APPPATH . "views/admin/footer.php"); ?>

    </body>
</html>

<style>
	
	.imageView {
		float: left;
		position: relative;
		width: 150px;
		margin-left: 10px;
		margin-top: 15px;
	}
	
	.imageView ._deleteBtn {
		position: absolute;
		right: 5px;
		top: 5px;
		height: 30px;
		width: 30px;
		border-radius: 50%;
		background-color: rgba(0,0,0,0.41);
		cursor: pointer;
	}
	
	.imageView ._defaultImage {
		position: absolute;
		left: 5px;
		bottom: 5px;
		padding: 3px 10px;
		border-radius: 100px;
		background-color: rgba(0,0,0,0.41);
		cursor: pointer;
	}
	
	.imageView ._defaultImage label {
		color: white;
		margin: 0px;
	}
	
	.imageView ._deleteBtn i {
		color: white;
	}
	
	.imageView img {
		width: 100%;
		height: auto;
	}
	
	
	.ddl_tag_multiple .select2-selection__rendered {
		padding: 3px 13px 8px 13px !important;
		display: inline-flex !important;
		overflow-x: scroll !important;
	}

	.ddl_tag_multiple .select2-container--default .select2-selection--multiple .select2-selection__clear {
		margin-right: 10px !important;
	}

	.ddl_tag_multiple {
		height: 80px;
	}

	.ddl_categories_multiple .select2-selection__rendered {
		padding: 3px 13px 8px 13px !important;
		display: inline-flex !important;
		overflow-x: scroll !important;
	}

	.ddl_categories_multiple .select2-container--default .select2-selection--multiple .select2-selection__clear {
		margin-right: 10px !important;
	}

	.ddl_categories_multiple {
		height: 80px; 
	}
</style>


<script type="text/javascript">
	$(document).ready(function () {
		
		var item_count = '<?php echo $item_count ?>';
		
		$("#add_item").on("click", function () {
			
			item_count++;
					
			var newRow = $('<tr id="flavourRow_'+item_count+'">');
			var cols = "";

			
			cols += ' <td> ';
			cols += ' 	<label class="file-control"> ';
			cols += ' 		<input id="'+item_count+'" type="file" data-control="grid_imageUploader" size="60" > ';
			cols += ' 		<div class="dv-logo" style="padding:4px;"> ';
			cols += ' 			<div class="center" style="position: absolute;top: 0;left: 0;height: 100%;width: 100%;"> ';
			cols += ' 				<div class="dv-hover center" style="margin: 0px;"> ';
			cols += ' 					<i class="fa fa-image"></i> ';
			cols += ' 				</div> ';
			cols += ' 			</div> ';

			cols += ' 			<div class="dv-result-logo" style="width: 150px;"> ';
			cols += ' 				<img class="result-logo" id="grid_flavour_result_'+item_count+'" name="grid_flavour_result_'+item_count+'" src="<?php echo base_url('dist/img/empty.png') ?>"> ';
			cols += ' 				<input type="hidden" id="grid_flavour_isNewImage_'+item_count+'" name="grid_flavour_isNewImage_'+item_count+'" value="false"> ';
			cols += ' 				<input type="hidden" id="grid_flavour_image_'+item_count+'" name="grid_flavour_image_'+item_count+'" value="dist/img/empty.png"> ';

			cols += ' 			</div> ';
			cols += ' 		</div> ';

			cols += ' 	</label> '; 

		    cols += ' 		<div class="form-group" style="width: 250px;">';
			cols += ' 			<div id="crop-image_gird_'+item_count+'" class="box-body"></div>';
			cols += ' 		    <input hidden="hidden" type="text" runat="server"  id="image_path_gird_'+item_count+'" name="image_path_grid_'+item_count+'" value="" class="txtBx">';
			cols += ' 		</div>';

			cols += ' </td> ';
			cols += ' <td> ';
			cols += ' <select class="form-control selectpicker" id="grid_flavour_code_'+item_count+'" name="grid_flavour_code_'+item_count+'" data-live-search="true"> ';
			cols += ' <option value="0">N/A</option> ';
				<?php foreach ($colors->result() as $value) { ?>
			cols += ' <option value="<?php echo $value->id ?>"><?php echo $value->color ?></option> ';
				<?php } ?>
			cols += ' </select> ';
			cols += ' </td> ';
			cols += ' <td> ';
			cols += ' <select class="form-control selectpicker" id="grid_flavour_name_'+item_count+'" name="grid_flavour_name_'+item_count+'" data-live-search="true"> ';
			cols += ' <option value="0">N/A</option> ';
				<?php foreach ($sizes->result() as $value) { ?>
			cols += ' <option value="<?php echo $value->id ?>"><?php echo $value->size ?></option> ';
				<?php } ?>
			cols += ' </select> ';
			cols += ' </td> ';
			cols += ' <td> ';
			cols += ' 	<input type="text" class="form-control text-right input_numbers" id="grid_flavour_price_'+item_count+'" name="grid_flavour_price_'+item_count+'" value="" placeholder="LKR"> ';
			cols += ' 	<input type="text" class="form-control text-right input_numbers" style="margin-top:5px;" id="grid_gbp_price_'+item_count+'" name="grid_gbp_price_'+item_count+'" value="" placeholder="GBP"> ';
			cols += ' 	<input type="text" class="form-control text-right input_numbers" style="margin-top:5px;" id="grid_eur_price_'+item_count+'" name="grid_eur_price_'+item_count+'" value="" placeholder="EUR"> ';
			cols += ' </td> ';
			cols += ' <td class="col_5"> ';
			cols += ' 	<a id="'+item_count+'" class="ibtnDel btn btn-md btn-danger float-right"><i id="'+item_count+'" class="fa fa-trash"</a> '; 
			cols += ' 	<input type="hidden" class="form-control" id="grid_flavour_id_'+item_count+'" name="grid_flavour_id_'+item_count+'" value="0"> ';
			cols += ' </td> ';
			
																	
			cols += '</tr>' ;
			
			
			newRow.append(cols);
			$("#flavour_grid").append(newRow);
			
			$('.selectpicker').selectpicker('refresh');
			
		});

		$("#flavour_grid").on("click", ".ibtnDel", function (event) {
			
			var id = event.target.id;
			
			itemDelete_modal(id);
			
		});
		
		$(document).on('click', '[data-control=deleteGridRecoard]', function(e) {
			
			var selected_id = e.target.id;
			
			delete_item(selected_id);
			
		});
		
	
		
		$('#ddl_categories_multiple').select2({
		  placeholder: 'categories',
		  allowClear: true
		});

		$('#ddl_tag_multiple').select2({
		  placeholder: 'tags',
		  allowClear: true
		});
		


		$("[data-control=image_uploader]").change(function () {
			readURL(this);
		});

		$(document).on('change', '[data-control=grid_imageUploader]', function(e){
			
			var id = e.target.id;
			readURL_itemGrid(this,id);
			
		}); 

		$(document).on('click', '[data-control=imageRemove]', function(e){
			
			var id = e.target.id;
			$("#deleteImage_"+id).remove();
			
		});

		$(document).on('change', '[data-control=DefaultImage]', function(e){
			
			var data = e.target.id.split('_');
			var id = data[3];
			
			$(".DefaultImage").prop("checked", false);
			$("#product_images_isDefaultImage_"+id).prop("checked", true);
			
		});
		
	});
	
	function itemDelete_modal(selected_id){
		
		document.getElementById("htmlMessage").innerHTML = 'Are you sure you want to delete recoad?';
			
		document.getElementById("htmlDeleteBtn").innerHTML = '<a id="'+selected_id+'" data-control="deleteGridRecoard"  type="submit" class="btn btn-danger">Delete</a><a data-dismiss="modal"  type="button" class="btn btn-default">Close</a>';

		$("#messageModal").modal('show');return;
	}
	
	function delete_item(id){
		
		$("#flavourRow_"+id).remove();
		$("#messageModal").modal('hide');
		
	}
	
		
	function gridImageUpload(input,id) {

		if (input.files && input.files[0]) {

			var reader = new FileReader();

			reader.onload = function (e) {

				var selectedImage = e.target.result;

				$('#grid_flavour_result_'+id).attr('src', selectedImage);

				$('#grid_flavour_image_'+id).val(selectedImage);
				$('#grid_flavour_isNewImage_'+id).val('true');


			}
			reader.readAsDataURL(input.files[0]);
		}
	}
	
	var imageCount = '<?php echo $imageCount ?>';

	function readURL(input) {
		if (input.files && input.files[0]) {
		var reader = new FileReader();
			reader.onload = function (e) {

			$('#croppie_modal').on('shown.bs.modal', function() {

				document.getElementById('croppie_image').innerHTML = "<div class='form-group center'><img id='upload_image' src='#' /></div>";

				document.getElementById('croppie_footer').innerHTML = "<div class='form-group' style='min-height:0px;'><a id='use' class='image-select btn-primary'><i class='fa fa-crop' style='margin-right: 8px;'></i> CROP</a></div>";


				$('#upload_image').attr('src', e.target.result);
				var resize = new Croppie($('#upload_image')[0], {
					viewport: {width: 350, height: 450},
					boundary: {width: 400, height: 515},
					showZoomer: false,
					enableResize: false,
					enableOrientation: true
				});



				$('#use').fadeIn();


				$('#use').on('click', function () {
					resize.result('base64').then(function (dataImg) {
						var data = [{image: dataImg}, {name: 'myimgage.jpg'}];

						//ss$('#result').attr('src', dataImg);
						
						imageCount++;
						
						$('#productImageHtml').append('<div class="imageView" id="deleteImage_'+imageCount+'"> <div data-control="imageRemove" id="'+imageCount+'" class="_deleteBtn center"> <i id="'+imageCount+'" class="fa fa-trash"></i> </div> <div class="_defaultImage center"> <label><input data-control="DefaultImage" class="DefaultImage" value="1" type="radio" id="product_images_isDefaultImage_'+imageCount+'" name="product_images_isDefaultImage_'+imageCount+'" >Default image</label> </div> <img src="'+dataImg+'"> <input type="hidden" id="product_images_imagePath_'+imageCount+'" name="product_images_imagePath_'+imageCount+'" value="'+dataImg+'"> <input type="hidden" id="product_images_imageId_'+imageCount+'" name="product_images_imageId_'+imageCount+'" value="0"> </div>');

						$("#croppie_modal").modal("hide");

					});
				});


				});

				$("#croppie_modal").modal("show");

			}
			reader.readAsDataURL(input.files[0]);
	}
	}
	
    function readURL_itemGrid(input,id) {
		if (input.files && input.files[0]) {
		var reader = new FileReader();
			reader.onload = function (e) {

				$('#croppie_modal').on('shown.bs.modal', function() {

					document.getElementById('croppie_image').innerHTML = "<div class='form-group center'><img id='upload_image_grid' src='#' /></div>";

					document.getElementById('croppie_footer').innerHTML = "<div class='form-group' style='min-height:0px;'><a id='use_grid' class='image-select btn-primary'><i class='fa fa-crop' style='margin-right: 8px;'></i> CROP</a></div>";


					$('#upload_image_grid').attr('src', e.target.result);
					var resize = new Croppie($('#upload_image_grid')[0], {
						viewport: {width: 350, height: 450},
						boundary: {width: 400, height: 515},
						showZoomer: false,
						enableResize: false,
						enableOrientation: true
					});



					$('#use_grid').fadeIn();


					$('#use_grid').on('click', function () {
						resize.result('base64').then(function (dataImg) {
							var data = [{image: dataImg}, {name: 'myimgage.jpg'}];

							$('#grid_flavour_result_'+id).attr('src', dataImg);

							$('#grid_flavour_isNewImage_'+id).val('true');
							$('#grid_flavour_image_'+id).val(dataImg);


							$("#croppie_modal").modal("hide");

						});
					});


					});

			$("#croppie_modal").modal("show");

		}
			reader.readAsDataURL(input.files[0]);
	}
	}	

</script>







