<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title> Products </title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

        <!--image crop-->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
        <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Products List
                    <small>it all starts here</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

            <!-- Main content -->
            <form id="submitForm" name ="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Products/ProductsController/search') ?>" method="post" >
				
    <section class="content"> 

		
      
      <!--buttons-->
      <div class="row">
        <div class="col-12">
          <div class="box box-solid" style="margin-bottom: 5px;">
            <div class="box-body">
              <div class="row">
                <div class="col-md-4"></div>
                <div class="col-md-6 text-right"></div>
                <div class="col-md-2 text-right">
					<a href="<?php echo base_url('index.php/admin/Products/ProductsController/createnew') ?>"  class="btn btn-primary">Create new</a> 
				</div>
              </div>
            </div>
          </div>
        </div>
      </div>
		
		
	
		<div class="row">
			<div class="col-12">
				<div class="box box-solid" style="margin-bottom: 5px;">
					<div class="box-body">
						<div class="row">
							<div class="col-md-4">
								  <div class="form-group <?php echo form_error("product_code") ? "has-error" : "" ?>">
									  <label>Item Code</label>
									  <input id="product_code" name="product_code" value="<?php echo $product_code ?>" type="text" class="form-control" placeholder=""/>
									  <label><small><?php echo form_error("product_code"); ?></small></label>
								 </div>
							</div>
							<div class="col-md-4">
								 <div class="form-group <?php echo form_error("product_name") ? "has-error" : "" ?>">
									  <label>Item Name</label>
									  <input id="product_name" name="product_name" value="<?php echo $product_name ?>" type="text" class="form-control" placeholder=""/>
									  <label><small><?php echo form_error("product_name"); ?></small></label>
								 </div>
						    </div>
							<div class="col-md-1">	
								<div class="form-group" style="min-height: 0px;padding-left: 10px;">
									<label><input type="checkbox" id="is_new_arrival" name="is_new_arrival" value="1"<?php echo $is_new_arrival== 1 ? "checked" : "" ?> > Is New Arrival</label>

								  <label><small><?php echo form_error("is_new_arrival"); ?></small></label>
								</div>
							</div>
							<div class="col-md-1">
								<div class="form-group" style="min-height: 0px;padding-left: 10px;">
									<label><input type="checkbox" id="is_get_free" name="is_get_free" value="1"<?php echo $is_get_free== 1 ? "checked" : "" ?> > Is Buy 1 Get 1 Free</label>

								  <label><small><?php echo form_error("is_get_free"); ?></small></label>
								</div>
							</div>
							<div class="col-md-1">
								<div class="form-group" style="min-height: 0px;padding-left: 10px;">
									<label><input type="checkbox" id="is_best_seller" name="is_best_seller" value="1"<?php echo $is_best_seller== 1 ? "checked" : "" ?> > Is Best Seller</label>

								  <label><small><?php echo form_error("is_best_seller"); ?></small></label>
								</div>
							</div>
							<div class="col-md-1 text-right">
							  <button type="submit" class="btn btn-primary" style="margin-top: 25px;" href="<?php echo base_url('index.php/admin/Products/ProductsController/search') ?>">Search</button>
							</div>
					 </div>
						
				</div>
			 </div>
		  </div>
		</div>
	</form>
      <!--//buttons--> 
      
      <!--table-->
      
      <div class="box box-info">
        <div class="box-body"> 
          
          <!--table format-->
          <table id="" class="table table-bordered table-striped">
            <thead>
              <tr class="<?php echo $this->config->item('grid_header'); ?>">
				<th class="col_10">Product ID</th>
                <th class="col_10">Code</th>
                <th class="col_15">Name</th>
                <th class="col_10">Price</th>
                <th class="col_10">Categories</th>
                <th class="col_10">Status</th>
                <th class="col_20">Active</th>
                <th class="col_15"></th>
              </tr>
            </thead>
            <tbody>
			   <?php foreach ($dataList->result() as $row) { ?>
			   <?php 

					$id = $row->product_id; 
					$encryption_id = urlencode(base64_encode($id));
					$key = urlencode(base64_encode('UOM'));

				?>
              <tr>
				<td><?php echo $row->product_id ?></td>
                <td><?php echo $row->product_code ?></td>
                <td><?php echo $row->product_name ?></td>
                <td class="text-right"><?php echo $row->price ?></td>
                <td><?php echo $row->categories ?></td>
                <td><?php echo $row->status ?></td>
                <td>
					<?php echo $row->is_active == 1 ? '<small class="label bg-green">Active</small>' : '<small class="label bg-red">Inactive</small>' ; ?>
					<?php echo $row->is_new_arrival == 1 ? '<small class="label bg-green">Is arrival</small>' : '' ; ?>
					<?php echo $row->is_best_seller == 1 ? '<small class="label bg-blue">Is Best Seller</small>' : '' ; ?>
					<?php echo $row->is_get_free == 1 ? '<small class="label bg-yellow">Is Buy 1 Get 1 Free</small>' : '' ; ?>
				  </td>
				 
                
                <td>
					<a data-control="edit_click" id="<?php echo $encryption_id ?>" href="#" class=" btn btn-primary float-right" style="margin-right: 3px;"><i id="<?php echo $encryption_id ?>" class="fa fa-edit"></i></a> 
					<a data-control="delete_click" id="<?php echo $encryption_id ?>" href="#" class=" btn btn-danger float-right" style="margin-right: 3px;"><i id="<?php echo $encryption_id ?>" class="fa fa-trash"></i></a> 
				</td>
                </tr>
				<?php } ?>
            </tbody>
          </table>
			 <?php require_once(APPPATH . "views/admin/pagination.php"); ?>
        </div>
        <!-- /.box-body --> 
      </div>
      
      <!--//table--> 
	<input type="hidden" id="selected_id" name="selected_id">
	<input type="hidden" id="formSubmit" name="formSubmit" value="submitForm">
	<input type="hidden" id="form" name="form" value="Products">
      
    </section>
				
	
</form>			
  
        </div>

        <!-- ./wrapper -->


        <?php require_once(APPPATH . "views/admin/footer.php"); ?>
       


    </body>
</html>








