<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Feedback Report</strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>
		<!-- Main content -->
		<section class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
						<div class="box-header with-border">
							<h3 class="box-title font-weight-bold"></h3>
						</div>

						<div class="box-body">
							<div class="panel-group" id="accordion">

								<div class="d-block mb-3">
									<div class="row" id="filters">
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="payment_type">Select Patient</label>
												<select name="patient_id" placeholder="Enter Patient" id="patient_id"></select>
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_from">Date From</label>
												<input type="date" class="form-control" name="date_from" id="date_from" placeholder="Date From">
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_to">Date To</label>
												<input type="date" class="form-control" name="date_to" id="date_to" placeholder="Date To">
											</div>
										</div>
									</div>
								</div>

								<table id="feedback_list" class="table table-light table-bordered table-striped"></table>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div><!-- /.content-wrapper -->
	<!-- ./wrapper -->
	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
	$(document).ready(function() {
		// Initialize the DataTable
		var dataTable = $('#feedback_list').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Feedback Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Feedback Report`,
				customize: function(win) {
					$(win.document.body).prepend(`<?php echo print_header($this); ?>`);
						var filterData = '<div class="filter-data d-flex ml-3">';

						$('#filters .form-group').each(function() {
							var label = $(this).find('label').text().trim();
							var value;
							var inputElement = $(this).find('select, input');

							if (inputElement.is('select')) {
								value = inputElement.find('option:selected').text();
							} else if (inputElement.is('input[type="date"]')) {
								value = inputElement.val();
							}


							filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
						});

						filterData += '</div>';

						$(win.document.body).find('h1').after(filterData);

						$(win.document.body).find('h1').css({
							'font-size': '20px',
							'text-align': 'center',
							"font-weight": "700"
						});

						$(win.document.body).find('table').css({
							'margin-left': '20px',
							'margin-right': '10px',
							"width": "95%",
							"font-size": "12px",
							'table-layout': 'auto'
						});
						$(win.document.body).find('table th').css({
							"font-size": "12px",
						});
						
				}

			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/feedbackList'); ?>',
				'type': 'GET',
				'data': function(d) {
					d.patient_id = $('select[name=patient_id]').val();
					d.date_from = $('#date_from').val();
					d.date_to = $('#date_to').val();
				}
			},
			'columns': [
				{
					'data': null,
					'title': 'Date',
					'render': function(data, type, row, meta) {
						return row['curr_date']+ ' ' +row['curr_time']
					}
				},
				{
					'data': 'patient_name',
					'title': 'Patient Name'
				},
				{
					'data': 'appointment',
					'title': 'Appointment'
				},
				{
					'data': 'reception',
					'title': 'Reception'
				},
				{
					'data': 'waiting',
					'title': 'Waiting'
				},
				{
					'data': 'nurse',
					'title': 'Nurse’s Recep.'
				},
				{
					'data': 'laser',
					'title': 'Laser'
				},
				{
					'data': 'session',
					'title': 'Session Dur.'
				},
				{
					'data': 'treatment',
					'title': 'Treatment'
				},
				{
					'data': 'previous',
					'title': 'Last Session'
				},
			],
			'searching': false,
			'serverSide': true,
			'pageLength': -1,
			'pagingType': 'full_numbers'
		});

		$('#patient_id, #date_from, #date_to').on('keyup change', function() {
			dataTable.ajax.reload();

			// var sumColumn = dataTable.column(1).data().reduce(function(a, b) {
			// 	return a + b;
			// }, 0);

			// dataTable.row.add(['Total: ', sumColumn]).draw();
		});
	});

	var patientSelect = new TomSelect("#patient_id", {
      valueField: 'id',
      labelField: 'name',
      searchField: 'name',
      // Set the "load" property to define the function to fetch data dynamically
      load: function(query, callback) {
        var apiUrl = "<?php echo site_url('admin/Patients/PatientsController/get_patient?'); ?>name_startsWith=" + encodeURIComponent(query);

        fetch(apiUrl)
          .then(response => response.json())
          .then(data => {
            callback(data);
          })
          .catch(() => {
            callback();
          });
      },
      render: {
        option: function(item, escape) {
          return '<div>' +
            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        },
        item: function(item, escape) {
          return '<div>' +
            '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        }
      },
    });
</script>