<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>Logs Report</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title font-weight-bold">Available Logs</h3>
                        </div>

                        <div class="box-body">
                            <div class="panel-group" id="accordion">

                                <div class="d-block mb-3">
                                    <div class="row" id="filters">
                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="appoinment_status">Logs Type</label>
                                                <select class="form-control" name="type" id="type">
                                                    <option value="All">All</option>
                                                    <option value="Appointments">Appointments</option>
                                                    <option value="Appointment Block">Appointment Block</option>
                                                    <option value="Appointment Laser">Appointment Laser</option>
                                                    <option value="Appointment Laser Block">Appointment Laser Block</option>
                                                    <option value="Payments">Payments</option>
                                                    <option value="Patients">Patients</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="appoinment_status">Employee</label>
                                                <select class="form-control" name="user_id" id="user_id">
                                                    <option value="All">All</option>
                                                    <?php foreach ($sales_persons as $index => $sales_person) : ?>
                                                        <option value="<?= $sales_person['user_Id']; ?>"><?= $sales_person['full_name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="appoinment_status">Action</label>
                                                <select class="form-control" name="action" id="action">
                                                    <option value="All">All</option>
                                                    <option value="Create">Create</option>
                                                    <option value="Update">Update</option>
                                                    <option value="Delete">Delete</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="date_from">Date From</label>
                                                <input type="date" class="form-control" name="date_from" id="date_from" value="<?php echo date('Y-m-d') ?>" placeholder="Date From">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="date_to">Date To</label>
                                                <input type="date" class="form-control" name="date_to" id="date_to" value="<?php echo date('Y-m-d') ?>" placeholder="Date To">
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <table id="price_list" class="table table-light table-bordered table-striped"></table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div><!-- /.content-wrapper -->
    <!-- ./wrapper -->
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize the DataTable
        var dataTable = $('#price_list').DataTable({
            dom: 'lBfrtip',
            buttons: [{
                    extend: 'excel',
                    title: `Logs Report`
                },
                {
                    extend: 'print',
                    autoPrint: true,
                    title: `Logs Report`,
                    customize: function(win) {
                        $(win.document.body).prepend(`<?php echo print_header($this); ?>`);
                        var filterData = '<div class="filter-data d-flex ml-3">';

                        $('#filters .form-group').each(function() {
                            var label = $(this).find('label').text().trim();
                            var value;
                            var inputElement = $(this).find('select, input');

                            if (inputElement.is('select')) {
                                value = inputElement.find('option:selected').text();
                            } else if (inputElement.is('input[type="date"]')) {
                                value = inputElement.val();
                            }


                            filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
                        });

                        filterData += '</div>';

                        $(win.document.body).find('h1').after(filterData);

                        $(win.document.body).find('h1').css({
                            'font-size': '20px',
                            'text-align': 'center',
                            "font-weight": "700"
                        });

                        $(win.document.body).find('table').css({
                            'margin-left': '20px',
                            'margin-right': '10px',
                            "width": "95%",
                            "font-size": "12px",
                            'table-layout': 'auto'
                        });
                        $(win.document.body).find('table th').css({
                            "font-size": "12px",
                        });
                    }

                },

            ],
            'ajax': {
                'url': '<?= site_url('admin/Reports/ReportsController/logsList'); ?>',
                'type': 'GET',
                'data': function(d) {
                    d.action = $('#action').val();
                    d.user_id = $('#user_id').val();
                    d.type = $('#type').val();
                    d.date_from = $('#date_from').val();
                    d.date_to = $('#date_to').val();
                }
            },
            'columns': [{
                    'data': null,
                    'title': '#',
                    'orderable': false,
                    'searchable': false,
                    'render': function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                }, {
                    'data': 'type',
                    'title': 'Logs Type'
                },
                {
                    'data': 'action',
                    'title': 'Action'
                },
                {
                    'data': null,
                    'title': 'Changes',
                    'render': function(data, type, row, meta) {
                        // Decode JSON data for old_data and new_data
                        let oldData = JSON.parse(row.old_data || '{}');
                        let newData = JSON.parse(row.new_data || '{}');

                        let changes = [];
                        // Loop through newData to find changes
                        for (let key in newData) {
                            let oldValue = oldData[key] || null;
                            let newValue = newData[key];

                            if (newValue !== oldValue) {
                                oldValue = oldValue == null ? '':oldValue ;
                                newValue = newValue == null ? '':newValue ;
                                    changes.push(`<div><i>-</i> <strong>${key}:</strong> <del>${oldValue}</del> <span>${newValue}</span></span>`);
                            }
                        }

                        

                        // Return the changes if any, or a 'No changes' message
                        if (changes.length > 0) {
                            return changes.join(','); // Combine all change HTML into a single string
                        } else {
                            return 'No changes';
                        }
                    }
                },
                {
                    'data': 'created_date',
                    'title': 'Date',
                },
                {
                    'data': 'full_name',
                    'title': 'User'
                },
                {
                    'data': null,
                    'title': 'Action',
                    'render': function(data, type, row, meta) {
                        return '<a href="view_log/'+row.log_id+'" class="btn btn-light btn-sm">View Details</a>'
                    }
                },
            ],
            'searching': false,
            'serverSide': true,
            'pageLength': -1,
            aLengthMenu: [
                [25, 50, 100, 200, -1],
                [25, 50, 100, 200, "All"]
            ],
            'pagingType': 'full_numbers'
        });

        $('#action, #user_id, #date_to, #date_from, #type').on('keyup change', function() {
            dataTable.ajax.reload();
        });
    });
</script>
<script>
    var settings = {};
    new TomSelect('#appoinment_status', settings);
</script>