<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Bank
                    <small>Create/Edit Bank</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="box margin-bottom-5px box-warning">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-10"></div>
                                    <div class="col-md-2">
                                        <a href="<?php echo base_url('index.php/admin/Setting/Bank/BankController/CreateNew') ?>" class="btn btn-block btn-social <?php echo $this->config->item('add_new'); ?>">
                                            <i class="fa fa-plus"></i> New bank
                                        </a>
                                    </div>
                                </div>	
                            </div><!-- /.box-body -->
                        </div>
                        <div class="box box-info">
								<div class="box-body">
									<table id="bank_grid" class="table table-bordered table-striped">
										<thead>
											<tr class="<?php echo $this->config->item('grid_header'); ?>">
												<th class="hide">#</th>
												<th>Bank name</th>
												<th>Note</th>
												<th class="col_10"></th>
											</tr>
										</thead>
										<tbody>
											   <?php foreach ($List->result() as $row) { ?>
												<tr>
													<td class="hide"><?php echo $row->bank_id; ?></td>
													<td><?php echo $row->bank_name; ?></td>
													<td><?php echo $row->note; ?></td>
													<td class="col_10">

														<a class="btn btn-social-icon btn-instagram btn-grid" 
														   data-toggle="tooltip" data-placement="bottom" 
														   href="<?php echo site_url('admin/Setting/Bank/BankController/Edit/') . $row->bank_id; ?>"
														   title="Edit"><i class="fa  fa-edit"></i></a>
													</td>

												</tr>
												<?php } ?>
										</tbody>

									</table>
								</div><!-- /.box-body -->
							</div>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </section>

        </div><!-- /.content-wrapper -->
        <!-- ./wrapper -->
        
        <script>

			$( document ).ready(function() {
				$('#bank_grid').DataTable({
					"searching": true,
					"paging": true
				});
			});

		</script>
        
        <?php require_once(APPPATH . "views/admin/footer.php"); ?>
        

    </body>
</html>


