<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?= $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->
    <?php if (validation_errors()) { ?>
        <div class="callout <?= $this->config->item('msg_error'); ?> error-msg">
            <div>
                <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
            </div>
        </div>
    <?php } ?>

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Company Profile <small>- <?= ($company_id_val > 0 ? "Edit" : "Create New") ?> Company Profile</small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->

        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary card-tabs">
                        <div class="card-header p-0 pt-1">
                            <ul class="nav nav-tabs company_configuration_tab_list" role="tablist">
                            <?php if(check_right('company_details',$this)) { ?>
                                <li class="nav-item">
                                    <a class="nav-link font-weight-bold" data-toggle="pill" href="#company_details" role="tab" aria-controls="company_details" aria-selected="false">Company Details</a>
                                </li>
                            <?php } if(check_right('sms_config',$this)) {?>
                                <li class="nav-item">
                                    <a class="nav-link font-weight-bold" data-toggle="pill" href="#sms_config" role="tab" aria-controls="sms_config" aria-selected="false">SMS Configurations</a>
                                </li>
                                <?php } if(check_right('skipcash_config',$this)) { ?>
                                <li class="nav-item">
                                    <a class="nav-link font-weight-bold" data-toggle="pill" href="#skipcash_config" role="tab" aria-controls="announcements" aria-selected="false">Skipcash Configuration</a>
                                </li>
                                <?php } if(check_right('skipcash_config',$this)) { ?>
                                    <li class="nav-item">
                                    <a class="nav-link font-weight-bold" data-toggle="pill" href="#whatsapp_config" role="tab" aria-controls="announcements" aria-selected="false">Whatsapp Configuration</a>
                                </li>

                            <?php } if(check_right('announcement',$this)) { ?>
                                <li class="nav-item">
                                    <a class="nav-link font-weight-bold" data-toggle="pill" href="#announcements" role="tab" aria-controls="announcements" aria-selected="false">Announcements</a>
                                </li>
                            <?php } ?>
                            </ul>
                        </div>
                        <div class="card-body bg-white">
                            <div class="tab-content">
                                <?php require_once(APPPATH . "views/admin/Setting/Company/Tabs/CompanyDetailsTab.php");
                                     require_once(APPPATH . "views/admin/Setting/Company/Tabs/SMSConfigTab.php");
                                     require_once(APPPATH . "views/admin/Setting/Company/Tabs/Skipcash.php");
                                     require_once(APPPATH . "views/admin/Setting/Company/Tabs/Whatsapp.php");
                                    require_once(APPPATH . "views/admin/Setting/Company/Tabs/AnnouncementsTab.php"); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>

</body>

</html>

<script>
    // Store selected tab in localstorage
    $('.company_configuration_tab_list').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('company_configuration_tab', tabIndex);
    });

    // Load tab index from localstorage
    $(document).ready(function() {
        let selectedTab = localStorage.getItem('company_configuration_tab') != null ? localStorage.getItem('company_configuration_tab') : 0;
        $(`.company_configuration_tab_list a:eq(${selectedTab})`).tab('show');
    });
</script>