<div class="tab-pane fade" id="notification_templates_tab" role="tabpanel" aria-labelledby="sms-config-tab">

    <div class="row">
        <div class="col-md-4">
            <h4>Create New Template</h4>

            <form action="<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/createNewNotificationTemplate') ?>" method="post">

                <input type="hidden" name="id" id="notification_template_id" value="<?= old($this,'id'); ?>">

                <div class="form-group">
                    <label for="">Notification Template Type</label>
                    <select name="type" id="notifications_type" class="form-control">
                        <option value="">Choose Notification Type</option>
                        <option <?= (old($this, 'type') == 'sms') || (old($this, 'type') == '') ? 'selected' : null; ?> value="sms">SMS</option>
                        <option <?= old($this, 'type') == 'email' ? 'selected' : null; ?> value="email">Email</option>
                    </select>
                    <?= _e($this, 'type'); ?>
                </div>

                <div class="form-group">
                    <label for="event_type">Event</label>
                    <select name="event_type" id="event_type" class="form-control">
                        <option value="">Choose Event Type</option>
                        <?php foreach ($event_types as $event_type) : ?>
                            <option <?= old($this, 'event_type') == $event_type['event'] ? 'selected' : null; ?> value="<?= $event_type['event']; ?>"><?= $event_type['event_name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?= _e($this, 'event_type'); ?>

                    <p id="event_type_placeholders">
                        
                    </p>
                </div>

                <div class="form-group">
                    <label for="language">Language</label>
                    <select name="language" id="language" class="form-control">
                        <option value="">Choose Language</option>
                        <option <?= old($this, 'language') == 'ar' ? 'selected' : ''; ?> value="ar">Arabic</option>
                        <option <?= old($this, 'language') == 'en' ? 'selected' : ''; ?> value="en">English</option>
                    </select>
                    <?= _e($this, 'language'); ?>
                </div>

                <div class="form-group">
                    <label for="">Template Name</label>
                    <input type="text" name="name" id="name" class="form-control" placeholder="Enter template name.." value="<?= old($this, 'name'); ?>">
                    <?= _e($this, 'name'); ?>
                </div>

                <div class="form-group">
                    <label for="">Notification Template</label>
                    <textarea name="template" id="template" class="form-control mt-2" rows="10" placeholder="Create template.."><?= old($this, 'template'); ?></textarea>
                    <?= _e($this, 'template'); ?>
                </div>

                <div class="d-flex flex-wrap justify-content-end mt-2">
                    <button type="submit" class="btn btn-sm btn-light mr-1"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                    <button type="reset" class="btn btn-sm btn-light"><i class="fa fa-refresh" aria-hidden="true"></i> Reset</button>
                </div>
            </form>

        </div>

        <div class="col-md-8">
            <h4>Notification Templates</h4>

            <table class="table table-bordered">
                <thead>
                    <th>Template ID</th>
                    <th>Notification Type</th>
                    <th>Event Type</th>
                    <th>Name</th>
                    <th class="text-center">Template</th>
                    <th>Activated Template</th>
                    <th class="text-center">Actions</th>
                </thead>
                <tbody id="notification_template_table_body"></tbody>
            </table>
        </div>

    </div>

</div>

<script>
    function loadNotificationTemplatesToTable() {
        // Load Existing templates here using -> 'notification_type'
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/LoadNotificationTemplates'); ?>',
            method: 'POST',
            dataType: 'json',
            data: {
                notification_type: $('#notifications_type').val()
            },
            success: function(response) {


                let _row = '';

                $.each(response, function(index, row) {
                    let data = {};

                    _row += `<tr>
                        <td>${row.id}</td>
                        <td>${row.type.toUpperCase()}</td>
                        <td>${row.event_name} (${row.language.toUpperCase()})</td>
                        <td>${row.name}</td>
                        <td>${row.template}</td>
                        <td class="text-center"><input type="checkbox" onclick="changeActiveTemplate('${row.e_id}', '${row.event}', '${row.language}',this)" ${parseInt(row.is_default) ? 'checked' : ''} /></td>
                        <td class='text-center'>
                            <button class='btn btn-sm btn-light' data-tamplate='${JSON.stringify(row)}' onclick="editNotificationTemplate(this)">
                                <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                            </button>
                            <button class='btn btn-sm btn-light' onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/deleteNotificationTemplate/') ?>${row.e_id}')">
                                <i class="fa fa-trash" aria-hidden="true"></i>
                            </button>
                        </td>
                    </tr>`;
                    //console.log(row);
                });

                $('#notification_template_table_body').html(_row);
            },
            error: function(xhr, status, error) {

                console.error('Error:', error);
            }
        });
    }

    function editNotificationTemplate(e) {
        let template = JSON.parse($(e).attr('data-tamplate'));
        $('#notification_template_id').val(template.e_id);
        $('#notifications_type').val(template.type);
        $('#name').val(template.name);
        $('#template').val(template.template);
        $('#event_type').val(template.event_type);
        $('#language').val(template.language);
    }

    function changeActiveTemplate(template_id, template_event_type, laguange, element) {

        $(element).on('change', function() {
            if ($(this).prop('checked')) {
                return false;
            }
        });

        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/ChangeActiveTemplate'); ?>',
            method: 'POST',
            dataType: 'json',
            data: {
                template_id: template_id,
                template_event_type: template_event_type,
                template_language: laguange
            },
            success: function(response) {
                loadNotificationTemplatesToTable();
                successNotification('Template Changed!');
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
            }
        });
    }

    $(function() {

        $('#notifications_type').on('change', function() {
            if ('0' != $(this).val()) {
                loadNotificationTemplatesToTable();
            }
        });

        loadNotificationTemplatesToTable();
    });

    $('#event_type').on('change', function(){
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/GetPlaceHolders'); ?>',
            method: 'POST',
            dataType: 'json',
            data: {
                event: $(this).val()
            },
            success: function(response) {
                $('#event_type_placeholders').html('');
                let placeholders = JSON.parse(response.placeholders);
                $('#event_type_placeholders').append('<label style="margin-top:10px;font-weight:bold;color:red;display:block;">Use following placeholders when create a new template.</label>');
                $.each(placeholders, function(index, placeholder){
                    $('#event_type_placeholders').append(`<span style="margin-top:10px;font-weight:bold;color:#084a6a;display:block;"> - ${placeholder.description} <pre style="">${placeholder.placeholder}</pre></span>`);
                });
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
            }
        });
    });
</script>