            <div class="col-md-6 form-container p-2">
            <form id="DiscountRange" method="post" enctype="multipart/form-data">
            <input type="hidden" name="discount_id" id="discount_id">
            <div class="col-md-12 mt-4">
            
            <div class="form-group">
                <label for="">Select Employee Type</label>
               <select name="employee_type" id="employee_type" class="form-control" required>
                <option value="">--Select Employee Type--</option>
                <option value="76">Doctor</option>
                <option value="80">Receptionist</option>
               </select>
            </div>  
            
            <div class="form-group">
                <label for="">Select User <div class="spinner spinner-border text-primary" style="
    font-size: 6px;
    width: 15px;
    height: 15px; display:none " id="user-loader"></div> </label>
               <select name="user_id" id="user_id" class="form-control" required>
                <option value="">--Select User--</option>
              
               </select>

            </div>  
            
            <div class="form-group">
                <label for="">Discount</label>
                <input type="number" name="discount" id="discount_max" class="form-control" placeholder="Discount  in percentage (%)" />
                <p><i class="fa fa-info-circle mr-1"></i> Please enter the maximum discount percentage that a specific user is authorized to provide.</p>


            </div>  
                
            </div>
            <div class="col-md-12 mt-4">
            <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle"></i> Save</button>
                    </div>
            </form>

            </div>

            <hr>
            <div class="row">
        
            <div class="col-md-12">
            <table class="table-striped" id="discount_ranges">
                    <tr>
                        <th>NO</th>
                        <th>Name</th>
                        <th>Discount</th>
                    </tr>
            </table>
            </div>
           
            
            </div>
            <script type="text/javascript">

var dataTable = undefined;
$(document).ready(function() {
    // Initialize the DataTable
    dataTable = $('#discount_ranges').DataTable({
        dom: 'lBfrtip',
        buttons: [{
            extend: 'excel',
            title: `Discount Categories`
        }, {
            extend: 'print',
            autoPrint: true,
            title: `Daily Collection Report`,
            exportOptions: {
                columns: ':not(:last-child)'
            },
            customize: function(win) {
                $(win.document.body).prepend(`<?php print_header($this); ?>`);
            }
        }, ],
        'ajax': {
            'url': '<?= site_url('admin/Setting/Configurations/ConfigurationsController/get_discount_range'); ?>',
            'type': 'GET',
            'data': function(d) {
                d.receptionist = $('#receptionist').val();
                d.fromdate = $('#fromdate').val();
                d.todate = $('#todate').val();
            }
        },
        'columns': [{
                'data': 'id',
                'title': ' No.'
            },
            {
                'data': 'full_name',
                'title': 'User'
            },
            {
                'data': 'max_value',
                'title': 'Discount Limit(%)'
            },
            {
                'data': '',
                'title': 'Action',
                'render': function(data, type, row) {
                 $html = '<a  data-id="'+row.id+'" class="btn btn-light edit-discount"><i class="fa fa-pencil"></i></a><a  data-id="'+row.id+'" class="btn btn-light delete-discount"><i class="fa fa-trash"></i></a>'
                return $html;
            }
            },
            
        ],
        'searching': false,
        'serverSide': true,
        'pageLength': 10,
        aLengthMenu: [
            [25, 50, 100, 200, -1],
            [25, 50, 100, 200, "All"]
        ],
        'pagingType': 'full_numbers',
        footer:true,
        autoWidth: false

    });



    $('#receptionist, #fromdate,#todate ').on('change', function() {
        dataTable.ajax.reload();
    });
});



</script>

<script>
$(document).ready(function() {
$('#DiscountRange').on('submit', function(e) {
    e.preventDefault(); // Prevent the default form submission
    
    let formData = new FormData(this);

    $.ajax({
        url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/SaveDiscountRange'); ?>',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function(response) {
            // Handle the success response here
            let res = JSON.parse(response);
            if(res.status =='success'){
              
                successNotification(res.message);
            }else{
                errorNotification(res.message)
            }
           
         
          dataTable.ajax.reload();
        },
        error: function(xhr, status, error) {
            // Handle the error response here
            alert('An error occurred while saving the discount settings.');
        }
    });
});
});

$(document).ready(function() {
    $('#employee_type').on('change', function() {
        var employeeType = $(this).val();
        $('#user-loader').show();
        if (employeeType) {
            $.ajax({
                url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/getUsersByType'); ?>',
                type: 'POST',
                data: { type: employeeType },
                dataType: 'json',
                success: function(response) {
                    $('#user_id').empty();
                    $('#user_id').append('<option value="">--Select User--</option>');
                    $.each(response, function(key, value) {
                        $('#user_id').append('<option value="' + value.user_Id + '">' + value.full_name + '</option>');
                    });
                    $('#user-loader').hide();
                },
                error: function(xhr, status, error) {
                    alert('An error occurred while fetching users.');
                    $('#user-loader').hide();
                }
            });
        } else {
            $('#user_id').empty();
            $('#user_id').append('<option value="">--Select User--</option>');
            $('#user-loader').hide();
        }
    });
});


$('#discount_ranges').on('click', '.edit-discount', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
      
        
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/getDiscountById'); ?>',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                $('#discount_id').val(response.id);
                $('#employee_type').val(response.employee_type).trigger('change');
                setTimeout(function() {
                    $('#user_id').val(response.user_id);
                }, 500);
                $('#discount_max').val(parseFloat(response.max_value));
                if( $('.form-container').hasClass('shake')){
                    $('.form-container').removeClass('shake').outerWidth();
                   
                }
                    $('.form-container').addClass('shake');    
                
               
            },
            error: function(xhr, status, error) {
                alert('An error occurred while fetching the discount data.');
            }
        });
    });

    // Delete discount
    $('#discount_ranges').on('click', '.delete-discount', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        
        Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, delete it!"
		}).then((result) => {
			if (result.isConfirmed) {
				$.ajax({
                url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/deleteDiscountRange'); ?>',
                type: 'POST',
                data: { id: id },
                success: function(response) {
                    let res = JSON.parse(response);
                    successNotification(res.message);
                    dataTable.ajax.reload();
                },
                error: function(xhr, status, error) {
                    alert('An error occurred while deleting the discount.');
                }
            });
			}
		});

       
    });


</script>  


  