<div class="row">
        <div class="col-md-11 d-flex justify-content-end "  >
        <div class="spinner spinner-border spinner-border-sm loader-remind " style="display: none;"></div>
        </div>
       
        <div class="col-md-12">
            <h4>Notification Reminder</h4>

            <form action="<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/createNotificationReminder') ?>" method="post" id="notification_reminder_form">

                <input type="hidden" name="id" id="notification_template_id" value="<?= old($this,'id'); ?>">

                <div class="form-group">
                    <label for="">Notification Channel</label>
                    <select name="type" id="notifications_type" class="form-control">
                        <option value="">Choose Notification Type</option>
                        <option value="sms">SMS</option>
                        <?php if(is_whatsapp($this) ==1){ ?>
                            <option value="whatsapp">Whatsapp</option>
                            <?php }else{?>
                                <option disabled>Whatsapp (Whatsapp not Available Please Setup Whatsapp)</option>
                           <?php } ?>
                        
                    </select>
                    
                </div>

                <div class="form-group">
                    <label for="event_type">Event</label>
                    <select name="event_type" id="event_type_reminder" class="form-control">
                        <option value="">Choose Event Type</option>
                        <option  value="upcoming_appointment">Up Coming Appointment</option>
                        <option  value="birthday">Birthday Wishes</option>
                    </select>
                   
                        
                    </p>
                </div>
                <div class="form-group">
                    <label for="">Reminder Time </label>
                        <p><i class="fa fa-info-circle mr-1"></i><span class="text-muted">How much time before the appointment should the reminder be sent? </span></p>
                    <select name="time" id="time" class="form-control">
                        <option value="">Choose Time</option>
                        <option  value="12">12 Hours (For Same Day)</option>
                        <option  value="24">24 Hours</option>
                        <option  value="36">36 Hours</option>
                        <option  value="48">48 Hours</option>
                    </select>
                   
                </div>

             
                <div class="d-flex flex-wrap justify-content-end mt-2">
                    <button type="button" class="btn btn-sm btn-light mr-1" id="save_reminder"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                    <button type="reset" class="btn btn-sm btn-light"><i class="fa fa-refresh" aria-hidden="true"></i> Reset</button>
                </div>
            </form>

        </div>

        <div class="col-md-12">
            <h4>Notification Reminders</h4>

            <table class="table table-bordered">
                <thead>
                    <th> ID</th>
                    <th>Notification Type</th>
                    <th>Event Type</th>
                    <th>Time</th>
                  
                    <th class="text-center">Actions</th>
                </thead>
                <tbody id="notification_reminder_table_body"></tbody>
            </table>
        </div>

    </div>


    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
<style>
  .toggle.ios, .toggle-on.ios, .toggle-off.ios { border-radius: 20rem; }
  .toggle.ios .toggle-handle { border-radius: 20rem; }
</style>
<script>
    $(document).ready(function(){
        loadNotificationRemindersToTable();
    });
   
    
    function loadNotificationRemindersToTable() {
        $('.loader-remind').show();
        // Load Existing templates here using -> 'notification_type'
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/LoadNotificationReminders'); ?>',
            method: 'POST',
            dataType: 'json',
            data: {
                notification_type: $('#notifications_type').val()
            },
            success: function(response) {
                $('.loader-remind').hide();
              

                let _row = '';

                $.each(response, function(index, row) {
                    let data = {};

                    _row += `<tr data-id="${row.id}">
                        <td>${row.id}</td>
                        <td>${row.type.toUpperCase()}</td>
                        <td>${row.reminder} </td>
                        <td>${row.time} Hours</td>
                      
                        <td class="text-center">  
                        <input type="checkbox" class="checkbox"  data-on=""   data-size="sm" data-style="ios" data-off="" data-toggle="toggle" ${row.status == 1 ? 'checked' : ''}>
                
                    </td>
                        
                    </tr>`;
                    //console.log(row);
                });

                $('#notification_reminder_table_body').html(_row);
                $('.checkbox').bootstrapToggle() 
            },
            error: function(xhr, status, error) {

                console.error('Error:', error);
            }
        });
    }

   
    $(document).on('change', 'input[type="checkbox"][data-toggle="toggle"]', function() {
    var reminderId = $(this).closest('tr').data('id');  // Assuming reminder ID is stored in the row data attribute
    var isActive = $(this).is(':checked') ? 1 : 0;  // Get the status from the checkbox
   $('.loader-remind').show();
    $.ajax({
        url: '<?= base_url("index.php/admin/Setting/Configurations/ConfigurationsController/updateReminderStatus") ?>',
        method: 'POST',
        data: {
            id: reminderId,
            status: isActive
        },
        success: function(response) {
            var result = JSON.parse(response);
            $('.loader-remind').hide();
            if (result.status === 'success') {
                // You can show success message or update UI accordingly
               successNotification('Status Updated Successfully')
            } else {
                console.log('Failed to update status.');
            }
        },
        error: function() {
            $('.loader-remind').hide();
            console.log('Error updating status.');
        }
    });
});

    
   
</script>
<script>
    $(document).ready(function() {
        $('#save_reminder').click(function(e) {
            e.preventDefault();

            var notificationType = $('#notifications_type').val();
            var event_Type = $('#event_type_reminder').val();
            var time = $('#time').val();
          
            if (notificationType == '' || event_Type == '' || time == '') {
                Swal.fire('Error', 'Please fill in all the fields.', 'error');
                return;
            }

            // AJAX call to check if the same event type is already active with another channel
            $.ajax({
                url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/checkNotification') ?>',
                method: 'POST',
                data: {
                    type: notificationType,
                    event_type: event_Type
                },
                success: function(response) {
                    var result = JSON.parse(response);

                    if (result.status === 'exists') {
                        // If another channel exists for the same event type
                        Swal.fire({
                            title: 'Warning',
                            text: 'This event type already has another notification channel active. Do you want to use both?',
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonText: 'Yes, use both',
                            cancelButtonText: 'No, cancel'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Submit both channels
                                $('#notification_reminder_form').submit();
                            }
                        });
                    } else {
                        // Submit the form if no existing notification for the same event type
                        $('#notification_reminder_form').submit();
                    }
                },
                error: function() {
                    Swal.fire('Error', 'Something went wrong. Please try again.', 'error');
                }
            });
        });
    });
</script>