<section class="content">
            <div class="row">
               <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="car-header">
                                <h3 class="card-title">New Packages</h3>
                            </div>
                            <?php
                                // Separate packages by type
                                $whatsappPackages = array_filter($packages, function($item) {
                                    return $item['type'] == 1;
                                });

                                $smsPackages = array_filter($packages, function($item) {
                                    return $item['type'] == 0;
                                });?>
                            <div class="row">
                                <div class="col-md-12">
                                <h3 class="btn btn-light text-center d-block">Whatsapp Packages</h3>
                                </div>
                                
                            <?php foreach($whatsappPackages as $item) { ?>
                                    <div class="col-md-3 mt-2">
                                    <div class="card border-info">
                                        <div class="card-body text-center">
                                            <h1 class="ri ri-whatsapp-fill mb-3" style="font-size: 3rem; color: #25D366;"></h1>
                                            <h3 class="card-title fw-bold"><?= $item['name'] ?> </h3>
                                            <h5 class="card-text mb-1 fw-bold"><b>(<?=  $item['min_value'].'-'.$item['max_value']  ?><sup>Message</sup>)</b></h5>
                                            <p class="card-text fw-bold"><?= $item['price'] ?> - QR/message</p>

                                            <a href="javascript:void(0);" class="btn btn-dark btn-sm subscribe-btn" data-type="<?= $item['type']  ?>" data-price="<?=  $item['price'] ?>"   data-total="<?=  $item['max_value']  ?>" data-toggle="modal" data-target="#subscribeModal" data-package-id="<?= $item['id'] ?>"><i class="fa fa-plus mr-2"></i>Purchase</a>
                                                   
                                              
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                            </div>
                            <!-- SMS Packages Row -->
                            <div class="row mt-4">
                            <div class="col-md-12">
                                <h3 class="btn btn-light text-center d-block">SMS Packages</h3>
                                </div>
                                <?php foreach($smsPackages as $item) { ?>
                                    <div class="col-md-3 mt-2">
                                    <div class="card border-info">
                                        <div class="card-body text-center">
                                            <h1 class="fa fa-comment mb-3" style="font-size: 3rem; color: #25D366;"></h1>
                                            <h3 class="card-title"><?= $item['name'] ?></h3>
                                            <h5 class="card-text mb-1 fw-bold"><b>(<?=  $item['min_value'].'-'.$item['max_value']  ?><sup>SMS</sup>)</b></h5>
                                            <p class="card-text fw-bold"><?= $item['price'] ?> - QR/sms</p>
                                           
                                                    <a href="javascript:void(0);" class="btn btn-dark btn-sm subscribe-btn" data-type="<?= $item['type']  ?>" data-price="<?=  $item['price'] ?>"    data-total="<?=  $item['max_value']  ?>" data-toggle="modal" data-target="#subscribeModal" data-package-id="<?= $item['id'] ?>"><i class="fa fa-plus mr-2"></i>Purchase</a>
                                            
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
               </div>
            </div>
        </section>

        <!-- Modal Structure -->
<div class="modal fade" id="subscribeModal" tabindex="-1" role="dialog" aria-labelledby="subscribeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="subscribeModalLabel">Purchase Package</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="subscribeForm" method="POST" action="<?php echo base_url('admin/WhatsappController/subscribe')  ?>">
        <div class="modal-body">
          <div class="form-group">
            <label for="messagesCount">Number of Messages</label>
            <input type="number" class="form-control" id="messagesCount" name="messages_count" required>
            <input type="hidden" id="packageId" name="package_id">
            <input type="hidden" id="amount" name="amount">
            <input type="hidden" id="price" name="price">
            <input type="hidden" id="type" name="type">
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-dismiss="modal"><i class="fa fa-close mr-1"></i>Close</button>
          <button type="submit" class="btn btn-light"> Pay</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$(document).ready(function() {
    $('#subscribeModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget); // Button that triggered the modal
        var packageId = button.data('package-id');
        var total = button.data('total');
        var price= button.data('price');
        var type= button.data('type');
        var modal = $(this);
        modal.find('#packageId').val(packageId);
        modal.find('#messagesCount').val(total).attr('max',total);
        modal.find('#price').val(price);


        if(type == 1){
            type ='whatsapp_package'
        }else{
            type ='sms_package'
        }
        modal.find('#type').val(type);

        var amount = parseFloat(price) * parseInt(total);
       
        modal.find('#amount').val(amount);
 
    });

    $('#messagesCount').keyup(function(){
       
        var msgs= $(this).val();
        
        var price =$('#price').val();
        var amount = parseFloat(price) * parseInt(msgs);
        $('#amount').val(amount);
    })
       
   


    $('#subscribeForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        var form = $(this);
        var amount = $('#amount').val();
        var packageId = $('#packageId').val();
        var messagesCount = $('#messagesCount').val();
        var type = $('#type').val();

        // Construct the payment gateway URL
        var paymentUrl = "<?php echo base_url('admin/SkipCash/PaymentController/index') ?>";
        var formData = {
            amount: amount,
            package_id: packageId,
            messages_count: messagesCount,
            type: type
        };

        // Open the payment gateway URL in a new window
        var form = $('<form>', {
            action: paymentUrl,
            method: 'POST',
            target: '_blank'
        });

        $.each(formData, function(key, value) {
            form.append($('<input>', {
                type: 'hidden',
                name: key,
                value: value
            }));
        });

        $('body').append(form);
        form.submit();
  
    });
});
</script>
