<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title> Site Images</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

        <!--image crop-->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
        <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Site Images
                    <small><?php echo $_id > 0 ? 'Update' : 'Creat New' ?></small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

            <!-- Main content -->
            <form id="submitForm" name ="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/SiteImages/SiteImagesController/save') ?>" method="post" >
    <section class="content"> 
      
      <!--buttons-->
      
      <div class="row">
        <div class="col-xs-12">
          <div class="box box-solid">
            <div class="box-body">
              <div class="row"> <!-- Form Buttons   -->
                
                <div class="col-md-1">
                  <a href="<?php echo base_url('index.php/admin/SiteImages/SiteImagesController') ?>" class="btn btn-info"><i class="fa fa-angle-left"></i> Go back </a>
                </div>
                <div class="col-md-9">
                  <?php if (validation_errors()) { ?>
                  <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                    <div>
                      <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p></div>
                  </div>
                  <?php } ?>
                </div>
			    <div class="col-md-2 text-right">
                  
                  <a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class=" btn btn-success "> <?php echo $_id > 0 ? 'Update Site' : 'Save Site' ?></a> 
					
				</div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--//buttons--> 
      
      <!--form-->
      <div class="row">
        <div class="col-xs-12">
          <div class="box box-info" style="margin-bottom: 5px;">
            <div class="box-header with-border">
              	<h2 class="box-title">Site Image details</h2>
				<div class="pull-right box-tools">
					<div class="btn-group">
					  <button class="btn btn-info btn-sm" data-widget="collapse"><i class="fa fa-minus"></i></button>
					</div>
			  	</div>
            </div>
            <div class="box-body">
				<div class="row">
				<div class="col-md-8">
					
					<div class="form-group <?php echo form_error("title") ? "has-error" : "" ?>">
						<label>Title</label>
							<input id="title" name="title" value="<?php echo $title; ?>" type="text" class="form-control" placeholder="Enter Title..."/>
						<label><small><?php echo form_error("title"); ?></small></label>
					</div>
					 <div class="form-group <?php echo form_error("description") ? "has-error" : "" ?>">
						<label>Description</label>
							<textarea id="discription" name="description" type="text" value=""   class="form-control"  placeholder="Enter ..."><?php echo $description; ?></textarea>
						<label><small><?php echo form_error("description"); ?></small></label>
                     </div>
					
					<div class="form-group <?php echo form_error("site_image_type") ? "has-error" : "" ?>">
						  <label>Image Type</label>
						  <select data-control="image_type_change" id="site_image_type" name="site_image_type" class="form-control selectpicker"  placeholder="Enter ..." data-live-search="true"/>

							<option  value="0" <?php echo $site_image_type == 0 ? 'selected' : '' ?>  >Select</option>
						
							<?php foreach ($site_images->result() as $value) { ?>

								<option  value="<?php echo $value->site_image_type_id ?>" <?php echo $value->site_image_type_id == $site_image_type ? 'selected' : '' ?>  ><?php echo $value->image_type ?></option>

							<?php } ?>
						
						  </select>
						  <label><small><?php echo form_error("site_image_type"); ?></small></label>
                    </div>  
					
				</div>

					<div class="col-md-4">
						<div class="form-group <?php echo form_error("item_image") ? "has-error" : "" ?>" style="width: 250px;">
							<label class="file-control">
								<input type="file" data-control="image_uploader" size="60" >
								<div class="dv-logo">
									<div class="center" style="position: absolute;top: 0;left: 0;height: 100%;width: 100%;">
										<div class="dv-hover center" style="margin: 0px;">
											<i class="fa fa-image"></i>
										</div>
									</div>

									<div class="dv-result-logo" style="width: 250px;">

										<img class="result-logo" id="result" name="result" src="<?php echo $is_new_image == 'true' ? $item_image : base_url($item_image) ?><?php echo '?'.(new DateTime($updated_datetime))->format('YmdHis'); ?>"">
									</div>
								</div>
							<small><?php echo form_error("item_image"); ?></small></label> 
						</div>
						
						<div class="form-group" style="min-height: 0px;padding-left: 10px;">
							<label><input type="checkbox" id="is_active" name="is_active" value="active" <?php echo $is_active == 'active' ? 'checked' : '' ?> > Is active</label>

						  <label><small><?php echo form_error("is_active"); ?></small></label>
						</div
						
					</div>
					
          </div>
						
		 <div class="row">
			  <div class="col-md-7"></div>
			  <div class="col-md-4">
				 <div class="form-group" style="width: 250px;">
					 <div id="crop-image" class="box-body"></div>
				 </div>
			  </div>
			  <div class="col-md-1"></div>
		  </div>					
						
        </div>
      </div>
		  </div>
		</div>
      
      <!--tables-->
      
     
    </section>
	<input type="hidden" id="_id" name="_id" value="<?php echo $_id; ?>">
	<input type="hidden" id="item_image" name="item_image" value="<?php echo $item_image; ?>">
	<input type="hidden" id="is_new_image" name="is_new_image" value="<?php echo $is_new_image; ?>">
	<input type="hidden" id="width" name="width" value="<?php echo $width; ?>">
	<input type="hidden" id="height" name="height" value="<?php echo $height; ?>">
	<input type="hidden" id="boundary_width" name="boundary_width" value="<?php echo $boundary_width; ?>">
	<input type="hidden" id="boundary_height" name="boundary_height" value="<?php echo $boundary_height; ?>">
	<input type="hidden" id="updated_datetime" name="updated_datetime" value="<?php echo $updated_datetime ?>">
	
		
	
  </form>
            
        </div>

        <!-- ./wrapper -->


        <?php require_once(APPPATH . "views/admin/footer.php"); ?>


    </body>
</html>

<script>

	$(document).on('change', '[data-control=image_uploader]', function(e){
			
		readURL(this);
			
		}); 
	
	
	function readURL(input) {
	   if (input.files && input.files[0]) {
			var reader = new FileReader();
				reader.onload = function (e) {

				$('#croppie_modal').on('shown.bs.modal', function() {

					document.getElementById('croppie_image').innerHTML = "<div class='form-group center' ><img id='upload_image' src='#' /></div>";

					document.getElementById('croppie_footer').innerHTML = "<div class='form-group' style='min-height:0px;'><a id='use' class='image-select btn-primary'><i class='fa fa-crop' style='margin-right: 8px;'></i> CROP</a></div>";

					var boundary_width  = '<?php echo $boundary_width; ?>';
					var boundary_height  = '<?php echo $boundary_height; ?>';
					var width  = '<?php echo $width; ?>';
					var height  = '<?php echo $height; ?>';

					$('#upload_image').attr('src', e.target.result);

					var imageSize = {
									        width: width,
									        height: height,
									        type: 'square'
									};

					var resize = new Croppie($('#upload_image')[0], {
						viewport: {width: width/5, height: height/5},
						boundary: {width: boundary_width/5 , height: boundary_height/5},
						showZoomer: false,
						enableResize: false,
						enableOrientation: true
						
					});



					$('#use').fadeIn();


					$('#use').on('click', function () {
						resize.result(
								{
									type: "base64",
									size: imageSize,
									format: "png", 
									quality: 1
								}
							).then(function (dataImg) {
							var data = [{image: dataImg}, {name: 'myimgage.jpg'}];

							$('#result').attr('src', dataImg);

							$('#item_image').val(dataImg);
							$('#is_new_image').val('true');


							$("#croppie_modal").modal("hide");

						});
					});


					});

					$("#croppie_modal").modal("show");

			}
				reader.readAsDataURL(input.files[0]);
	}
	}

	$(document).on('change', '[data-control=image_type_change]', function(e){
			
		document.getElementById('submitForm').action = '<?php echo base_url('index.php/admin/SiteImages/SiteImagesController/image_type_change') ?>';
			document.getElementById('submitForm').target= '_parent'; 
			document.getElementById('submitForm').submit(); return false;
			
		}); 
		


</script>








