<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Users
                    <small>Create/Edit Users</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-xs-12">
                           <?php if($add_user == 1) { ?>
                        <div class="box margin-bottom-5px box-warning">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-10">

                                        <?php if (validation_errors()) { ?>
                                            <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
    <!--                                                      <i class="icon fa fa-warning"></i>-->
                                                <div>
                                                    <?php echo validation_errors(); ?> 
                                                </div>
                                            </div>
                                        <?php } ?>

                                    </div>
                                    <div class="col-md-2">
                                       
                                        <a href="<?php echo base_url('index.php/admin/Users/UsersController/CreateNew') ?>" class="btn btn-block btn-social <?php echo $this->config->item('add_new'); ?>">
                                            <i class="fa fa-plus"></i> New user
                                        </a>
                                       
                                    </div>
                                </div>	
                            </div><!-- /.box-body -->
                        </div>
                        <?php } ?>
                        <div class="box box-info">
                            <div class="box-body">
                                <table id="search_grid" class="table table-bordered table-striped">
                                    <thead>
                                         <tr class="<?php echo $this->config->item('grid_header'); ?>">
                                            <th class="hide">#</th>
                                            <th>User name</th>
                                            <th>Full name</th>
                                            <th>Description</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($user->result() as $row) { ?>
                                            <tr>
                                                <td class="hide"><?php echo $row->user_Id; ?></td>
                                                <td> <?php echo $row->user_name; ?></td>
                                                <td> <?php echo $row->full_name; ?></td>
                                                <td> <?php echo $row->user_description; ?></td>
                                                <td class="col_20">
                                                   <?php if($reset_user_password == 1) { ?>
                                                    <button type="submit" data-toggle="modal" data-target="#ChangePass_<?php echo $row->user_Id; ?>" 
                                                            id="changepass" 
                                                            class="btn <?php echo $this->config->item('grid_changepass_btn'); ?>">Change password</button>
                                                    <?php } ?>
                                                    <a class="btn btn-social-icon btn-instagram btn-grid" 
                                                       data-toggle="tooltip" data-placement="bottom" 
                                                       href="<?php echo site_url('admin/Users/UsersController/Load/') . $row->user_Id; ?>"
                                                       title="Edit"><i class="fa  fa-edit"></i></a>
                                                </td>

                                                <!--    Change password  Start **************************************************************-->
                                        <div class="container">

                                            <div class="modal fade "  name="ChangePass_<?php echo $row->user_Id; ?>" id="ChangePass_<?php echo $row->user_Id; ?>" role="dialog">
                                                <div class="modal-dialog">
                                                    <div class="modal-content" align="left">
                                                        <div class="modal-header">
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                            <h4 class="modal-title">Change Password</h4>
                                                        </div>

                                                        <form action="<?php echo base_url('index.php/admin/Users/UsersController/changePassword/') . $row->user_Id; ?>" method="post" id="changePasswordnew_<?php echo $row->user_Id; ?>" name="changePasswordnew_<?php echo $row->user_Id; ?>">                    
                                                            <div class="modal-body">
                                                                <div id="change_password_data">
                                                                    <div class="form-group">
                                                                        <label>Password</label>
                                                                        <input id="Password_<?php echo $row->user_Id; ?>" name="Password_<?php echo $row->user_Id; ?>" type="password"    type="text" class="form-control" placeholder="Enter ..."/>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label>Confirm Password</label>
                                                                        <input id="ConfirmPassword_<?php echo $row->user_Id; ?>" name="ConfirmPassword_<?php echo $row->user_Id; ?>" type="password"  type="text" class="form-control" placeholder="Enter ..."/>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="Mdl_btn btn btn-default change_password_new">
                                                                    <i class="glyphicon glyphicon-floppy-disk"></i>&nbsp;&nbsp;Save</button>
                                                                <button type="button" class="Mdl_btn btn btn-default" data-dismiss="modal"><i class="glyphicon glyphicon-remove"></i>&nbsp;&nbsp;Close</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!--      Change password  End **************************************************************-->

                                        </tr>
                                    <?php } ?>
                                    </tbody>

                                </table>
                            </div><!-- /.box-body -->
                        </div><!-- /.box -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </section>

        </div><!-- /.content-wrapper -->



        <!-- ./wrapper -->
        <?php require_once(APPPATH . "views/admin/footer.php"); ?>

    </body>
</html>


