<style>
        /* Overall widget container */
        #chat-widget {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 439px;
            min-height: 520px;
            max-height: 90%;
            border-top-left-radius: 15px;
            border-top-right-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            background-color: #fff;
            overflow: hidden;
            z-index: 3;
            height: 400px;
            display: none;
          
        }

#resizer {
    width: 100%;
    height: 10px; /* Height of the resizer */
    background: transparent; /* Make it invisible */
    position: absolute;
    top: -5px; /* Position it slightly above the header */
    cursor: ns-resize; /* North-South resize cursor */
    z-index: 1; /* Ensure it's on top */
}


        /* Chat Header */
        #chat-header {
            background-color: #084a6a;
            color: #fff;
            padding: 10px;
            border-radius: 15px 15px 0 0;
            font-size: 18px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        #chat-header .close-btn {
            color: #fff;
            cursor: pointer;
        }

        /* User list area */
        #cuserlist {
            list-style: none;
            padding: 0;
            margin: 0;
            max-height: 90%;
            overflow-y: auto;
        }

        .user-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px 15px;
            border-bottom: 1px solid #f1f1f1;
            cursor: pointer;
            transition: background-color 0.2s;
            padding: 20px;
        }

        .user-item:hover {
            background-color: #f1f1f1;
        }

        /* User profile and status */
        .user-item .user-info {
            display: flex;
            align-items: center;
        }

        .user-item img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            margin-right: 10px;
        }

        .user-item .username {
            font-weight: 600;
            font-size: 16px;
        }

        .user-status {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            margin-left: 5px;
            display: inline-block;
        }

        .online {
            background-color: #28a745;
        }

        .offline {
            background-color: #c71d1d;
        }

        /* Chat body section */
        #chat-body {
            display: none; /* Initially hidden */
            padding: 15px;
            max-height: 100%;
            height: 78%;
            overflow-y: auto;
            font-size: 14px;
        }

        #chat-body p {
          
            border-radius: 5px;
            margin-bottom: 10px;
        }

        /* Chat input section */
        #chat-footer {
            display: none; /* Initially hidden */
            
          
            height: 20%;
            margin-bottom: 10px;
        }

        #chat-footer input {
            width: 100%;
            border-radius: 20px;
            padding: 10px;
            border: 1px solid #ddd;
        }

        /* Chat Toggle Button */
        #chat-toggle-btn {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background-color: #007bff;
            color: #fff;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            font-size: 24px;
            z-index: 2;
        }
        #chat-body {
    max-height: 78%; /* Adjust based on your layout */
    overflow-y: auto;
    padding: 10px;
    border: 1px solid #ccc;
}

.message {
    margin-bottom: 10px;
    padding: 10px;
    border-radius: 5px;
    min-width: 52%;
    max-width: 80%;
    display: flex;
    flex-direction: column;
    position: relative;
}

.message.read {
    /* Blue border */
}

.message.unread {
     /* Red border */
}

.message-time {
    font-size: 12px;
    color: #888;
}
.message-sent {
  /* Light green for sent messages */
    float: right; /* Align sent messages to the right */
    text-align: right; /* Text alignment for sent messages */
    color: white;
}

.message-received {
   /* Light gray for received messages */
    float: left; /* Align received messages to the left */
    text-align: left; /* Text alignment for received messages */
}
.bg-received{
  
    background-color: #f1f0f0;
    border-radius: 7px;
    padding: 10px 15px;
   
}
.bg-sent{
  
    background-color: #4c9fed; 
    border-radius: 7px;
    padding: 10px 15px;
    margin-left: auto;
}
/* Tail for sent messages */
.bg-sent:after {
    content: "";
    position: absolute;
    right: 0px;
    top: 10px;
    border-width: 10px;
    border-style: solid;
    border-color: #4c9fed transparent transparent #dcf8c600;
}



/* Tail for received messages */
.bg-received:before {
    content: "";
    position: absolute;
    left: 1px;
    top: 10px;
    border-width: 10px;
    border-style: solid;
    border-color: #f1f0f0 #ffffff00 transparent transparent;
}

/* Time styling */
.message-time {
    font-size: 12px;
    color: #999;
    margin-top: 5px;
    align-self: flex-end;
}

.read-tick {
    font-size: 10px;
    color: #919496;
    margin-left: 5px;
}
.profile-initials{
    width: 50px;
    height: 50px;
    border-radius: 100%;
 
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 17px;
    margin-right: 10px;
    color: white;
}
.unread-count {
    background-color: red;
    color: white;
    font-size: 12px;
    padding: 2px 6px;
    border-radius: 12px;
    margin-left: 10px;
}

/* Highlight users with unread messages */
.user-item.has-unread {
    background-color: #f9f9f9;
    font-weight: bold;
}

/* Style for online/offline indicator */
.user-status.online {
    color: green;
}

.user-status.offline {
    color: gray;
}
#chat-body::-webkit-scrollbar {
    width: 8px; /* Width of the scrollbar */
    height: 8px; /* Height of the scrollbar */
}

#chat-body::-webkit-scrollbar-track {
    background: #f1f1f1; /* Background of the scrollbar track */
    border-radius: 10px; /* Rounded corners */
}

#chat-body::-webkit-scrollbar-thumb {
    background: #888; /* Color of the scrollbar thumb */
    border-radius: 10px; /* Rounded corners */
}

#chat-body::-webkit-scrollbar-thumb:hover {
    background: #555; /* Color of the thumb on hover */
}

/* Custom scrollbar for Firefox */
#chat-body {
    scrollbar-width: thin; /* Use thin scrollbar */
    scrollbar-color: #888 #f1f1f1; /* thumb color and track color */
}
#cuserlist {
    scrollbar-width: thin; /* Use thin scrollbar */
    scrollbar-color: #888 #f1f1f1; /* thumb color and track color */
}
#new-message-indicator {
    position: absolute;
    top: 5px; /* Adjust the position of the indicator */
    right: 5px; /* Adjust the position of the indicator */
    width: 10px;
    height: 10px;
    background-color: #6ff13e;
    border-radius: 50%;
    font-size: 10px;
    display: flex;
    justify-content: center;
    align-items: center;
}
.userdiv{
display: flex;
flex-direction: column;
}
.usermessage{
font-size: 12px;

}
.blinking {
    animation: blinker 1.5s linear infinite;
}

@keyframes blinker {
    50% {
        opacity: 0;
    }
}


.search-container {
    position: relative;
    width: 100%; /* Adjust the width as needed */
}

.chat-search {
    padding-right: 30px;
    text-indent: 15px;
    /* Make space for the icon */
}

.search-icon {
    position: absolute;
    top: 50%; /* Center the icon vertically */
    left: 10px; /* Position it inside the input field */
    transform: translateY(-50%); /* Center the icon vertically */
    color: #999; /* Change color as needed */
    pointer-events: none; /* Prevent clicking on the icon */
}
    </style>
    
</head>
<body>

<!-- Chat Widget -->
<div id="chat-widget">

    <div id="chat-header">
    <div id="resizer"></div>
        <a href="javascript:void(0)" id="back_button" class="text-white" style="display: none;"><i class="fa fa-angle-left"></i></a>
        <span id="chat-title">Chat with a user</span>
        <span class="close-btn">&times;</span>
    </div>

    <!-- User list -->
    <div class="search-container">
    <input type="text" class="form-control chat-search" placeholder="Search Username" name="search" id="userSearch">
    <span class="search-icon">
        <i class="fa fa-search"></i> <!-- Font Awesome icon -->
    </span>
</div>
    <ul id="cuserlist">
        <!-- User items will be dynamically generated here -->
    </ul>
    <input type="hidden" id="selected-user_val" value="">
    
    <!-- Chat body -->
    <div id="chat-body">
      
        <p id="welcome-msg">Start chatting with <span id="selected-user"></span>!</p>
        <!-- Chat messages will appear here -->
    </div>

    <!-- Chat input -->
    <div id="chat-footer">
    <input type="text" class="form-control" id="chat-input" placeholder="Type your message...">
   
   <!-- Emoji picker -->
    </div>
</div>

<!-- Chat Toggle Button -->
<div class="position-relative">
<div id="chat-toggle-btn">
    <i class="fa fa-comment"></i>
    <span id="new-message-indicator" style="display: none;">●</span> <!-- Notification indicator -->
</div>
</div>
<script>
     new lc_emoji_picker('#chat-input', {
            trigger_position    : {
                top : '6px',
                right: '5px',
            },
            target_r_padding    : 28,
            use_noto_emojis     : true,
            selection_callback  : function(emoji, target_field) {
                console.log(emoji, target_field);
            },
        });
</script>
<script>
function showNewMessageIndicator() {
    const indicator = document.getElementById('new-message-indicator');
    const chatToggleBtn = document.getElementById('chat-toggle-btn');
    indicator.style.display = 'flex'; // Show the notification indicator
    indicator.classList.add('blinking'); // Add blinking effect to the button
    
}

// Function to hide the indicator when the chat is opened
function hideNewMessageIndicator() {
    const indicator = document.getElementById('new-message-indicator');
    const chatToggleBtn = document.getElementById('chat-toggle-btn');
    indicator.style.display = 'none'; // Hide the notification indicator
    indicator.classList.remove('blinking'); // Remove blinking effect
}
function getRandomDarkColor() {
    const letters = '01234567'; // Use only digits from 0 to 7 to keep the color dark
    let color = '#';
    for (let i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 8)]; // Random value between 0 and 7
    }
    return color;
}
    // Emit user connection with userId when connecting
    const userId = '<?php echo  $this->session->userdata('user_Id'); ?>'; // Replace with actual user ID
    socket.emit('chatuserConnected', userId);
    
    socket.on('updateUserListOnline', (user_id) => {
    // Find the user item by its data-id attribute
    const $userItem = $(`.user-item[data-id="${user_id}"]`);
    
    if ($userItem.length > 0) {
        // Check if the user is online and add/remove the necessary class
        const $userStatus = $userItem.find('.user-status');

        // Update the status to 'online'
        $userStatus.removeClass('offline').addClass('online');

        // Optionally, you could highlight the user in the list by adding a class
        $userItem.addClass('user-online');
    }
});
    // Listen for user list updates

    let allUsers = [];
    socket.on('updateUserList', (users) => {
    const userListElement = document.getElementById('cuserlist');
    userListElement.innerHTML = ''; // Clear the existing user list

    // Convert users to array if necessary and store it
    allUsers = Array.isArray(users) ? users : Object.values(users);
    renderUserList(allUsers);
});


function renderUserList(userArray) {
    
        const userListElement = document.getElementById('cuserlist');
        userListElement.innerHTML = ''; // Clear the existing user list

        userArray.forEach(user => {
            if(user.userId != userId){

           
            const listItem = document.createElement('li');
            listItem.className = 'user-item';
            listItem.setAttribute('data-username', user.fullName);
            listItem.setAttribute('data-id', user.userId);
           
            // Create user info div
            const userInfoDiv = document.createElement('div');
            userInfoDiv.className = 'user-info';

            // Create user image
            const profileDiv = document.createElement('div');
        profileDiv.className = 'profile-initials'; // Style for circular div
        profileDiv.textContent = user.fullName.charAt(0).toUpperCase() + user.fullName.charAt(1).toUpperCase();
        profileDiv.style.backgroundColor = getRandomDarkColor();
            // Create username span
            const usernameDiv = document.createElement('div');
            usernameDiv.className = 'userdiv';

            const usernameSpan = document.createElement('span');
            usernameSpan.className = 'username';
            usernameSpan.textContent = user.fullName;
            const messagespan = document.createElement('span');
            messagespan.className = 'usermessage';
            messagespan.textContent = user.lastMessage ??  'Say Hyee!';
            
            const userStatusSpan = document.createElement('span');
            userStatusSpan.className = 'user-status ' + (user.online ? 'online' : 'offline');

            // Append image and username to user info div
            userInfoDiv.appendChild(profileDiv);
            userInfoDiv.appendChild(usernameDiv);
            usernameDiv.appendChild(usernameSpan);
            usernameSpan.appendChild(userStatusSpan);
            usernameDiv.appendChild(messagespan);


            // Create user status span
          
           
            if (user.count && user.count > 0) {
          
                showNewMessageIndicator();
            const unreadCountSpan = document.createElement('span');
            unreadCountSpan.className = 'unread-count'; // Style for unread message count
            unreadCountSpan.textContent = user.count;

            // Add unread count span next to username
            userInfoDiv.appendChild(unreadCountSpan);

            // Highlight user with unread messages
            listItem.classList.add('has-unread');
        }
            // Append user info div and status span to list item
            listItem.appendChild(userInfoDiv);
          

            // Append list item to user list
           
            userListElement.appendChild(listItem);
            }else{

            }
        });
    };

    const userSearchInput = document.getElementById('userSearch');
userSearchInput.addEventListener('input', function () {
    const searchTerm = this.value.toLowerCase();

    // Filter users based on search term
    const filteredUsers = allUsers.filter(user => user.fullName.toLowerCase().includes(searchTerm));

    // Sort matching users to the top and render the list
    const sortedUsers = [
        ...filteredUsers,
        ...allUsers.filter(user => !user.fullName.toLowerCase().includes(searchTerm))
    ];

    renderUserList(sortedUsers);
});
</script>
<script>
    let activeChatUserId = null;
    // Toggle chat widget visibility
    $('#chat-toggle-btn').on('click', function() {
        $('#chat-widget').toggle();
        hideNewMessageIndicator();
        socket.emit('updateUserListSing');
    });

    // Close chat widget
    $('.close-btn').on('click', function() {
      
        $('#chat-title').text('Chat with Users');
        $('#selected-user').text('');
        $('#chat-body, #chat-footer').hide();
        $('#cuserlist').show();
        $('#back_button').hide();
        $('#chat-widget').hide();
        activeChatUserId = 0;
    });
    let currentUserId =null;
    // Show chat when a user is selected from the list
    $(document).on('click','.user-item', function() {
        var username = $(this).data('username');
        var user_id = $(this).data('id');
        
        // Update chat header and body
        $('#chat-title').text('Chat with ' + username);
        $('#selected-user').text(username);
        $('#selected-user_val').val(user_id);
        $('#back_button').show();
        activeChatUserId = user_id;
        currentUserId = userId;
        // Show chat body and footer
        $('#chat-body, #chat-footer').show();
        $('#cuserlist').hide(); // Hide the user list after selection
     // Replace with the actual ID of the logged-in user
    fetchMessages(currentUserId, user_id);
    });
    $(document).on('click','#back_button',function(){
        $('#chat-title').text('Chat with Users');
        $('#selected-user').text('');
        $('#chat-body, #chat-footer').hide();
        $('#cuserlist').show();
        $('#back_button').hide();
        activeChatUserId = 0;
        socket.emit('updateUserList');
    })

    // Function to fetch messages from the server
function fetchMessages(fromUserId, toUserId) {
    socket.emit('fetchMessages', { fromUserId, toUserId });
}

// Listen for received messages
socket.on('receiveMessages', (messages) => {
   
    displayMessages(messages);
});
socket.on('receiveMessage', (message) => {
    const isCurrentUserSenderOrReceiver = 
        (message.m_from == activeChatUserId && message.m_to == currentUserId) ||
        (message.m_from == currentUserId && message.m_to == activeChatUserId);

       
        if (isCurrentUserSenderOrReceiver) {
          
        displayMessage(message);

        // Mark the message as read if it's from the current active chat user
        if (message.m_from == activeChatUserId) {
            socket.emit('markAsRead', { messageId: message.id });
            
        }
    } else {
        const userList = $('#cuserlist');
        const listitem = userList.find(`.user-item[data-id="${message.m_from}"]`);
    
        if (listitem.length > 0) {
            let unreadCountSpan = listitem.find('.unread-count');

            if (unreadCountSpan.length === 0) {
            unreadCountSpan = $('<span class="unread-count">0</span>');
            listitem.find('.user-info').append(unreadCountSpan);
        }
              let spanText = unreadCountSpan.text();
                let count = (spanText !== '' && !isNaN(spanText)) ? parseInt(spanText) + 1 : 1;
                unreadCountSpan.text(count);
                showNewMessageIndicator();
        }
      
        
    }
    playsound();
  
});
socket.on('markedAsRead', (message) => {

    markAsReadUI(message);
});
//for single message
function displayMessage(message) {
    const chatBody = $('#chat-body');
    // Clear previous messages

    
    const messageClass = message.is_read ? 'message read' : 'message unread';
        const alignmentClass = message.m_from == currentUserId ? 'message-sent' : 'message-received';
        const background_class = message.m_from == currentUserId ? 'bg-sent' : 'bg-received'; // Add alignment class
        let messagDiv='';
        if (message.m_from != currentUserId){
            messageDiv = `
            <div class="${messageClass} ${alignmentClass}">
                <div class="${background_class}">
                <p>${message.message}</p>
                </div>
                <span class="message-time">
    ${new Date(message.dt_updated).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}
</span>
             
            </div>
        `;
        }else{
            messageDiv = `
            <div class="${messageClass} ${alignmentClass}">
            <div class="${background_class}">
                <p>${message.message}</p>
                </div>
                <span class="message-time">
                    ${new Date(message.dt_updated).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}
                </span>
                ${message.is_read ? '<span class="read-tick">✔✔</span>' : ''}
            </div>
        `;
        }
       
        chatBody.append(messageDiv);
    

    // Scroll to the bottom of the chat body
    chatBody.scrollTop(chatBody[0].scrollHeight);
}
function markAsReadUI(message) {
    const chatBody = $('#chat-body');

    // Find the specific message using its ID
    const messageDiv = chatBody.find(`.message[data-id="${message}"]`);
   
    
     
        // Update the message class to indicate it's read
        messageDiv.removeClass('unread').addClass('read');

        // Update the message content with the read tick
        messageDiv.find('.read-tick').remove(); // Remove any existing tick
        messageDiv.append('<span class="read-tick">✔✔</span>');

        // Optionally update the timestamp if needed
        // messageDiv.find('.message-time').text(new Date(message.dt_updated).toLocaleTimeString());
   
}

//for multiple mesage
function displayMessages(messages) {
   
    const chatBody = $('#chat-body');
  // Clear previous messages
   
    if(messages.length > 0){
        chatBody.empty(); 
    }else{
        chatBody.empty(); 
        chatBody.html('  <p id="welcome-msg">Start chatting !</p>')
      

    }
    messages.forEach(message => {
        const messageClass = message.is_read ? 'message read' : 'message unread';
        const alignmentClass = message.m_from == currentUserId ? 'message-sent' : 'message-received';
        const background_class = message.m_from == currentUserId ? 'bg-sent' : 'bg-received';
        let messageDiv ='';
        if (message.m_from != currentUserId){
             messageDiv = `
            <div class="${messageClass} ${alignmentClass}">
                <div class="${background_class}">
                <p>${message.message}</p>
                </div>
                <span class="message-time">
    ${new Date(message.dt_updated).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}
</span>
             
            </div>
        `;
        }else{
             messageDiv = `
            <div class="${messageClass} ${alignmentClass}">
            <div class="${background_class}">
                <p>${message.message}</p>
                </div>
                <span class="message-time">
                    ${new Date(message.dt_updated).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}
                </span>
                ${message.is_read ? '<span class="read-tick">✔✔</span>' : ''}
            </div>
        `;
        }
       
        chatBody.append(messageDiv);
        if (message.m_from != currentUserId && !message.is_read) {
            
            socket.emit('message_read', { messageId: message.id });
            markAsReadUI(message.id);
        }
        
    });

    // Scroll to the bottom of the chat body
    chatBody.scrollTop(chatBody[0].scrollHeight);
}
socket.on('message_read_update', (data) => {
   
    markAsReadUI(data.messageId);
    
});
$(document).on('keypress', '#chat-input', function (e) {
  
    if (e.which === 13) { // Check for Enter key
      
        const message = $(this).val().trim();
        const toUserId = $('#selected-user_val').val(); // Assuming you have user ID stored
      
        if (message && toUserId) {
            const fromUserId = userId; // Get the current user's ID

            // Emit the sendMessage event
            socket.emit('sendMessage', { fromUserId, toUserId, message });

            // Clear the input field
            $(this).val('');
        }
    }
});

const chatWidget = document.getElementById('chat-widget');
const resizer = document.getElementById('resizer');

let isResizing = false;
let startY, startX, startHeight, startWidth;
let aspectRatio = 0; // Calculate the aspect ratio

// Mouse down event to start resizing
resizer.addEventListener('mousedown', (event) => {

    isResizing = true;
    startY = event.clientY; // Capture the starting Y position
    startX = event.clientX; // Capture the starting X position
    startHeight = chatWidget.offsetHeight; // Capture the starting height
    startWidth = chatWidget.offsetWidth; // Capture the starting width
    aspectRatio =chatWidget.offsetWidth / chatWidget.offsetHeight;
});

// Mouse move event to resize
window.addEventListener('mousemove', (event) => {
   
    if (!isResizing) return; // Do nothing if not resizing
   
    // Calculate new dimensions based on the mouse movement
    const newHeight = startHeight + (startY - event.clientY);
    const newWidth = newHeight * aspectRatio; // Maintain the aspect ratio
    console.log(newHeight +'='+ aspectRatio);
    if (newHeight > 100 && newWidth > 100) { // Minimum height and width limit
        chatWidget.style.height = `${newHeight}px`; // Set new height
        chatWidget.style.width = `${newWidth}px`; // Set new width
    }
});

// Mouse up event to stop resizing
window.addEventListener('mouseup', () => {
    isResizing = false;
});

function playsound(){
    var base_url ="<?php echo base_url(); ?>"
    const audio = new Audio(base_url+'uploads/notification.mp3');
    audio.play().catch(error => {
        console.error('Error playing audio:', error);
    });
}
</script>