<?php foreach ($template as $row) { ?>
    <?php if ($row->type == "text") { ?>

        <div class="col-md-3">	
            <div class="form-group <?php echo form_error("df_".$row->field_id) ? "has-error" : "" ?>">
                <label><?php echo $row->text ?></label>
                <input   id="df_<?php echo $row->field_id ?>" name="df_<?php echo $row->field_id ?>" 
                         type="<?php echo $row->data_type ?>"   
                         value="<?php echo $row->default_values ?>" class="form-control" 
                         placeholder="<?php echo $row->placeholder ?>"/>
                <label><small><?php echo form_error("df_".$row->field_id); ?></small></label>
            </div>
        </div>
    <?php } elseif ($row->type == "date") { ?>
        <div class="col-md-3">
            <div class="form-group <?php echo form_error("$row->field_id") ? "has-error" : "" ?>">
                <label><?php echo $row->text ?></label>
                <div id="input_<?php echo $row->field_id ?>" name="input_<?php echo $row->field_id ?>" class="input-group date">
                    <input id="df_<?php echo $row->field_id ?>" 
                           name="df_<?php echo $row->field_id ?>" 
                           type="text"
                           value="<?php echo $row->default_values; ?>"  
                           class="form-control" 
                           placeholder="<?php echo $row->placeholder ?>" readonly/>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
                </div>
                <label><small><?php echo form_error("$row->field_id"); ?></small></label>
            </div>
            <script type="text/javascript">
                $(document).ready(function () {
                    /*date time picker*/
                    $("#input_<?php echo $row->field_id ?>").datepicker({
                        autoclose: true,
                        todayHighlight: true,
                        format: 'yyyy-mm-dd'
                    }).datepicker('update', '<?php echo $row->default_values; ?>');

                });
            </script>
        </div>
    <?php } elseif ($row->type == "label") { ?> 
        <div class="col-md-3">	
            <div class="form-group">
                <label><?php echo $row->text ?></label>
                <label><?php echo $row->default_values ?></label>
            </div>
        </div>
    <?php } elseif ($row->type == "select") { ?> 
        <div class="col-md-3">	
            <div class="form-group <?php echo form_error("$row->field_id") ? "has-error" : "" ?>">
                <label><?php echo $row->text ?></label>
                <select class="form-control selectpicker" data-live-search="true" 
                        name="df_<?php echo $row->field_id ?>"  id="df_<?php echo $row->field_id ?>">
                    <option value="Select" ><?php echo $row->default_values ?></option>
                    <?php
                    if (strlen(trim($row->drop_down_options)) > 0) {
                        $values = explode(",", strlen(trim($row->drop_down_options)));
                        foreach ($values as $value) {
                            ?>
                            <option value="<?php echo $value ?>" ><?php echo $value ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
                <label><small><?php echo form_error("$row->field_id"); ?></small></label>
            </div>
        </div>
    <?php } elseif ($row->type == "textarea") { ?> 
        <div class="col-md-3">	
            <div class="form-group <?php echo form_error("$row->field_id") ? "has-error" : "" ?>">
                <label><?php echo $row->text ?></label>
                <textarea id="df_<?php echo $row->field_id ?>" name="df_<?php echo $row->field_id ?>"    
                          class="form-control" rows="3" placeholder="<?php echo $row->placeholder ?>"><?php echo $row->default_values; ?></textarea>
                <label><small><?php echo form_error("$row->field_id"); ?></small></label>
            </div>
        </div>
    <?php } elseif ($row->type == "checkbox") { ?> 
        <div class="col-md-3">	
            <div class="form-group <?php echo form_error("$row->field_id") ? "has-error" : "" ?>">
                <label>
                    <input id="df_<?php echo $row->field_id ?>" name="df_<?php echo $row->field_id ?>"  type="checkbox" class="flat-red" <?php echo $row->default_values; ?>/>
                    <?php echo $row->text ?>
                </label>
                <label><small><?php echo form_error("$row->field_id"); ?></small></label>
            </div>
        </div>
    <?php } ?> 
<?php } ?>
